<?php
/**
 *   @copyright Copyright (c) 2018 Quality Unit s.r.o.
 *   @author Martin Pullmann
 *   @package PostAffiliatePro
 *
 *   Licensed under the Quality Unit, s.r.o. Standard End User License Agreement,
 *   Version 1.0 (the "License"); you may not use this file except in compliance
 *   with the License. You may obtain a copy of the License at
 *   http://www.postaffiliatepro.com/licenses/license
 */

class MailChimpV3_Definition extends Gpf_Plugins_Definition  {

    public function __construct() {
        $this->codeName = 'MailChimpV3';
        $this->name = $this->_('MailChimp user synchronization v3');
        $this->description = $this->_('This plugin creates a new customer (or updates an existing) in a MailChimp list based on affiliate data.');
        $this->version = '3.2.2';
        $this->configurationClassName = 'MailChimpV3_Config';

        $this->addRequirement('PapCore', '5.7.6.1');

        $this->addImplementation('Core.defineSettings', 'MailChimpV3_Main', 'initSettings');
        $this->addImplementation('PostAffiliate.User.beforeSave', 'MailChimpV3_Main', 'updateUserInfo');
        $this->addImplementation('PostAffiliate.affiliate.firsttimeApproved', 'MailChimpV3_Main', 'firstTimeApprovedAffiliate');
    }
}
