<?php
/**
 *   @copyright Copyright (c) 2017 Quality Unit s.r.o.
 *   @author Lubomir Nikodem
 *   @package PostAffiliatePro
 *   @since Version 1.0.0
 *
 *   Licensed under the Quality Unit, s.r.o. Standard End User License Agreement,
 *   Version 1.0 (the "License"); you may not use this file except in compliance
 *   with the License. You may obtain a copy of the License at
 *   http://www.postaffiliatepro.com/licenses/license
 *
 */

/**
 * @package PostAffiliate
 */
abstract class GetResponseSignup_Client {

    const MAX_GET_RESPONSE_FIELD_NAME = 32;
    const MAX_GET_RESPONSE_FIELD_CONTENT = 255;

    protected $url = null;
    protected $apiKey;

    /**
     * @var Gpf_Log_Logger
     */
    private $logger;

    public function __construct($url, $apiKey = null) {
        $this->url = $url;
        $this->apiKey = $apiKey;
    }

    protected function getPluginName() {
        return 'GetResponseSignup';
    }

    public abstract function signup(Pap_Common_User $user, $oldEmail = null);

    public abstract function deleteContact($email);

    public abstract function changeEmail(Pap_Common_User $user, $oldEmail);

    protected function storeContactEmail($user) {
        $userAttr = $this->getUserAttributeObject();
        $userAttr->setAccountUserId($user->getAccountUserId());
        $userAttr->setName(GetResponseSignup_Main::GET_RESPONSE_CONTACT_EMAIL);
        $userAttr->setValue($user->getEmail());
        $userAttr->save();
    }

    private function getUserAttributeObject() {
        return new Gpf_Db_UserAttribute();
    }

    /**
     * @return Gpf_Log_Logger
     */
    private function getLogger() {
        if ($this->logger === null) {
            $this->logger = Pap_Logger::create(Pap_Common_Constants::TYPE_SIGNUP);
        }
        return $this->logger;
    }

    protected function log($message, $logLevel = Gpf_Log::DEBUG) {
        $this->getLogger()->log($this->getPluginName().': '.$message, $logLevel);
    }
}
