<?php
/**
 *   @copyright Copyright (c) 2019 Quality Unit s.r.o.
 *   @author Martin Svitek
 *   @package PostAffiliatePro
 *   @since Version 1.0.0
 *
 *   Licensed under the Quality Unit, s.r.o. Standard End User License Agreement,
 *   Version 1.0 (the "License"); you may not use this file except in compliance
 *   with the License. You may obtain a copy of the License at
 *   http://www.postaffiliatepro.com/licenses/license
 *
 */

/**
 * @package PostAffiliatePro
 */
class FastSpring_Config extends Gpf_Plugins_Config {

    const SECRET = 'FastSpringSecret';
    const DATA1 = 'FastSpringExtraData1';
    const DATA2 = 'FastSpringExtraData2';
    const DATA3 = 'FastSpringExtraData3';
    const DATA4 = 'FastSpringExtraData4';
    const DATA5 = 'FastSpringExtraData5';
    const CAMPAIGN_ID = 'FastSpringCampaignID';
    const TEST_MODE = 'FastSpringTestMode';

    protected function initFields() {
        $extraData = array(
                '0' => '',
                'customer_email' => 'Customer email', //events[0]->data->customer->email
                'customer_name' => 'Customer name', //events[0]->data->customer->first . ' ' . events[0]->data->customer->last
                'customer_company' => 'Customer company', //events[0]->data->customer->company
                'customer_phone' => 'Customer phone', //events[0]->data->customer->phone
                'customer_country' => 'Customer country', //events[0]->data->address->country
                'customer_currency' => 'Customer currency', //events[0]->data->currency
                'reference' => 'Order reference', //events[0]->data->reference
                'order' => 'Order ID',//events[0]->data->order
                'product' => 'Product name',//events[0]->data->items[x]->product
                'quantity' => 'Product quantity',//events[0]->data->items[x]->quantity
                'sku' => 'Product SKU'//events[0]->data->items[x]->sku
        );
        $this->addTextBox($this->_('HMAC SHA256 Secret'), self::SECRET, $this->_('The secret you have defined in your FastSpring webhook configuration. Leave empty if you did not define any secret in FastSpring. Read more about webhook secrets <a href="https://docs.fastspring.com/integrating-with-fastspring/webhooks#Webhooks-securityMessageSecret/Security" target="_blank">here</a>.'));
        $this->addListBox($this->_('Extra data 1'), self::DATA1, $extraData, $this->_('Choose a value for sale extra data 1.'));
        $this->addListBox($this->_('Extra data 2'), self::DATA2, $extraData, $this->_('Choose a value for sale extra data 2.'));
        $this->addListBox($this->_('Extra data 3'), self::DATA3, $extraData, $this->_('Choose a value for sale extra data 3.'));
        $this->addListBox($this->_('Extra data 4'), self::DATA4, $extraData, $this->_('Choose a value for sale extra data 4.'));
        $this->addListBox($this->_('Extra data 5'), self::DATA5, $extraData, $this->_('Choose a value for sale extra data 5.'));
        $this->addListBox($this->_('Force campaign'), self::CAMPAIGN_ID, $this->getCampaigns() , $this->_('Choose a campaign into which all commissions will be forced to save. Campaign will not be recognized automatically as usual.'));
        $this->addCheckBox($this->_('Test mode'), self::TEST_MODE, $this->_('Check if you wish to create commissions also on requests received from your store\'s test mode. If not checked only live events will create commissions.'));
    }

    /**
     * @service plugin_config write
     * @param Gpf_Rpc_Params $params
     * @return Gpf_Rpc_Form
     */
    public function save(Gpf_Rpc_Params $params) {
        $form = new Gpf_Rpc_Form($params);
        Gpf_Settings::set(self::SECRET, $form->getFieldValue(self::SECRET));
        Gpf_Settings::set(self::DATA1, $form->getFieldValue(self::DATA1));
        Gpf_Settings::set(self::DATA2, $form->getFieldValue(self::DATA2));
        Gpf_Settings::set(self::DATA3, $form->getFieldValue(self::DATA3));
        Gpf_Settings::set(self::DATA4, $form->getFieldValue(self::DATA4));
        Gpf_Settings::set(self::DATA5, $form->getFieldValue(self::DATA5));
        Gpf_Settings::set(self::CAMPAIGN_ID, $form->getFieldValue(self::CAMPAIGN_ID));
        Gpf_Settings::set(self::TEST_MODE, $form->getFieldValue(self::TEST_MODE));
        $recurringNotactive = '';
        if (!Gpf_Plugins_Engine::getInstance()->getConfiguration()->isPluginActive('RecurringCommissions')) {
            $recurringNotactive = $this->_('%s feature is not active, recurring payments won\'t be tracked.', $this->_('Recurring Commissions'));
        }
        $form->setInfoMessage($this->_('FastSpring settings saved.') . $recurringNotactive);
        return $form;
    }

    /**
     * @service plugin_config read
     * @param Gpf_Rpc_Params $params
     * @return Gpf_Rpc_Form
     */
    public function load(Gpf_Rpc_Params $params) {
        $form = new Gpf_Rpc_Form($params);

        $form->addField(self::SECRET, Gpf_Settings::get(self::SECRET));
        $form->addField(self::DATA1, Gpf_Settings::get(self::DATA1));
        $form->addField(self::DATA2, Gpf_Settings::get(self::DATA2));
        $form->addField(self::DATA3, Gpf_Settings::get(self::DATA3));
        $form->addField(self::DATA4, Gpf_Settings::get(self::DATA4));
        $form->addField(self::DATA5, Gpf_Settings::get(self::DATA5));
        $form->addField(self::CAMPAIGN_ID, Gpf_Settings::get(self::CAMPAIGN_ID));
        $form->addField(self::TEST_MODE, Gpf_Settings::get(self::TEST_MODE));

        return $form;
    }

    private function getCampaigns() {
        $campaigns = array('0' => '');
        $selectBuilder = new Gpf_SqlBuilder_SelectBuilder();
        $selectBuilder->select->add(Pap_Db_Table_Campaigns::ID);
        $selectBuilder->select->add(Pap_Db_Table_Campaigns::ACCOUNTID);
        $selectBuilder->select->add(Pap_Db_Table_Campaigns::STATUS);
        $selectBuilder->select->add(Pap_Db_Table_Campaigns::NAME);
        $selectBuilder->from->add(Pap_Db_Table_Campaigns::getName());
        if (!Gpf_Session::getAuthUser()->hasPrivilege(Pap_Privileges::CAMPAIGN, Gpf_Privileges::P_READ)) {
            $selectBuilder->where->add(Pap_Db_Table_Campaigns::ACCOUNTID, '=', Gpf_Session::getAuthUser()->getAccountId());
        }
        $selectBuilder->orderBy->add(Pap_Db_Table_Campaigns::NAME);
        $rows = $selectBuilder->getAllRows();
        foreach ($rows as $row) {
            switch($row->get(Pap_Db_Table_Campaigns::STATUS)) {
                case 'S':
                    $status = '(' . $this->_('Stopped') . ') ';
                    break;
                case 'W':
                    $status = '(' . $this->_('Paused') . ') ';
                    break;
                default:
                    $status = '';
                    break;
            }
            $campaigns[$row->get(Pap_Db_Table_Campaigns::ID)] = $status . $row->get(Pap_Db_Table_Campaigns::NAME) . ' (' . $row->get(Pap_Db_Table_Campaigns::ACCOUNTID) . ')';
        }
        return $campaigns;
    }
}
