<?php
/**
 *   @copyright Copyright (c) 2018 Quality Unit s.r.o.
 *   @author Martin Pullmann
 *   @package PostAffiliatePro
 *   @since Version 1.0.0
 *
 *   Licensed under the Quality Unit, s.r.o. Standard End User License Agreement,
 *   Version 1.0 (the "License"); you may not use this file except in compliance
 *   with the License. You may obtain a copy of the License at
 *   http://www.postaffiliatepro.com/licenses/license
 *
 */

/**
 * @package PostAffiliatePro plugins
 */
class BigCommerceAPIv3_Main extends Gpf_Plugins_Handler {

    /**
     * @return BigCommerceAPIv3_Main
     */
    public static function getHandlerInstance() {
        return new BigCommerceAPIv3_Main();
    }

    public function initSettings($context) {
        $context->addDbSetting(BigCommerceAPIv3_Config::CONFIG_IDENTIFIER, '');
        $context->addDbSetting(BigCommerceAPIv3_Config::API_USERNAME, '');
        $context->addDbSetting(BigCommerceAPIv3_Config::API_PATH, '');
        $context->addDbSetting(BigCommerceAPIv3_Config::API_TOKEN, '');
        $context->addDbSetting(BigCommerceAPIv3_Config::PER_PRODUCT, '0');
        $context->addDbSetting(BigCommerceAPIv3_Config::COUPON_TRACKING, Gpf::NO);
        $context->addDbSetting(BigCommerceAPIv3_Config::DATA1, '0');
        $context->addDbSetting(BigCommerceAPIv3_Config::DATA2, '0');
        $context->addDbSetting(BigCommerceAPIv3_Config::DATA3, '0');
        $context->addDbSetting(BigCommerceAPIv3_Config::DATA4, '0');
        $context->addDbSetting(BigCommerceAPIv3_Config::DATA5, '0');
        $context->addDbSetting(BigCommerceAPIv3_Config::WEBHOOK_ID, '0');
    }


    // ------------------------------------------------------------------
    // -------------------------- BIGCOMMERCE API -----------------------
    // ------------------------------------------------------------------
    public static function api($method, $class, $connection, $params = array()) {
        $token = $connection['token'];
        $clientId = $connection['clientId'];
        $url = rtrim($connection['url'], '/') . '/' . ltrim($class, '/');

        $query = in_array($method, array(
                'GET',
                'DELETE'
        )) ? $params : array();
        $payload = in_array($method, array(
                'POST',
                'PUT'
        )) ? stripslashes(json_encode($params)) : array();
        $request_headers = array(
                'Accept: application/json',
                'Content-Type: application/json',
                'X-Auth-Client: '.$clientId,
                'X-Auth-Token: '.$token
        );

        $response = self::curlHttpApiRequest($method, $url, $query, $payload, $request_headers);
        $responseArray = json_decode($response, true);
        if ($responseArray === null) {
            return $response;
        }
        return $responseArray;
    }

    private static function curlHttpApiRequest($method, $url, $query = '', $payload = '', $request_headers = array()) {
        $url = self::curlAppendQuery($url, $query, $method);
        $ch = curl_init($url);
        self::curlSetopts($ch, $method, $payload, $request_headers);
        $response = self::curlExecFollow($ch, 3);
        $errno = curl_errno($ch);
        $error = curl_error($ch);
        curl_close($ch);

        if ($errno) {
            throw new Exception("BigCommerce API v3 plugin: Exception $errno: $error");
        }

        return $response;
    }

    private static function curlAppendQuery($url, $query, $method = 'GET') {
        if ($method != 'GET' || empty($query)) {
            return $url;
        }
        if (is_array($query)) {
            return "$url?" . http_build_query($query);
        } else {
            return "$url?$query";
        }
    }

    private static function curlSetopts($ch, $method, $payload, $request_headers) {
        curl_setopt($ch, CURLOPT_HEADER, false);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 2);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 30);
        curl_setopt($ch, CURLOPT_TIMEOUT, 30);

        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, $method);
        if (!empty($request_headers))
            curl_setopt($ch, CURLOPT_HTTPHEADER, $request_headers);

            if ($method != 'GET' && !empty($payload)) {
                if (is_array($payload))
                    $payload = http_build_query($payload);
                    curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
            }
    }

    private static function curlExecFollow($ch, $maxredirect = null) {
        $mr = $maxredirect === null ? 5 : intval($maxredirect);

        if (ini_get('open_basedir') == '' && in_array(strtolower(ini_get('safe_mode')), array('off','','0'))) {
            curl_setopt($ch, CURLOPT_FOLLOWLOCATION, $mr > 0);
            curl_setopt($ch, CURLOPT_MAXREDIRS, $mr);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, true);
        } else {
            curl_setopt($ch, CURLOPT_FOLLOWLOCATION, false);

            if ($mr > 0) {
                $original_url = curl_getinfo($ch, CURLINFO_EFFECTIVE_URL);
                $newurl = $original_url;

                $rch = curl_copy_handle($ch);

                curl_setopt($rch, CURLOPT_HEADER, true);
                curl_setopt($rch, CURLOPT_NOBODY, true);
                curl_setopt($rch, CURLOPT_FORBID_REUSE, false);
                do {
                    curl_setopt($rch, CURLOPT_URL, $newurl);
                    $header = curl_exec($rch);
                    if (curl_errno($rch)) {
                        $code = 0;
                    } else {
                        $code = curl_getinfo($rch, CURLINFO_HTTP_CODE);
                        if ($code == 301 || $code == 302) {
                            preg_match('/Location:(.*?)\n/i', $header, $matches);
                            $newurl = trim(array_pop($matches));

                            // if no scheme is present then the new url is a
                            // relative path and thus needs some extra care
                            if (!preg_match("/^https?:/i", $newurl)) {
                                $newurl = $original_url . $newurl;
                            }
                        } else {
                            $code = 0;
                        }
                    }
                } while ($code && --$mr);

                curl_close($rch);

                if (!$mr) {
                    if ($maxredirect === null) {
                        trigger_error('Too many redirects.', E_USER_WARNING);
                        Gpf_Log::error('Too many redirects.');
                    } else {
                        $maxredirect = 0;
                    }

                    return false;
                }
                curl_setopt($ch, CURLOPT_URL, $newurl);
            }
        }
        return curl_exec($ch);
    }
}
