<?php
/**
 *   @copyright Copyright (c) 2017 Quality Unit s.r.o.
 *   @author Martin Pullmann
 *   @package PostAffiliatePro
 *   @since Version 1.0.0
 *
 *   Licensed under the Quality Unit, s.r.o. Standard End User License Agreement,
 *   Version 1.0 (the 'License'); you may not use this file except in compliance
 *   with the License. You may obtain a copy of the License at
 *   http://www.postaffiliatepro.com/licenses/license
 *
 */

/**
 * @package PostAffiliatePro
 */
class Avangate_Config extends Gpf_Plugins_Config {
    const CUSTOM_FIELD = 'AvangateCustomField';
    const API_SECRET_KEY = 'AvangateSecretKey';
    const REGISTER_AFFILIATE = 'AvangateRegisterAffiliate';
    const APPROVE_AFFILIATE = 'AvangateApproveAffiliate';
    const DECLINE_AFFILIATE = 'AvangateDeclineAffiliate';
    const PER_PRODUCT_TRCKING = 'AvangatePerProductTracking';
    const REFUND = 'AvangateRefundManagement';

    protected function initFields() {
        $this->addTextBox($this->_('Custom field'), self::CUSTOM_FIELD, $this->_('Set the custom field name here, based on what you\'ve set in your Avangate (see integration of Post Affiliate Pro with Avangate)'));
        $this->addTextBox($this->_('API Secret Key'), self::API_SECRET_KEY, $this->_('API Secret Key from your Avangate IPN section (see integration of Post Affiliate Pro with Avangate)'));
        $this->addCheckBox($this->_('Register new affiliate'), self::REGISTER_AFFILIATE, $this->_('With every order a new affiliate will be created based on customer details.'));
        $this->addCheckBox($this->_('Approve affiliate'), self::APPROVE_AFFILIATE, $this->_('If the customer has a pending affiliate account, it will be approved after a successful payment.'));
        $this->addCheckBox($this->_('Decline affiliate'), self::DECLINE_AFFILIATE, $this->_('If the customer has an affiliate account, they will be declined if the original payment was cancelled.'));
        $this->addCheckBox($this->_('Per product tracking'), self::PER_PRODUCT_TRCKING, $this->_('This will create a separate commission for each item from the order.'));
        $this->addCheckBox($this->_('Process refunds'), self::REFUND, $this->_('A refund notification will refund a commission as well.'));
    }

    /**
     * @service plugin_config write
     * @param Gpf_Rpc_Params $params
     * @return Gpf_Rpc_Form
     */
    public function save(Gpf_Rpc_Params $params) {
        $form = new Gpf_Rpc_Form($params);
        Gpf_Settings::set(self::CUSTOM_FIELD, $form->getFieldValue(self::CUSTOM_FIELD));
        Gpf_Settings::set(self::API_SECRET_KEY, $form->getFieldValue(self::API_SECRET_KEY));
        Gpf_Settings::set(self::REGISTER_AFFILIATE, $form->getFieldValue(self::REGISTER_AFFILIATE));
        Gpf_Settings::set(self::APPROVE_AFFILIATE, $form->getFieldValue(self::APPROVE_AFFILIATE));
        Gpf_Settings::set(self::DECLINE_AFFILIATE, $form->getFieldValue(self::DECLINE_AFFILIATE));
        Gpf_Settings::set(self::PER_PRODUCT_TRCKING, $form->getFieldValue(self::PER_PRODUCT_TRCKING));
        Gpf_Settings::set(self::REFUND, $form->getFieldValue(self::REFUND));

        if ($form->getFieldValue(self::API_SECRET_KEY) == '') {
             $form->setErrorMessage($this->_('The API Secret Key can not be empty!'));
        }
        else {
            $form->setInfoMessage($this->_('Avangate settings saved'));
        }
        return $form;
    }

    /**
     * @service plugin_config read
     * @param Gpf_Rpc_Params $params
     * @return Gpf_Rpc_Form
     */
    public function load(Gpf_Rpc_Params $params) {
        $form = new Gpf_Rpc_Form($params);
        $form->addField(self::CUSTOM_FIELD, Gpf_Settings::get(self::CUSTOM_FIELD));
        $form->addField(self::API_SECRET_KEY, Gpf_Settings::get(self::API_SECRET_KEY));
        $form->addField(self::REGISTER_AFFILIATE, Gpf_Settings::get(self::REGISTER_AFFILIATE));
        $form->addField(self::APPROVE_AFFILIATE, Gpf_Settings::get(self::APPROVE_AFFILIATE));
        $form->addField(self::DECLINE_AFFILIATE, Gpf_Settings::get(self::DECLINE_AFFILIATE));
        $form->addField(self::PER_PRODUCT_TRCKING, Gpf_Settings::get(self::PER_PRODUCT_TRCKING));
        $form->addField(self::REFUND, Gpf_Settings::get(self::REFUND));

        return $form;
    }
}
