/*!
 * Braintree End-to-End Encryption Library
 * https://www.braintreepayments.com
 * Copyright (c) 2009-2014 Braintree, a division of PayPal, Inc.
 *
 * JSBN
 * Copyright (c) 2005  Tom Wu
 *
 * Both Licensed under the MIT License.
 * http://opensource.org/licenses/MIT
 *
 * ASN.1 JavaScript decoder
 * Copyright (c) 2008-2009 Lapo Luchini <lapo@lapo.it>
 * Licensed under the ISC License.
 * http://opensource.org/licenses/ISC
 */
!function(){function t(e,n){e instanceof t?(this.enc=e.enc,this.pos=e.pos):(this.enc=e,this.pos=n)}function e(t,e,n,i,r){this.stream=t,this.header=e,this.length=n,this.tag=i,this.sub=r}function n(t){var e,n,i="";for(e=0;e+3<=t.length;e+=3)n=parseInt(t.substring(e,e+3),16),i+=ee.charAt(n>>6)+ee.charAt(63&n);for(e+1==t.length?(n=parseInt(t.substring(e,e+1),16),i+=ee.charAt(n<<2)):e+2==t.length&&(n=parseInt(t.substring(e,e+2),16),i+=ee.charAt(n>>2)+ee.charAt((3&n)<<4));(3&i.length)>0;)i+=ne;return i}function i(t){var e,n,i,r="",o=0;for(e=0;e<t.length&&t.charAt(e)!=ne;++e)i=ee.indexOf(t.charAt(e)),0>i||(0==o?(r+=l(i>>2),n=3&i,o=1):1==o?(r+=l(n<<2|i>>4),n=15&i,o=2):2==o?(r+=l(n),r+=l(i>>2),n=3&i,o=3):(r+=l(n<<2|i>>4),r+=l(15&i),o=0));return 1==o&&(r+=l(n<<2)),r}function r(t){var e,n=i(t),r=new Array;for(e=0;2*e<n.length;++e)r[e]=parseInt(n.substring(2*e,2*e+2),16);return r}function o(t,e,n){null!=t&&("number"==typeof t?this.fromNumber(t,e,n):null==e&&"string"!=typeof t?this.fromString(t,256):this.fromString(t,e))}function s(){return new o(null)}function a(t,e,n,i,r,o){for(;--o>=0;){var s=e*this[t++]+n[i]+r;r=Math.floor(s/67108864),n[i++]=67108863&s}return r}function c(t,e,n,i,r,o){for(var s=32767&e,a=e>>15;--o>=0;){var c=32767&this[t],u=this[t++]>>15,l=a*c+u*s;c=s*c+((32767&l)<<15)+n[i]+(1073741823&r),r=(c>>>30)+(l>>>15)+a*u+(r>>>30),n[i++]=1073741823&c}return r}function u(t,e,n,i,r,o){for(var s=16383&e,a=e>>14;--o>=0;){var c=16383&this[t],u=this[t++]>>14,l=a*c+u*s;c=s*c+((16383&l)<<14)+n[i]+r,r=(c>>28)+(l>>14)+a*u,n[i++]=268435455&c}return r}function l(t){return ce.charAt(t)}function h(t,e){var n=ue[t.charCodeAt(e)];return null==n?-1:n}function p(t){for(var e=this.t-1;e>=0;--e)t[e]=this[e];t.t=this.t,t.s=this.s}function f(t){this.t=1,this.s=0>t?-1:0,t>0?this[0]=t:-1>t?this[0]=t+this.DV:this.t=0}function d(t){var e=s();return e.fromInt(t),e}function m(t,e){var n;if(16==e)n=4;else if(8==e)n=3;else if(256==e)n=8;else if(2==e)n=1;else if(32==e)n=5;else{if(4!=e)return this.fromRadix(t,e),void 0;n=2}this.t=0,this.s=0;for(var i=t.length,r=!1,s=0;--i>=0;){var a=8==n?255&t[i]:h(t,i);0>a?"-"==t.charAt(i)&&(r=!0):(r=!1,0==s?this[this.t++]=a:s+n>this.DB?(this[this.t-1]|=(a&(1<<this.DB-s)-1)<<s,this[this.t++]=a>>this.DB-s):this[this.t-1]|=a<<s,s+=n,s>=this.DB&&(s-=this.DB))}8==n&&0!=(128&t[0])&&(this.s=-1,s>0&&(this[this.t-1]|=(1<<this.DB-s)-1<<s)),this.clamp(),r&&o.ZERO.subTo(this,this)}function y(){for(var t=this.s&this.DM;this.t>0&&this[this.t-1]==t;)--this.t}function b(t){if(this.s<0)return"-"+this.negate().toString(t);var e;if(16==t)e=4;else if(8==t)e=3;else if(2==t)e=1;else if(32==t)e=5;else{if(4!=t)return this.toRadix(t);e=2}var n,i=(1<<e)-1,r=!1,o="",s=this.t,a=this.DB-s*this.DB%e;if(s-->0)for(a<this.DB&&(n=this[s]>>a)>0&&(r=!0,o=l(n));s>=0;)e>a?(n=(this[s]&(1<<a)-1)<<e-a,n|=this[--s]>>(a+=this.DB-e)):(n=this[s]>>(a-=e)&i,0>=a&&(a+=this.DB,--s)),n>0&&(r=!0),r&&(o+=l(n));return r?o:"0"}function g(){var t=s();return o.ZERO.subTo(this,t),t}function v(){return this.s<0?this.negate():this}function _(t){var e=this.s-t.s;if(0!=e)return e;var n=this.t;if(e=n-t.t,0!=e)return this.s<0?-e:e;for(;--n>=0;)if(0!=(e=this[n]-t[n]))return e;return 0}function w(t){var e,n=1;return 0!=(e=t>>>16)&&(t=e,n+=16),0!=(e=t>>8)&&(t=e,n+=8),0!=(e=t>>4)&&(t=e,n+=4),0!=(e=t>>2)&&(t=e,n+=2),0!=(e=t>>1)&&(t=e,n+=1),n}function x(){return this.t<=0?0:this.DB*(this.t-1)+w(this[this.t-1]^this.s&this.DM)}function E(t,e){var n;for(n=this.t-1;n>=0;--n)e[n+t]=this[n];for(n=t-1;n>=0;--n)e[n]=0;e.t=this.t+t,e.s=this.s}function S(t,e){for(var n=t;n<this.t;++n)e[n-t]=this[n];e.t=Math.max(this.t-t,0),e.s=this.s}function C(t,e){var n,i=t%this.DB,r=this.DB-i,o=(1<<r)-1,s=Math.floor(t/this.DB),a=this.s<<i&this.DM;for(n=this.t-1;n>=0;--n)e[n+s+1]=this[n]>>r|a,a=(this[n]&o)<<i;for(n=s-1;n>=0;--n)e[n]=0;e[s]=a,e.t=this.t+s+1,e.s=this.s,e.clamp()}function A(t,e){e.s=this.s;var n=Math.floor(t/this.DB);if(n>=this.t)return e.t=0,void 0;var i=t%this.DB,r=this.DB-i,o=(1<<i)-1;e[0]=this[n]>>i;for(var s=n+1;s<this.t;++s)e[s-n-1]|=(this[s]&o)<<r,e[s-n]=this[s]>>i;i>0&&(e[this.t-n-1]|=(this.s&o)<<r),e.t=this.t-n,e.clamp()}function k(t,e){for(var n=0,i=0,r=Math.min(t.t,this.t);r>n;)i+=this[n]-t[n],e[n++]=i&this.DM,i>>=this.DB;if(t.t<this.t){for(i-=t.s;n<this.t;)i+=this[n],e[n++]=i&this.DM,i>>=this.DB;i+=this.s}else{for(i+=this.s;n<t.t;)i-=t[n],e[n++]=i&this.DM,i>>=this.DB;i-=t.s}e.s=0>i?-1:0,-1>i?e[n++]=this.DV+i:i>0&&(e[n++]=i),e.t=n,e.clamp()}function T(t,e){var n=this.abs(),i=t.abs(),r=n.t;for(e.t=r+i.t;--r>=0;)e[r]=0;for(r=0;r<i.t;++r)e[r+n.t]=n.am(0,i[r],e,r,0,n.t);e.s=0,e.clamp(),this.s!=t.s&&o.ZERO.subTo(e,e)}function P(t){for(var e=this.abs(),n=t.t=2*e.t;--n>=0;)t[n]=0;for(n=0;n<e.t-1;++n){var i=e.am(n,e[n],t,2*n,0,1);(t[n+e.t]+=e.am(n+1,2*e[n],t,2*n+1,i,e.t-n-1))>=e.DV&&(t[n+e.t]-=e.DV,t[n+e.t+1]=1)}t.t>0&&(t[t.t-1]+=e.am(n,e[n],t,2*n,0,1)),t.s=0,t.clamp()}function M(t,e,n){var i=t.abs();if(!(i.t<=0)){var r=this.abs();if(r.t<i.t)return null!=e&&e.fromInt(0),null!=n&&this.copyTo(n),void 0;null==n&&(n=s());var a=s(),c=this.s,u=t.s,l=this.DB-w(i[i.t-1]);l>0?(i.lShiftTo(l,a),r.lShiftTo(l,n)):(i.copyTo(a),r.copyTo(n));var h=a.t,p=a[h-1];if(0!=p){var f=p*(1<<this.F1)+(h>1?a[h-2]>>this.F2:0),d=this.FV/f,m=(1<<this.F1)/f,y=1<<this.F2,b=n.t,g=b-h,v=null==e?s():e;for(a.dlShiftTo(g,v),n.compareTo(v)>=0&&(n[n.t++]=1,n.subTo(v,n)),o.ONE.dlShiftTo(h,v),v.subTo(a,a);a.t<h;)a[a.t++]=0;for(;--g>=0;){var _=n[--b]==p?this.DM:Math.floor(n[b]*d+(n[b-1]+y)*m);if((n[b]+=a.am(0,_,n,g,0,h))<_)for(a.dlShiftTo(g,v),n.subTo(v,n);n[b]<--_;)n.subTo(v,n)}null!=e&&(n.drShiftTo(h,e),c!=u&&o.ZERO.subTo(e,e)),n.t=h,n.clamp(),l>0&&n.rShiftTo(l,n),0>c&&o.ZERO.subTo(n,n)}}}function I(t){var e=s();return this.abs().divRemTo(t,null,e),this.s<0&&e.compareTo(o.ZERO)>0&&t.subTo(e,e),e}function N(t){this.m=t}function U(t){return t.s<0||t.compareTo(this.m)>=0?t.mod(this.m):t}function O(t){return t}function R(t){t.divRemTo(this.m,null,t)}function D(t,e,n){t.multiplyTo(e,n),this.reduce(n)}function F(t,e){t.squareTo(e),this.reduce(e)}function L(){if(this.t<1)return 0;var t=this[0];if(0==(1&t))return 0;var e=3&t;return e=e*(2-(15&t)*e)&15,e=e*(2-(255&t)*e)&255,e=e*(2-((65535&t)*e&65535))&65535,e=e*(2-t*e%this.DV)%this.DV,e>0?this.DV-e:-e}function j(t){this.m=t,this.mp=t.invDigit(),this.mpl=32767&this.mp,this.mph=this.mp>>15,this.um=(1<<t.DB-15)-1,this.mt2=2*t.t}function B(t){var e=s();return t.abs().dlShiftTo(this.m.t,e),e.divRemTo(this.m,null,e),t.s<0&&e.compareTo(o.ZERO)>0&&this.m.subTo(e,e),e}function z(t){var e=s();return t.copyTo(e),this.reduce(e),e}function V(t){for(;t.t<=this.mt2;)t[t.t++]=0;for(var e=0;e<this.m.t;++e){var n=32767&t[e],i=n*this.mpl+((n*this.mph+(t[e]>>15)*this.mpl&this.um)<<15)&t.DM;for(n=e+this.m.t,t[n]+=this.m.am(0,i,t,e,0,this.m.t);t[n]>=t.DV;)t[n]-=t.DV,t[++n]++}t.clamp(),t.drShiftTo(this.m.t,t),t.compareTo(this.m)>=0&&t.subTo(this.m,t)}function q(t,e){t.squareTo(e),this.reduce(e)}function W(t,e,n){t.multiplyTo(e,n),this.reduce(n)}function H(){return 0==(this.t>0?1&this[0]:this.s)}function Q(t,e){if(t>4294967295||1>t)return o.ONE;var n=s(),i=s(),r=e.convert(this),a=w(t)-1;for(r.copyTo(n);--a>=0;)if(e.sqrTo(n,i),(t&1<<a)>0)e.mulTo(i,r,n);else{var c=n;n=i,i=c}return e.revert(n)}function J(t,e){var n;return n=256>t||e.isEven()?new N(e):new j(e),this.exp(t,n)}function Y(t,e){return new o(t,e)}function Z(t,e){if(e<t.length+11)throw new Error("Message too long for RSA");for(var n=new Array,i=t.length-1;i>=0&&e>0;){var r=t.charCodeAt(i--);128>r?n[--e]=r:r>127&&2048>r?(n[--e]=63&r|128,n[--e]=r>>6|192):(n[--e]=63&r|128,n[--e]=r>>6&63|128,n[--e]=r>>12|224)}n[--e]=0;for(var s=0,a=0,c=0;e>2;)0==c&&(a=le.random.randomWords(1,0)[0]),s=a>>c&255,c=(c+8)%32,0!=s&&(n[--e]=s);return n[--e]=2,n[--e]=0,new o(n)}function G(){this.n=null,this.e=0,this.d=null,this.p=null,this.q=null,this.dmp1=null,this.dmq1=null,this.coeff=null}function K(t,e){if(!(null!=t&&null!=e&&t.length>0&&e.length>0))throw new Error("Invalid RSA public key");this.n=Y(t,16),this.e=parseInt(e,16)}function X(t){return t.modPowInt(this.e,this.n)}function $(t){var e=Z(t,this.n.bitLength()+7>>3);if(null==e)return null;var n=this.doPublic(e);if(null==n)return null;var i=n.toString(16);return 0==(1&i.length)?i:"0"+i}t.prototype.get=function(t){if(void 0==t&&(t=this.pos++),t>=this.enc.length)throw"Requesting byte offset "+t+" on a stream of length "+this.enc.length;return this.enc[t]},t.prototype.hexDigits="0123456789ABCDEF",t.prototype.hexByte=function(t){return this.hexDigits.charAt(t>>4&15)+this.hexDigits.charAt(15&t)},t.prototype.hexDump=function(t,e){for(var n="",i=t;e>i;++i)switch(n+=this.hexByte(this.get(i)),15&i){case 7:n+="  ";break;case 15:n+="\n";break;default:n+=" "}return n},t.prototype.parseStringISO=function(t,e){for(var n="",i=t;e>i;++i)n+=String.fromCharCode(this.get(i));return n},t.prototype.parseStringUTF=function(t,e){for(var n="",i=0,r=t;e>r;){var i=this.get(r++);n+=128>i?String.fromCharCode(i):i>191&&224>i?String.fromCharCode((31&i)<<6|63&this.get(r++)):String.fromCharCode((15&i)<<12|(63&this.get(r++))<<6|63&this.get(r++))}return n},t.prototype.reTime=/^((?:1[89]|2\d)?\d\d)(0[1-9]|1[0-2])(0[1-9]|[12]\d|3[01])([01]\d|2[0-3])(?:([0-5]\d)(?:([0-5]\d)(?:[.,](\d{1,3}))?)?)?(Z|[-+](?:[0]\d|1[0-2])([0-5]\d)?)?$/,t.prototype.parseTime=function(t,e){var n=this.parseStringISO(t,e),i=this.reTime.exec(n);return i?(n=i[1]+"-"+i[2]+"-"+i[3]+" "+i[4],i[5]&&(n+=":"+i[5],i[6]&&(n+=":"+i[6],i[7]&&(n+="."+i[7]))),i[8]&&(n+=" UTC","Z"!=i[8]&&(n+=i[8],i[9]&&(n+=":"+i[9]))),n):"Unrecognized time: "+n},t.prototype.parseInteger=function(t,e){var n=e-t;if(n>4){n<<=3;var i=this.get(t);if(0==i)n-=8;else for(;128>i;)i<<=1,--n;return"("+n+" bit)"}for(var r=0,o=t;e>o;++o)r=r<<8|this.get(o);return r},t.prototype.parseBitString=function(t,e){var n=this.get(t),i=(e-t-1<<3)-n,r="("+i+" bit)";if(20>=i){var o=n;r+=" ";for(var s=e-1;s>t;--s){for(var a=this.get(s),c=o;8>c;++c)r+=a>>c&1?"1":"0";o=0}}return r},t.prototype.parseOctetString=function(t,e){var n=e-t,i="("+n+" byte) ";n>20&&(e=t+20);for(var r=t;e>r;++r)i+=this.hexByte(this.get(r));return n>20&&(i+=String.fromCharCode(8230)),i},t.prototype.parseOID=function(t,e){for(var n,i=0,r=0,o=t;e>o;++o){var s=this.get(o);i=i<<7|127&s,r+=7,128&s||(void 0==n?n=parseInt(i/40)+"."+i%40:n+="."+(r>=31?"bigint":i),i=r=0),n+=String.fromCharCode()}return n},e.prototype.typeName=function(){if(void 0==this.tag)return"unknown";var t=this.tag>>6,e=(this.tag>>5&1,31&this.tag);switch(t){case 0:switch(e){case 0:return"EOC";case 1:return"BOOLEAN";case 2:return"INTEGER";case 3:return"BIT_STRING";case 4:return"OCTET_STRING";case 5:return"NULL";case 6:return"OBJECT_IDENTIFIER";case 7:return"ObjectDescriptor";case 8:return"EXTERNAL";case 9:return"REAL";case 10:return"ENUMERATED";case 11:return"EMBEDDED_PDV";case 12:return"UTF8String";case 16:return"SEQUENCE";case 17:return"SET";case 18:return"NumericString";case 19:return"PrintableString";case 20:return"TeletexString";case 21:return"VideotexString";case 22:return"IA5String";case 23:return"UTCTime";case 24:return"GeneralizedTime";case 25:return"GraphicString";case 26:return"VisibleString";case 27:return"GeneralString";case 28:return"UniversalString";case 30:return"BMPString";default:return"Universal_"+e.toString(16)}case 1:return"Application_"+e.toString(16);case 2:return"["+e+"]";case 3:return"Private_"+e.toString(16)}},e.prototype.content=function(){if(void 0==this.tag)return null;var t=this.tag>>6;if(0!=t)return null==this.sub?null:"("+this.sub.length+")";var e=31&this.tag,n=this.posContent(),i=Math.abs(this.length);switch(e){case 1:return 0==this.stream.get(n)?"false":"true";case 2:return this.stream.parseInteger(n,n+i);case 3:return this.sub?"("+this.sub.length+" elem)":this.stream.parseBitString(n,n+i);case 4:return this.sub?"("+this.sub.length+" elem)":this.stream.parseOctetString(n,n+i);case 6:return this.stream.parseOID(n,n+i);case 16:case 17:return"("+this.sub.length+" elem)";case 12:return this.stream.parseStringUTF(n,n+i);case 18:case 19:case 20:case 21:case 22:case 26:return this.stream.parseStringISO(n,n+i);case 23:case 24:return this.stream.parseTime(n,n+i)}return null},e.prototype.toString=function(){return this.typeName()+"@"+this.stream.pos+"[header:"+this.header+",length:"+this.length+",sub:"+(null==this.sub?"null":this.sub.length)+"]"},e.prototype.print=function(t){if(void 0==t&&(t=""),document.writeln(t+this),null!=this.sub){t+="  ";for(var e=0,n=this.sub.length;n>e;++e)this.sub[e].print(t)}},e.prototype.toPrettyString=function(t){void 0==t&&(t="");var e=t+this.typeName()+" @"+this.stream.pos;if(this.length>=0&&(e+="+"),e+=this.length,32&this.tag?e+=" (constructed)":3!=this.tag&&4!=this.tag||null==this.sub||(e+=" (encapsulates)"),e+="\n",null!=this.sub){t+="  ";for(var n=0,i=this.sub.length;i>n;++n)e+=this.sub[n].toPrettyString(t)}return e},e.prototype.posStart=function(){return this.stream.pos},e.prototype.posContent=function(){return this.stream.pos+this.header},e.prototype.posEnd=function(){return this.stream.pos+this.header+Math.abs(this.length)},e.decodeLength=function(t){var e=t.get(),n=127&e;if(n==e)return n;if(n>3)throw"Length over 24 bits not supported at position "+(t.pos-1);if(0==n)return-1;e=0;for(var i=0;n>i;++i)e=e<<8|t.get();return e},e.hasContent=function(n,i,r){if(32&n)return!0;if(3>n||n>4)return!1;var o=new t(r);3==n&&o.get();var s=o.get();if(s>>6&1)return!1;try{var a=e.decodeLength(o);return o.pos-r.pos+a==i}catch(c){return!1}},e.decode=function(n){n instanceof t||(n=new t(n,0));var i=new t(n),r=n.get(),o=e.decodeLength(n),s=n.pos-i.pos,a=null;if(e.hasContent(r,o,n)){var c=n.pos;if(3==r&&n.get(),a=[],o>=0){for(var u=c+o;n.pos<u;)a[a.length]=e.decode(n);if(n.pos!=u)throw"Content size is not correct for container starting at offset "+c}else try{for(;;){var l=e.decode(n);if(0==l.tag)break;a[a.length]=l}o=c-n.pos}catch(h){throw"Exception while decoding undefined length content: "+h}}else n.pos+=o;return new e(i,s,o,r,a)};var te,ee="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/",ne="=",ie=0xdeadbeefcafe,re=15715070==(16777215&ie);re&&"Microsoft Internet Explorer"==navigator.appName?(o.prototype.am=c,te=30):re&&"Netscape"!=navigator.appName?(o.prototype.am=a,te=26):(o.prototype.am=u,te=28),o.prototype.DB=te,o.prototype.DM=(1<<te)-1,o.prototype.DV=1<<te;var oe=52;o.prototype.FV=Math.pow(2,oe),o.prototype.F1=oe-te,o.prototype.F2=2*te-oe;var se,ae,ce="0123456789abcdefghijklmnopqrstuvwxyz",ue=new Array;for(se="0".charCodeAt(0),ae=0;9>=ae;++ae)ue[se++]=ae;for(se="a".charCodeAt(0),ae=10;36>ae;++ae)ue[se++]=ae;for(se="A".charCodeAt(0),ae=10;36>ae;++ae)ue[se++]=ae;N.prototype.convert=U,N.prototype.revert=O,N.prototype.reduce=R,N.prototype.mulTo=D,N.prototype.sqrTo=F,j.prototype.convert=B,j.prototype.revert=z,j.prototype.reduce=V,j.prototype.mulTo=W,j.prototype.sqrTo=q,o.prototype.copyTo=p,o.prototype.fromInt=f,o.prototype.fromString=m,o.prototype.clamp=y,o.prototype.dlShiftTo=E,o.prototype.drShiftTo=S,o.prototype.lShiftTo=C,o.prototype.rShiftTo=A,o.prototype.subTo=k,o.prototype.multiplyTo=T,o.prototype.squareTo=P,o.prototype.divRemTo=M,o.prototype.invDigit=L,o.prototype.isEven=H,o.prototype.exp=Q,o.prototype.toString=b,o.prototype.negate=g,o.prototype.abs=v,o.prototype.compareTo=_,o.prototype.bitLength=x,o.prototype.mod=I,o.prototype.modPowInt=J,o.ZERO=d(0),o.ONE=d(1),G.prototype.doPublic=X,G.prototype.setPublic=K,G.prototype.encrypt=$;var le={cipher:{},hash:{},keyexchange:{},mode:{},misc:{},codec:{},exception:{corrupt:function(t){this.toString=function(){return"CORRUPT: "+this.message},this.message=t},invalid:function(t){this.toString=function(){return"INVALID: "+this.message},this.message=t},bug:function(t){this.toString=function(){return"BUG: "+this.message},this.message=t},notReady:function(t){this.toString=function(){return"NOT READY: "+this.message},this.message=t}}};"undefined"!=typeof module&&module.exports&&(module.exports=le),le.cipher.aes=function(t){this._tables[0][0][0]||this._precompute();var e,n,i,r,o,s=this._tables[0][4],a=this._tables[1],c=t.length,u=1;if(4!==c&&6!==c&&8!==c)throw new le.exception.invalid("invalid aes key size");for(this._key=[r=t.slice(0),o=[]],e=c;4*c+28>e;e++)i=r[e-1],(e%c===0||8===c&&e%c===4)&&(i=s[i>>>24]<<24^s[i>>16&255]<<16^s[i>>8&255]<<8^s[255&i],e%c===0&&(i=i<<8^i>>>24^u<<24,u=u<<1^283*(u>>7))),r[e]=r[e-c]^i;for(n=0;e;n++,e--)i=r[3&n?e:e-4],o[n]=4>=e||4>n?i:a[0][s[i>>>24]]^a[1][s[i>>16&255]]^a[2][s[i>>8&255]]^a[3][s[255&i]]},le.cipher.aes.prototype={encrypt:function(t){return this._crypt(t,0)},decrypt:function(t){return this._crypt(t,1)},_tables:[[[],[],[],[],[]],[[],[],[],[],[]]],_precompute:function(){var t,e,n,i,r,o,s,a,c,u=this._tables[0],l=this._tables[1],h=u[4],p=l[4],f=[],d=[];for(t=0;256>t;t++)d[(f[t]=t<<1^283*(t>>7))^t]=t;for(e=n=0;!h[e];e^=i||1,n=d[n]||1)for(s=n^n<<1^n<<2^n<<3^n<<4,s=s>>8^255&s^99,h[e]=s,p[s]=e,o=f[r=f[i=f[e]]],c=16843009*o^65537*r^257*i^16843008*e,a=257*f[s]^16843008*s,t=0;4>t;t++)u[t][e]=a=a<<24^a>>>8,l[t][s]=c=c<<24^c>>>8;for(t=0;5>t;t++)u[t]=u[t].slice(0),l[t]=l[t].slice(0)},_crypt:function(t,e){if(4!==t.length)throw new le.exception.invalid("invalid aes block size");var n,i,r,o,s=this._key[e],a=t[0]^s[0],c=t[e?3:1]^s[1],u=t[2]^s[2],l=t[e?1:3]^s[3],h=s.length/4-2,p=4,f=[0,0,0,0],d=this._tables[e],m=d[0],y=d[1],b=d[2],g=d[3],v=d[4];for(o=0;h>o;o++)n=m[a>>>24]^y[c>>16&255]^b[u>>8&255]^g[255&l]^s[p],i=m[c>>>24]^y[u>>16&255]^b[l>>8&255]^g[255&a]^s[p+1],r=m[u>>>24]^y[l>>16&255]^b[a>>8&255]^g[255&c]^s[p+2],l=m[l>>>24]^y[a>>16&255]^b[c>>8&255]^g[255&u]^s[p+3],p+=4,a=n,c=i,u=r;for(o=0;4>o;o++)f[e?3&-o:o]=v[a>>>24]<<24^v[c>>16&255]<<16^v[u>>8&255]<<8^v[255&l]^s[p++],n=a,a=c,c=u,u=l,l=n;return f}},le.bitArray={bitSlice:function(t,e,n){return t=le.bitArray._shiftRight(t.slice(e/32),32-(31&e)).slice(1),void 0===n?t:le.bitArray.clamp(t,n-e)},extract:function(t,e,n){var i,r=Math.floor(-e-n&31);return i=-32&(e+n-1^e)?t[e/32|0]<<32-r^t[e/32+1|0]>>>r:t[e/32|0]>>>r,i&(1<<n)-1},concat:function(t,e){if(0===t.length||0===e.length)return t.concat(e);var n=t[t.length-1],i=le.bitArray.getPartial(n);return 32===i?t.concat(e):le.bitArray._shiftRight(e,i,0|n,t.slice(0,t.length-1))},bitLength:function(t){var e,n=t.length;return 0===n?0:(e=t[n-1],32*(n-1)+le.bitArray.getPartial(e))},clamp:function(t,e){if(32*t.length<e)return t;t=t.slice(0,Math.ceil(e/32));var n=t.length;return e=31&e,n>0&&e&&(t[n-1]=le.bitArray.partial(e,t[n-1]&2147483648>>e-1,1)),t},partial:function(t,e,n){return 32===t?e:(n?0|e:e<<32-t)+1099511627776*t},getPartial:function(t){return Math.round(t/1099511627776)||32},equal:function(t,e){if(le.bitArray.bitLength(t)!==le.bitArray.bitLength(e))return!1;var n,i=0;for(n=0;n<t.length;n++)i|=t[n]^e[n];return 0===i},_shiftRight:function(t,e,n,i){var r,o,s=0;for(void 0===i&&(i=[]);e>=32;e-=32)i.push(n),n=0;if(0===e)return i.concat(t);for(r=0;r<t.length;r++)i.push(n|t[r]>>>e),n=t[r]<<32-e;return s=t.length?t[t.length-1]:0,o=le.bitArray.getPartial(s),i.push(le.bitArray.partial(e+o&31,e+o>32?n:i.pop(),1)),i},_xor4:function(t,e){return[t[0]^e[0],t[1]^e[1],t[2]^e[2],t[3]^e[3]]}},le.codec.hex={fromBits:function(t){var e,n="";for(e=0;e<t.length;e++)n+=((0|t[e])+0xf00000000000).toString(16).substr(4);return n.substr(0,le.bitArray.bitLength(t)/4)},toBits:function(t){var e,n,i=[];for(t=t.replace(/\s|0x/g,""),n=t.length,t+="00000000",e=0;e<t.length;e+=8)i.push(0^parseInt(t.substr(e,8),16));return le.bitArray.clamp(i,4*n)}},le.codec.utf8String={fromBits:function(t){var e,n,i="",r=le.bitArray.bitLength(t);for(e=0;r/8>e;e++)0===(3&e)&&(n=t[e/4]),i+=String.fromCharCode(n>>>24),n<<=8;return decodeURIComponent(escape(i))},toBits:function(t){t=decodeURI(encodeURIComponent(t));var e,n=[],i=0;for(e=0;e<t.length;e++)i=i<<8|t.charCodeAt(e),3===(3&e)&&(n.push(i),i=0);return 3&e&&n.push(le.bitArray.partial(8*(3&e),i)),n}},le.codec.base64={_chars:"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/",fromBits:function(t,e,n){var i,r="",o=0,s=le.codec.base64._chars,a=0,c=le.bitArray.bitLength(t);for(n&&(s=s.substr(0,62)+"-_"),i=0;6*r.length<c;)r+=s.charAt((a^t[i]>>>o)>>>26),6>o?(a=t[i]<<6-o,o+=26,i++):(a<<=6,o-=6);for(;3&r.length&&!e;)r+="=";return r},toBits:function(t,e){t=t.replace(/\s|=/g,"");var n,i,r=[],o=0,s=le.codec.base64._chars,a=0;for(e&&(s=s.substr(0,62)+"-_"),n=0;n<t.length;n++){if(i=s.indexOf(t.charAt(n)),0>i)throw new le.exception.invalid("this isn't base64!");o>26?(o-=26,r.push(a^i>>>o),a=i<<32-o):(o+=6,a^=i<<32-o)}return 56&o&&r.push(le.bitArray.partial(56&o,a,1)),r}},le.codec.base64url={fromBits:function(t){return le.codec.base64.fromBits(t,1,1)},toBits:function(t){return le.codec.base64.toBits(t,1)}},void 0===le.beware&&(le.beware={}),le.beware["CBC mode is dangerous because it doesn't protect message integrity."]=function(){le.mode.cbc={name:"cbc",encrypt:function(t,e,n,i){if(i&&i.length)throw new le.exception.invalid("cbc can't authenticate data");if(128!==le.bitArray.bitLength(n))throw new le.exception.invalid("cbc iv must be 128 bits");var r,o=le.bitArray,s=o._xor4,a=o.bitLength(e),c=0,u=[];if(7&a)throw new le.exception.invalid("pkcs#5 padding only works for multiples of a byte");for(r=0;a>=c+128;r+=4,c+=128)n=t.encrypt(s(n,e.slice(r,r+4))),u.splice(r,0,n[0],n[1],n[2],n[3]);return a=16843009*(16-(a>>3&15)),n=t.encrypt(s(n,o.concat(e,[a,a,a,a]).slice(r,r+4))),u.splice(r,0,n[0],n[1],n[2],n[3]),u},decrypt:function(t,e,n,i){if(i&&i.length)throw new le.exception.invalid("cbc can't authenticate data");if(128!==le.bitArray.bitLength(n))throw new le.exception.invalid("cbc iv must be 128 bits");if(127&le.bitArray.bitLength(e)||!e.length)throw new le.exception.corrupt("cbc ciphertext must be a positive multiple of the block size");var r,o,s,a=le.bitArray,c=a._xor4,u=[];for(i=i||[],r=0;r<e.length;r+=4)o=e.slice(r,r+4),s=c(n,t.decrypt(o)),u.splice(r,0,s[0],s[1],s[2],s[3]),n=o;if(o=255&u[r-1],0==o||o>16)throw new le.exception.corrupt("pkcs#5 padding corrupt");if(s=16843009*o,!a.equal(a.bitSlice([s,s,s,s],0,8*o),a.bitSlice(u,32*u.length-8*o,32*u.length)))throw new le.exception.corrupt("pkcs#5 padding corrupt");return a.bitSlice(u,0,32*u.length-8*o)}}},le.misc.hmac=function(t,e){this._hash=e=e||le.hash.sha256;var n,i=[[],[]],r=e.prototype.blockSize/32;for(this._baseHash=[new e,new e],t.length>r&&(t=e.hash(t)),n=0;r>n;n++)i[0][n]=909522486^t[n],i[1][n]=1549556828^t[n];this._baseHash[0].update(i[0]),this._baseHash[1].update(i[1])},le.misc.hmac.prototype.encrypt=le.misc.hmac.prototype.mac=function(t,e){var n=new this._hash(this._baseHash[0]).update(t,e).finalize();return new this._hash(this._baseHash[1]).update(n).finalize()},le.hash.sha256=function(t){this._key[0]||this._precompute(),t?(this._h=t._h.slice(0),this._buffer=t._buffer.slice(0),this._length=t._length):this.reset()},le.hash.sha256.hash=function(t){return(new le.hash.sha256).update(t).finalize()},le.hash.sha256.prototype={blockSize:512,reset:function(){return this._h=this._init.slice(0),this._buffer=[],this._length=0,this},update:function(t){"string"==typeof t&&(t=le.codec.utf8String.toBits(t));var e,n=this._buffer=le.bitArray.concat(this._buffer,t),i=this._length,r=this._length=i+le.bitArray.bitLength(t);for(e=512+i&-512;r>=e;e+=512)this._block(n.splice(0,16));return this},finalize:function(){var t,e=this._buffer,n=this._h;for(e=le.bitArray.concat(e,[le.bitArray.partial(1,1)]),t=e.length+2;15&t;t++)e.push(0);for(e.push(Math.floor(this._length/4294967296)),e.push(0|this._length);e.length;)this._block(e.splice(0,16));return this.reset(),n},_init:[],_key:[],_precompute:function(){function t(t){return 4294967296*(t-Math.floor(t))|0}var e,n=0,i=2;t:for(;64>n;i++){for(e=2;i>=e*e;e++)if(i%e===0)continue t;8>n&&(this._init[n]=t(Math.pow(i,.5))),this._key[n]=t(Math.pow(i,1/3)),n++}},_block:function(t){var e,n,i,r,o=t.slice(0),s=this._h,a=this._key,c=s[0],u=s[1],l=s[2],h=s[3],p=s[4],f=s[5],d=s[6],m=s[7];for(e=0;64>e;e++)16>e?n=o[e]:(i=o[e+1&15],r=o[e+14&15],n=o[15&e]=(i>>>7^i>>>18^i>>>3^i<<25^i<<14)+(r>>>17^r>>>19^r>>>10^r<<15^r<<13)+o[15&e]+o[e+9&15]|0),n=n+m+(p>>>6^p>>>11^p>>>25^p<<26^p<<21^p<<7)+(d^p&(f^d))+a[e],m=d,d=f,f=p,p=h+n|0,h=l,l=u,u=c,c=n+(u&l^h&(u^l))+(u>>>2^u>>>13^u>>>22^u<<30^u<<19^u<<10)|0;s[0]=s[0]+c|0,s[1]=s[1]+u|0,s[2]=s[2]+l|0,s[3]=s[3]+h|0,s[4]=s[4]+p|0,s[5]=s[5]+f|0,s[6]=s[6]+d|0,s[7]=s[7]+m|0}},le.random={randomWords:function(t,e){var n,i,r=[],o=this.isReady(e);if(o===this._NOT_READY)throw new le.exception.notReady("generator isn't seeded");for(o&this._REQUIRES_RESEED&&this._reseedFromPools(!(o&this._READY)),n=0;t>n;n+=4)(n+1)%this._MAX_WORDS_PER_BURST===0&&this._gate(),i=this._gen4words(),r.push(i[0],i[1],i[2],i[3]);return this._gate(),r.slice(0,t)},setDefaultParanoia:function(t){this._defaultParanoia=t},addEntropy:function(t,e,n){n=n||"user";var i,r,o,s=(new Date).valueOf(),a=this._robins[n],c=this.isReady(),u=0;switch(i=this._collectorIds[n],void 0===i&&(i=this._collectorIds[n]=this._collectorIdNext++),void 0===a&&(a=this._robins[n]=0),this._robins[n]=(this._robins[n]+1)%this._pools.length,typeof t){case"number":void 0===e&&(e=1),this._pools[a].update([i,this._eventId++,1,e,s,1,0|t]);break;case"object":var l=Object.prototype.toString.call(t);if("[object Uint32Array]"===l){for(o=[],r=0;r<t.length;r++)o.push(t[r]);t=o}else for("[object Array]"!==l&&(u=1),r=0;r<t.length&&!u;r++)"number"!=typeof t[r]&&(u=1);if(!u){if(void 0===e)for(e=0,r=0;r<t.length;r++)for(o=t[r];o>0;)e++,o>>>=1;this._pools[a].update([i,this._eventId++,2,e,s,t.length].concat(t))}break;case"string":void 0===e&&(e=t.length),this._pools[a].update([i,this._eventId++,3,e,s,t.length]),this._pools[a].update(t);break;default:u=1}if(u)throw new le.exception.bug("random: addEntropy only supports number, array of numbers or string");this._poolEntropy[a]+=e,this._poolStrength+=e,c===this._NOT_READY&&(this.isReady()!==this._NOT_READY&&this._fireEvent("seeded",Math.max(this._strength,this._poolStrength)),this._fireEvent("progress",this.getProgress()))},isReady:function(t){var e=this._PARANOIA_LEVELS[void 0!==t?t:this._defaultParanoia];return this._strength&&this._strength>=e?this._poolEntropy[0]>this._BITS_PER_RESEED&&(new Date).valueOf()>this._nextReseed?this._REQUIRES_RESEED|this._READY:this._READY:this._poolStrength>=e?this._REQUIRES_RESEED|this._NOT_READY:this._NOT_READY},getProgress:function(t){var e=this._PARANOIA_LEVELS[t?t:this._defaultParanoia];return this._strength>=e?1:this._poolStrength>e?1:this._poolStrength/e},startCollectors:function(){if(!this._collectorsStarted){if(window.addEventListener)window.addEventListener("load",this._loadTimeCollector,!1),window.addEventListener("mousemove",this._mouseCollector,!1);else{if(!document.attachEvent)throw new le.exception.bug("can't attach event");document.attachEvent("onload",this._loadTimeCollector),document.attachEvent("onmousemove",this._mouseCollector)}this._collectorsStarted=!0}},stopCollectors:function(){this._collectorsStarted&&(window.removeEventListener?(window.removeEventListener("load",this._loadTimeCollector,!1),window.removeEventListener("mousemove",this._mouseCollector,!1)):window.detachEvent&&(window.detachEvent("onload",this._loadTimeCollector),window.detachEvent("onmousemove",this._mouseCollector)),this._collectorsStarted=!1)},addEventListener:function(t,e){this._callbacks[t][this._callbackI++]=e},removeEventListener:function(t,e){var n,i,r=this._callbacks[t],o=[];for(i in r)r.hasOwnProperty(i)&&r[i]===e&&o.push(i);for(n=0;n<o.length;n++)i=o[n],delete r[i]},_pools:[new le.hash.sha256],_poolEntropy:[0],_reseedCount:0,_robins:{},_eventId:0,_collectorIds:{},_collectorIdNext:0,_strength:0,_poolStrength:0,_nextReseed:0,_key:[0,0,0,0,0,0,0,0],_counter:[0,0,0,0],_cipher:void 0,_defaultParanoia:6,_collectorsStarted:!1,_callbacks:{progress:{},seeded:{}},_callbackI:0,_NOT_READY:0,_READY:1,_REQUIRES_RESEED:2,_MAX_WORDS_PER_BURST:65536,_PARANOIA_LEVELS:[0,48,64,96,128,192,256,384,512,768,1024],_MILLISECONDS_PER_RESEED:3e4,_BITS_PER_RESEED:80,_gen4words:function(){for(var t=0;4>t&&(this._counter[t]=this._counter[t]+1|0,!this._counter[t]);t++);return this._cipher.encrypt(this._counter)},_gate:function(){this._key=this._gen4words().concat(this._gen4words()),this._cipher=new le.cipher.aes(this._key)},_reseed:function(t){this._key=le.hash.sha256.hash(this._key.concat(t)),this._cipher=new le.cipher.aes(this._key);for(var e=0;4>e&&(this._counter[e]=this._counter[e]+1|0,!this._counter[e]);e++);},_reseedFromPools:function(t){var e,n=[],i=0;for(this._nextReseed=n[0]=(new Date).valueOf()+this._MILLISECONDS_PER_RESEED,e=0;16>e;e++)n.push(4294967296*Math.random()|0);for(e=0;e<this._pools.length&&(n=n.concat(this._pools[e].finalize()),i+=this._poolEntropy[e],this._poolEntropy[e]=0,t||!(this._reseedCount&1<<e));e++);this._reseedCount>=1<<this._pools.length&&(this._pools.push(new le.hash.sha256),this._poolEntropy.push(0)),this._poolStrength-=i,i>this._strength&&(this._strength=i),this._reseedCount++,this._reseed(n)},_mouseCollector:function(t){var e=t.x||t.clientX||t.offsetX||0,n=t.y||t.clientY||t.offsetY||0;le.random.addEntropy([e,n],2,"mouse")},_loadTimeCollector:function(){le.random.addEntropy((new Date).valueOf(),2,"loadtime")},_fireEvent:function(t,e){var n,i=le.random._callbacks[t],r=[];for(n in i)i.hasOwnProperty(n)&&r.push(i[n]);for(n=0;n<r.length;n++)r[n](e)}},function(){try{var t=new Uint32Array(32);crypto.getRandomValues(t),le.random.addEntropy(t,1024,"crypto.getRandomValues")}catch(e){}}(),function(){for(var t in le.beware)le.beware.hasOwnProperty(t)&&le.beware[t]()}();var he={sjcl:le,version:"1.3.10"};he.generateAesKey=function(){return{key:le.random.randomWords(8,0),encrypt:function(t){return this.encryptWithIv(t,le.random.randomWords(4,0))},encryptWithIv:function(t,e){var n=new le.cipher.aes(this.key),i=le.codec.utf8String.toBits(t),r=le.mode.cbc.encrypt(n,i,e),o=le.bitArray.concat(e,r);return le.codec.base64.fromBits(o)}}},he.create=function(t){return new he.EncryptionClient(t)},he.EncryptionClient=function(t){var i=this,o=[];i.publicKey=t,i.version=he.version;var s=function(t,e){var n,i,r;n=document.createElement(t);for(i in e)e.hasOwnProperty(i)&&(r=e[i],n.setAttribute(i,r));return n},a=function(t){return window.jQuery&&t instanceof jQuery?t[0]:t.nodeType&&1===t.nodeType?t:document.getElementById(t)},c=function(t){var e,n,i,r,o=[];if("INTEGER"===t.typeName()&&(e=t.posContent(),n=t.posEnd(),i=t.stream.hexDump(e,n).replace(/[ \n]/g,""),o.push(i)),null!==t.sub)for(r=0;r<t.sub.length;r++)o=o.concat(c(t.sub[r]));return o},u=function(t){var e,n,i=[],r=t.children;for(n=0;n<r.length;n++)e=r[n],1===e.nodeType&&e.attributes["data-encrypted-name"]?i.push(e):e.children&&e.children.length>0&&(i=i.concat(u(e)));return i},l=function(){var n,i,o,s,a,u;try{a=r(t),n=e.decode(a)}catch(l){throw"Invalid encryption key. Please use the key labeled 'Client-Side Encryption Key'"}if(o=c(n),2!==o.length)throw"Invalid encryption key. Please use the key labeled 'Client-Side Encryption Key'";return s=o[0],i=o[1],u=new G,u.setPublic(s,i),u},h=function(){return{key:le.random.randomWords(8,0),sign:function(t){var e=new le.misc.hmac(this.key,le.hash.sha256),n=e.encrypt(t);return le.codec.base64.fromBits(n)}}};i.encrypt=function(t){var e=l(),r=he.generateAesKey(),o=h(),s=r.encrypt(t),a=o.sign(le.codec.base64.toBits(s)),c=le.bitArray.concat(r.key,o.key),u=le.codec.base64.fromBits(c),p=e.encrypt(u),f="$bt4|javascript_"+i.version.replace(/\./g,"_")+"$",d=null;return p&&(d=n(p)),f+d+"$"+s+"$"+a},i.encryptForm=function(t){var e,n,r,c,l,h;for(t=a(t),h=u(t);o.length>0;){try{t.removeChild(o[0])}catch(p){}o.splice(0,1)}for(l=0;l<h.length;l++)e=h[l],r=e.getAttribute("data-encrypted-name"),n=i.encrypt(e.value),e.removeAttribute("name"),c=s("input",{value:n,type:"hidden",name:r}),o.push(c),t.appendChild(c)},i.onSubmitEncryptForm=function(t,e){var n;t=a(t),n=function(n){return i.encryptForm(t),e?e(n):n},window.jQuery?window.jQuery(t).submit(n):t.addEventListener?t.addEventListener("submit",n,!1):t.attachEvent&&t.attachEvent("onsubmit",n)},i.formEncrypter={encryptForm:i.encryptForm,extractForm:a,onSubmitEncryptForm:i.onSubmitEncryptForm},le.random.startCollectors()
},window.Braintree=he}(),!function(t){if("object"==typeof exports)module.exports=t();else if("function"==typeof define&&define.amd)define(t);else{var e;"undefined"!=typeof window?e=window:"undefined"!=typeof global?e=global:"undefined"!=typeof self&&(e=self),e.braintree=t()}}(function(){var define,module,exports;return function t(e,n,i){function r(s,a){if(!n[s]){if(!e[s]){var c="function"==typeof require&&require;if(!a&&c)return c(s,!0);if(o)return o(s,!0);throw new Error("Cannot find module '"+s+"'")}var u=n[s]={exports:{}};e[s][0].call(u.exports,function(t){var n=e[s][1][t];return r(n?n:t)},u,u.exports,t,e,n,i)}return n[s].exports}for(var o="function"==typeof require&&require,s=0;s<i.length;s++)r(i[s]);return r}({1:[function(t,e){"use strict";t("./src/rpc-dispatcher")(),e.exports=t("./src/setup.js")},{"./src/rpc-dispatcher":212,"./src/setup.js":213}],2:[function(t,e){"use strict";function n(t,e){return t.status>=400?[t,null]:[null,e(t)]}function i(t){var e;this.attrs={},t.hasOwnProperty("sharedCustomerIdentifier")&&(this.attrs.sharedCustomerIdentifier=t.sharedCustomerIdentifier),e=s(t.clientToken),this.driver=t.driver||a,this.authUrl=e.authUrl,this.analyticsUrl=e.analytics?e.analytics.url:void 0,this.clientApiUrl=e.clientApiUrl,this.customerId=t.customerId,this.challenges=e.challenges,this.integration=t.integration||"",this.braintreeLibraryVersion=o=t.version||"",this.attrs.authorizationFingerprint=e.authorizationFingerprint,this.attrs.sharedCustomerIdentifierType=t.sharedCustomerIdentifierType,this.timeoutWatchers=[],this.requestTimeout=t.hasOwnProperty("timeout")?t.timeout:6e4}function r(t,e){var n,i={};for(n in t)t.hasOwnProperty(n)&&(i[n]=t[n]);for(n in e)e.hasOwnProperty(n)&&(i[n]=e[n]);return i}var o,s=t("./parse-client-token"),a=t("./jsonp-driver"),c=t("./util"),u=t("./sepa-mandate"),l=t("./sepa-bank-account"),h=t("./credit-card");i.prototype.requestWithTimeout=function(t,e,i,r,s){var a,c=this;e.braintreeLibraryVersion="braintree/web/"+o,e._meta={integration:this.integration},a=r(t,e,function(t,e){if(c.timeoutWatchers[e]){clearTimeout(c.timeoutWatchers[e]);var r=n(t,function(t){return i(t)});s.apply(null,r)}}),c.requestTimeout>0?this.timeoutWatchers[a]=setTimeout(function(){c.timeoutWatchers[a]=null,s.apply(null,[{errors:"Unknown error"},null])},c.requestTimeout):s.apply(null,[{errors:"Unknown error"},null])},i.prototype.post=function(t,e,n,i){this.requestWithTimeout(t,e,n,this.driver.post,i)},i.prototype.get=function(t,e,n,i){this.requestWithTimeout(t,e,n,this.driver.get,i)},i.prototype.put=function(t,e,n,i){this.requestWithTimeout(t,e,n,this.driver.put,i)},i.prototype.getCreditCards=function(t){this.get(c.joinUrlFragments([this.clientApiUrl,"v1","payment_methods"]),this.attrs,function(t){var e=0,n=t.paymentMethods.length,i=[];for(e;n>e;e++)i.push(new h(t.paymentMethods[e]));return i},t)},i.prototype.tokenizeCard=function(t,e){t.options={validate:!1},this.addCreditCard(t,function(t,n){n&&n.nonce?e(t,n.nonce):e("Unable to tokenize card.",null)})},i.prototype.addSEPAMandate=function(t,e){var n=r(this.attrs,{sepaMandate:t});this.post(c.joinUrlFragments([this.clientApiUrl,"v1","sepa_mandates.json"]),n,function(t){return new u(t.sepaMandates[0])},e)},i.prototype.acceptSEPAMandate=function(t,e){this.put(c.joinUrlFragments([this.clientApiUrl,"v1","sepa_mandates",t,"accept"]),this.attrs,function(t){return new l(t.sepaBankAccounts[0])},e)},i.prototype.getSEPAMandate=function(t,e){var n;n=t.paymentMethodToken?r(this.attrs,{paymentMethodToken:t.paymentMethodToken}):this.attrs,this.get(c.joinUrlFragments([this.clientApiUrl,"v1","sepa_mandates",t.mandateReferenceNumber||""]),n,function(t){return new u(t.sepaMandates[0])},e)},i.prototype.addCreditCard=function(t,e){var n=t.share;delete t.share;var i=r(this.attrs,{share:n,creditCard:t});this.post(c.joinUrlFragments([this.clientApiUrl,"v1","payment_methods/credit_cards"]),i,function(t){return new h(t.creditCards[0])},e)},i.prototype.unlockCreditCard=function(t,e,n){var i=r(this.attrs,{challengeResponses:e});this.put(c.joinUrlFragments([this.clientApiUrl,"v1","payment_methods/",t.nonce]),i,function(t){return new h(t.paymentMethods[0])},n)},i.prototype.sendAnalyticsEvents=function(t,e){var i,o,s,a=this,u=[];if(t=c.isArray(t)?t:[t],!this.analyticsUrl)return e&&e.apply(null,[null,{}]),void 0;for(var l in t)t.hasOwnProperty(l)&&u.push({kind:t[l]});i=this.analyticsUrl,o=r(this.attrs,{analytics:u}),s=this.driver.post(i,o,function(t,i){if(a.timeoutWatchers[i]){clearTimeout(a.timeoutWatchers[i]);var r=n(t,function(t){return t});e&&e.apply(null,r)}}),this.timeoutWatchers[s]=setTimeout(function(){a.timeoutWatchers[s]=null,e.apply(null,[{errors:"Unknown error"},null])},this.requestTimeout)},e.exports=i},{"./credit-card":3,"./jsonp-driver":4,"./parse-client-token":6,"./sepa-bank-account":8,"./sepa-mandate":9,"./util":10}],3:[function(t,e){"use strict";function n(t){for(var e=0;e<i.length;e++){var n=i[e];this[n]=t[n]}}var i=["billingAddress","branding","createdAt","createdAtMerchant","createdAtMerchantName","details","isLocked","lastUsedAt","lastUsedAtMerchant","lastUsedAtMerchantName","lastUsedByCurrentMerchant","nonce","securityQuestions","type"];e.exports=n},{}],4:[function(t,e){"use strict";function n(t,e,n){return o.get(t,e,n)}function i(t,e,n){return e._method="POST",o.get(t,e,n)}function r(t,e,n){return e._method="PUT",o.get(t,e,n)}var o=t("./jsonp");e.exports={get:n,post:i,put:r}},{"./jsonp":5}],5:[function(t,e){(function(n){function i(t,e){var n=document.createElement("script"),i=!1;n.src=t,n.async=!0;var r=e||h.error;"function"==typeof r&&(n.onerror=function(e){r({url:t,event:e})}),n.onload=n.onreadystatechange=function(){i||this.readyState&&"loaded"!==this.readyState&&"complete"!==this.readyState||(i=!0,n.onload=n.onreadystatechange=null,n&&n.parentNode&&n.parentNode.removeChild(n))},a||(a=document.getElementsByTagName("head")[0]),a.appendChild(n)}function r(t,e){var n,i,o,s=[];for(var o in t)t.hasOwnProperty(o)&&(i=t[o],n=e?c.isArray(t)?e+"[]":e+"["+o+"]":o,"object"==typeof i?s.push(r(i,n)):s.push(encodeURIComponent(n)+"="+encodeURIComponent(i)));return s.join("&")}function o(t,e,n,o){var s=-1===(t||"").indexOf("?")?"?":"&";o=o||h.callbackName||"callback";var a=o+"_json"+ ++u;return s+=r(e),l[a]=function(t){n(t,a);try{delete l[a]}catch(e){}l[a]=null},i(t+s+"&"+o+"="+a),a}function s(t){h=t}var a,c=t("./util"),u=0,l=n,h={};e.exports={get:o,init:s,stringify:r}}).call(this,"undefined"!=typeof self?self:"undefined"!=typeof window?window:{})},{"./util":10}],6:[function(t,e){"use strict";function n(t){var e;if(!t)throw new Error("Braintree API Client Misconfigured: clientToken required.");if("object"==typeof t&&null!==t)e=t;else{try{t=window.atob(t)}catch(n){}try{e=JSON.parse(t)}catch(i){throw new Error("Braintree API Client Misconfigured: clientToken is invalid.")}}if(!e.hasOwnProperty("authUrl")||!e.hasOwnProperty("clientApiUrl"))throw new Error("Braintree API Client Misconfigured: clientToken is invalid.");return e}t("./polyfill"),e.exports=n},{"./polyfill":7}],7:[function(){(function(t){"use strict";t.atob=t.atob||function(t){var e=new RegExp("^(?:[A-Za-z0-9+/]{4})*(?:[A-Za-z0-9+/]{2}==|[A-Za-z0-9+/]{3}=|[A-Za-z0-9+/]{4})([=]{1,2})?$"),n="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=",i="";if(!e.test(t))throw new Error("Braintree API Client Misconfigured: clientToken is invalid.");var r=0;do{var o=n.indexOf(t.charAt(r++)),s=n.indexOf(t.charAt(r++)),a=n.indexOf(t.charAt(r++)),c=n.indexOf(t.charAt(r++)),u=(63&o)<<2|s>>4&3,l=(15&s)<<4|a>>2&15,h=(3&a)<<6|63&c;i+=String.fromCharCode(u)+(l?String.fromCharCode(l):"")+(h?String.fromCharCode(h):"")}while(r<t.length);return i}}).call(this,"undefined"!=typeof self?self:"undefined"!=typeof window?window:{})},{}],8:[function(t,e){"use strict";function n(t){for(var e=0;e<i.length;e++){var n=i[e];this[n]=t[n]}}var i=["bic","maskedIBAN","nonce","accountHolderName"];e.exports=n},{}],9:[function(t,e){"use strict";function n(t){for(var e=0;e<i.length;e++){var n=i[e];this[n]=t[n]}}var i=["accountHolderName","bic","longFormURL","mandateReferenceNumber","maskedIBAN","shortForm"];e.exports=n},{}],10:[function(t,e){"use strict";function n(t){var e,n,i=[];for(n=0;n<t.length;n++)e=t[n],"/"===e.charAt(e.length-1)&&(e=e.substring(0,e.length-1)),"/"===e.charAt(0)&&(e=e.substring(1)),i.push(e);return i.join("/")}function i(t){return t&&"object"==typeof t&&"number"==typeof t.length&&"[object Array]"===Object.prototype.toString.call(t)||!1}e.exports={joinUrlFragments:n,isArray:i}},{}],11:[function(t,e){"use strict";function n(t){return new i(t)}var i=t("./lib/client"),r=t("./lib/jsonp"),o=t("./lib/jsonp-driver"),s=t("./lib/util"),a=t("./lib/parse-client-token");e.exports={Client:i,configure:n,util:s,JSONP:r,JSONPDriver:o,parseClientToken:a}},{"./lib/client":2,"./lib/jsonp":5,"./lib/jsonp-driver":4,"./lib/parse-client-token":6,"./lib/util":10}],12:[function(t,e){"use strict";function n(t,e){if(e=e||"["+t+"] is not a valid DOM Element",t&&t.nodeType&&1===t.nodeType)return t;if(t&&window.jQuery&&(t instanceof jQuery||"jquery"in Object(t))&&0!==t.length)return t[0];if("string"==typeof t&&document.getElementById(t))return document.getElementById(t);throw new Error(e)}e.exports={normalizeElement:n}},{}],13:[function(t,e){"use strict";function n(t,e,n,i){t.addEventListener?t.addEventListener(e,n,i):t.attachEvent&&t.attachEvent("on"+e,n)}function i(t,e,n,i){t.removeEventListener?t.removeEventListener(e,n,i):t.detachEvent&&t.detachEvent("on"+e,n)}e.exports={addEventListener:n,removeEventListener:i}},{}],14:[function(t,e){"use strict";function n(t){return"[object Function]"===r.call(t)}function i(t,e){return function(){t.apply(e,arguments)}}var r=Object.prototype.toString;e.exports={bind:i,isFunction:n}},{}],15:[function(t,e){"use strict";function n(){return"https:"===window.location.protocol}function i(t){switch(t){case null:case void 0:return"";case!0:return"1";case!1:return"0";default:return encodeURIComponent(t)}}function r(t,e){var n,o,s=[];for(o in t)if(t.hasOwnProperty(o)){var a=t[o];n=e?e+"["+o+"]":o,"object"==typeof a?s.push(r(a,n)):void 0!==a&&null!==a&&s.push(i(n)+"="+i(a))}return s.join("&")}function o(t){for(var e={},n=t.split("&"),i=0;i<n.length;i++){var r=n[i].split("="),o=r[0],s=decodeURIComponent(r[1]);e[o]=s}return e}function s(t){var e=t.split("?");return 2!==e.length?{}:o(e[1])}e.exports={isBrowserHttps:n,makeQueryString:r,decodeQueryString:o,getParams:s}},{}],16:[function(t,e){var n=t("./lib/dom"),i=t("./lib/url"),r=t("./lib/fn"),o=t("./lib/events");e.exports={normalizeElement:n.normalizeElement,isBrowserHttps:i.isBrowserHttps,makeQueryString:i.makeQueryString,decodeQueryString:i.decodeQueryString,getParams:i.getParams,removeEventListener:o.removeEventListener,addEventListener:o.addEventListener,bind:r.bind,isFunction:r.isFunction}},{"./lib/dom":12,"./lib/events":13,"./lib/fn":14,"./lib/url":15}],17:[function(t,e){function n(t,e){var n=window.getComputedStyle?getComputedStyle(t):t.currentStyle;return n[e]}function i(){return{html:{height:o.style.height||"",overflow:n(o,"overflow"),position:n(o,"position")},body:{height:s.style.height||"",overflow:n(s,"overflow")}}}function r(t,e){this.assetsUrl=t,this.container=e||document.body,this.iframe=null,o=document.documentElement,s=document.body,this.merchantPageDefaultStyles=i()}var o,s,a=t("braintree-utilities"),c=t("../shared/receiver"),u="1.0.0";r.prototype.get=function(t,e){var n=this,i=this.constructAuthorizationURL(t);this.container&&a.isFunction(this.container)?this.container(i+"&no_style=1"):this.insertIframe(i),new c(function(t){a.isFunction(n.container)||n.removeIframe(),e(t)})},r.prototype.removeIframe=function(){this.container&&this.container.nodeType&&1===this.container.nodeType?this.container.removeChild(this.iframe):this.container&&window.jQuery&&this.container instanceof jQuery?$(this.iframe,this.container).remove():"string"==typeof this.container&&document.getElementById(this.container).removeChild(this.iframe),this.unlockMerchantWindowSize()},r.prototype.insertIframe=function(t){var e=document.createElement("iframe");if(e.src=t,this.applyStyles(e),this.lockMerchantWindowSize(),this.container&&this.container.nodeType&&1===this.container.nodeType)this.container.appendChild(e);else if(this.container&&window.jQuery&&this.container instanceof jQuery&&0!==this.container.length)this.container.append(e);else{if("string"!=typeof this.container||!document.getElementById(this.container))throw new Error("Unable to find valid container for iframe.");document.getElementById(this.container).appendChild(e)}this.applyIE6Styles(e),this.iframe=e},r.prototype.applyStyles=function(t){t.style.position="fixed",t.style.top="0",t.style.left="0",t.style.height="100%",t.style.width="100%",t.setAttribute("frameborder","0"),t.setAttribute("allowTransparency","true"),t.style.border="0"},r.prototype.applyIE6Styles=function(t){var e,n=document.createElement("div");n.innerHTML="<!--[if IE 6]><i></i><![endif]-->",e=1===n.getElementsByTagName("i").length,e&&(t.style.position="relative",t.style.top="-"+parseInt(t.offsetTop,10)+"px")},r.prototype.lockMerchantWindowSize=function(){o.style.overflow="hidden",s.style.overflow="hidden",s.style.height="100%"},r.prototype.unlockMerchantWindowSize=function(){var t=this.merchantPageDefaultStyles;s.style.height=t.body.height,s.style.overflow=t.body.overflow,o.style.overflow=t.html.overflow},r.prototype.constructAuthorizationURL=function(t){var e,n=window.location.href;return n.indexOf("#")>-1&&(n=n.split("#")[0]),e=a.makeQueryString({acsUrl:t.acsUrl,pareq:t.pareq,termUrl:t.termUrl+"?version="+u,md:t.threeDSecureToken,parentUrl:n}),this.assetsUrl+"/3ds/"+u+"/html/style_frame?"+e},e.exports=r},{"../shared/receiver":22,"braintree-utilities":16}],18:[function(t,e){function n(t,e){return this.clientToken=this.parseClientToken(t),this.options=e||{},this.lookupService=new s(this.clientToken),this.api=new r.Client({clientToken:t}),this.nonce=null,this}function i(t,e){var n,i={};for(n in t)t.hasOwnProperty(n)&&(i[n]=t[n]);for(n in e)e.hasOwnProperty(n)&&(i[n]=e[n]);return i}var r=t("braintree-api"),o=t("braintree-utilities"),s=t("./lookup_service"),a=t("./authorization_service");n.prototype.startVerification=function(t,e){o.isFunction(e)&&(t.authorizationFingerprint=this.clientToken.authorizationFingerprint,this.lookupService.get(t,o.bind(this.handleLookupResponse(e),this)))},n.prototype.verify=function(t,e){var n={number:t.creditCard.number,expirationMonth:t.creditCard.expirationMonth,expirationYear:t.creditCard.expirationYear};o.isFunction(e)&&this.api.tokenizeCard(n,o.bind(function(n,i){n?e(n):(this.nonce=i,this.startVerification(t,e))},this))},n.prototype.handleLookupResponse=function(t){return function(e,n){var i;e?t(e):n.acsUrl&&n.acsUrl.length>0?(i=new a(this.clientToken.assetsUrl,this.options.container),i.get(n,o.bind(this.handleAuthenticationResponse(n,t),this))):t(null,this.prepareCbData({threeDSecureToken:n.threeDSecureToken}))}},n.prototype.handleAuthenticationResponse=function(t,e){return function(n){var i,r=o.decodeQueryString(n);r.user_closed||(i=JSON.parse(r.auth_response),i.success?e(null,this.prepareCbData({threeDSecureToken:t.threeDSecureToken})):e(i.errors))}},n.prototype.prepareCbData=function(t){return this.nonce?i(t,{nonce:this.nonce}):t},n.prototype.parseClientToken=function(t){var e;if(!t||0===t.length)throw new Error("clientToken not provided.");if(e=r.parseClientToken(t),!e.threeDSecureEnabled)throw new Error("Merchant is not 3D-Secure enabled.");return{enabled:e.threeDSecureEnabled,authorizationFingerprint:e.authorizationFingerprint,assetsUrl:e.assetsUrl,lookupURL:e.threeDSecure.lookupUrl,merchantAccountId:e.merchantAccountId}},e.exports=n},{"./authorization_service":17,"./lookup_service":20,"braintree-api":11,"braintree-utilities":16}],19:[function(t,e){{var n=t("./client");t("./authorization_service"),t("./lookup_service")}t("./vendor/json2"),e.exports={create:function(t,e){var i=new n(t,e);return i}}},{"./authorization_service":17,"./client":18,"./lookup_service":20,"./vendor/json2":21}],20:[function(t,e){function n(t,e){this.options=t||{},this.context=e||window,this.running=!1}var i="1.0.0",r=t("braintree-utilities");n.prototype.get=function(t,e){this.running||(this.running=!0,t.callback=this.createCallbackName(),t.merchantAccountId=this.options.merchantAccountId,t.version=i,this.attachJSONPCallback(e,t.callback),this.makeJSONPRequest(t))},n.prototype.createCallbackName=function(){return"braintree_callback_"+this.getUniqueId().toString()},n.prototype.attachJSONPCallback=function(t,e){var n=this;this.context[e]=function(e){n.running=!1,e.errors?t(e.errors):t(null,e)}},n.prototype.makeJSONPRequest=function(t){var e=r.makeQueryString(t),n=document.createElement("script");n.src=this.options.lookupURL+"?"+e,document.getElementsByTagName("head")[0].appendChild(n)},n.prototype.getUniqueId=function(){var t;return t=Date.now?Date.now():(new Date).getTime()},e.exports=n},{"braintree-utilities":16}],21:[function(_dereq_,module,exports){"object"!=typeof JSON&&(JSON={}),function(){"use strict";function f(t){return 10>t?"0"+t:t}function quote(t){return escapable.lastIndex=0,escapable.test(t)?'"'+t.replace(escapable,function(t){var e=meta[t];return"string"==typeof e?e:"\\u"+("0000"+t.charCodeAt(0).toString(16)).slice(-4)})+'"':'"'+t+'"'}function str(t,e){var n,i,r,o,s,a=gap,c=e[t];switch(c&&"object"==typeof c&&"function"==typeof c.toJSON&&(c=c.toJSON(t)),"function"==typeof rep&&(c=rep.call(e,t,c)),typeof c){case"string":return quote(c);case"number":return isFinite(c)?String(c):"null";case"boolean":case"null":return String(c);case"object":if(!c)return"null";if(gap+=indent,s=[],"[object Array]"===Object.prototype.toString.apply(c)){for(o=c.length,n=0;o>n;n+=1)s[n]=str(n,c)||"null";return r=0===s.length?"[]":gap?"[\n"+gap+s.join(",\n"+gap)+"\n"+a+"]":"["+s.join(",")+"]",gap=a,r}if(rep&&"object"==typeof rep)for(o=rep.length,n=0;o>n;n+=1)"string"==typeof rep[n]&&(i=rep[n],r=str(i,c),r&&s.push(quote(i)+(gap?": ":":")+r));else for(i in c)Object.prototype.hasOwnProperty.call(c,i)&&(r=str(i,c),r&&s.push(quote(i)+(gap?": ":":")+r));return r=0===s.length?"{}":gap?"{\n"+gap+s.join(",\n"+gap)+"\n"+a+"}":"{"+s.join(",")+"}",gap=a,r}}"function"!=typeof Date.prototype.toJSON&&(Date.prototype.toJSON=function(){return isFinite(this.valueOf())?this.getUTCFullYear()+"-"+f(this.getUTCMonth()+1)+"-"+f(this.getUTCDate())+"T"+f(this.getUTCHours())+":"+f(this.getUTCMinutes())+":"+f(this.getUTCSeconds())+"Z":null},String.prototype.toJSON=Number.prototype.toJSON=Boolean.prototype.toJSON=function(){return this.valueOf()});var cx=/[\u0000\u00ad\u0600-\u0604\u070f\u17b4\u17b5\u200c-\u200f\u2028-\u202f\u2060-\u206f\ufeff\ufff0-\uffff]/g,escapable=/[\\\"\x00-\x1f\x7f-\x9f\u00ad\u0600-\u0604\u070f\u17b4\u17b5\u200c-\u200f\u2028-\u202f\u2060-\u206f\ufeff\ufff0-\uffff]/g,gap,indent,meta={"\b":"\\b","	":"\\t","\n":"\\n","\f":"\\f","\r":"\\r",'"':'\\"',"\\":"\\\\"},rep;"function"!=typeof JSON.stringify&&(JSON.stringify=function(t,e,n){var i;if(gap="",indent="","number"==typeof n)for(i=0;n>i;i+=1)indent+=" ";else"string"==typeof n&&(indent=n);if(rep=e,e&&"function"!=typeof e&&("object"!=typeof e||"number"!=typeof e.length))throw new Error("JSON.stringify");return str("",{"":t})}),"function"!=typeof JSON.parse&&(JSON.parse=function(text,reviver){function walk(t,e){var n,i,r=t[e];if(r&&"object"==typeof r)for(n in r)Object.prototype.hasOwnProperty.call(r,n)&&(i=walk(r,n),void 0!==i?r[n]=i:delete r[n]);return reviver.call(t,e,r)}var j;if(text=String(text),cx.lastIndex=0,cx.test(text)&&(text=text.replace(cx,function(t){return"\\u"+("0000"+t.charCodeAt(0).toString(16)).slice(-4)})),/^[\],:{}\s]*$/.test(text.replace(/\\(?:["\\\/bfnrt]|u[0-9a-fA-F]{4})/g,"@").replace(/"[^"\\\n\r]*"|true|false|null|-?\d+(?:\.\d*)?(?:[eE][+\-]?\d+)?/g,"]").replace(/(?:^|:|,)(?:\s*\[)+/g,"")))return j=eval("("+text+")"),"function"==typeof reviver?walk({"":j},""):j;throw new SyntaxError("JSON.parse")})}()},{}],22:[function(t,e){function n(t){this.postMessageReceiver(t),this.hashChangeReceiver(t)}var i=t("braintree-utilities");n.prototype.postMessageReceiver=function(t){var e=this;this.wrappedCallback=function(n){t(n.data),e.stopListening()},i.addEventListener(window,"message",this.wrappedCallback)},n.prototype.hashChangeReceiver=function(t){var e,n=window.location.hash,i=this;this.poll=setInterval(function(){e=window.location.hash,e.length>0&&e!==n&&(i.stopListening(),e=e.substring(1,e.length),t(e),window.location.hash=n.length>0?n:"")},10)},n.prototype.stopListening=function(){clearTimeout(this.poll),i.removeEventListener(window,"message",this.wrappedCallback)},e.exports=n},{"braintree-utilities":16}],23:[function(t,e){(function(n){"use strict";function i(t,e){return t.status>=400?[t,null]:[null,e(t)]}function r(t){var e;this.attrs={},t.hasOwnProperty("sharedCustomerIdentifier")&&(this.attrs.sharedCustomerIdentifier=t.sharedCustomerIdentifier),e=a(t.clientToken),this.driver=t.driver||c,this.authUrl=e.authUrl,this.analyticsUrl=e.analytics?e.analytics.url:void 0,this.clientApiUrl=e.clientApiUrl,this.customerId=t.customerId,this.challenges=e.challenges,this.integration=t.integration||"",this.attrs.authorizationFingerprint=e.authorizationFingerprint,this.attrs.sharedCustomerIdentifierType=t.sharedCustomerIdentifierType,this.timeoutWatchers=[],this.requestTimeout=t.hasOwnProperty("timeout")?t.timeout:6e4}function o(){}function s(t,e){var n,i={};for(n in t)t.hasOwnProperty(n)&&(i[n]=t[n]);for(n in e)e.hasOwnProperty(n)&&(i[n]=e[n]);return i}var a=t("./parse-client-token"),c=t("./jsonp-driver"),u=t("./util"),l=t("./sepa-mandate"),h=t("./sepa-bank-account"),p=t("./credit-card"),f=t("./root-data");r.prototype.requestWithTimeout=function(t,e,n,r,s){s=s||o;var a,c,u=this;f.get(function(o){c="braintree/web/"+o.sdkVersion,e.braintreeLibraryVersion=c,e.hasOwnProperty("analytics")&&e.hasOwnProperty("_meta")&&(e._meta.sdkVersion=c,e._meta.merchantAppId=o.merchantAppId),a=r(t,e,function(t,e){if(u.timeoutWatchers[e]){clearTimeout(u.timeoutWatchers[e]);var r=i(t,function(t){return n(t)});s.apply(null,r)}}),u.requestTimeout>0?this.timeoutWatchers[a]=setTimeout(function(){u.timeoutWatchers[a]=null,s.apply(null,[{errors:"Unknown error"},null])},u.requestTimeout):s.apply(null,[{errors:"Unknown error"},null])},this)},r.prototype.post=function(t,e,n,i){this.requestWithTimeout(t,e,n,this.driver.post,i)},r.prototype.get=function(t,e,n,i){this.requestWithTimeout(t,e,n,this.driver.get,i)},r.prototype.put=function(t,e,n,i){this.requestWithTimeout(t,e,n,this.driver.put,i)},r.prototype.getCreditCards=function(t){this.get(u.joinUrlFragments([this.clientApiUrl,"v1","payment_methods"]),this.attrs,function(t){var e=0,n=t.paymentMethods.length,i=[];for(e;n>e;e++)i.push(new p(t.paymentMethods[e]));return i},t)},r.prototype.tokenizeCard=function(t,e){t.options={validate:!1},this.addCreditCard(t,function(t,n){n&&n.nonce?e(t,n.nonce):e("Unable to tokenize card.",null)})},r.prototype.addSEPAMandate=function(t,e){var n=s(this.attrs,{sepaMandate:t});this.post(u.joinUrlFragments([this.clientApiUrl,"v1","sepa_mandates.json"]),n,function(t){return new l(t.sepaMandates[0])},e)},r.prototype.acceptSEPAMandate=function(t,e){this.put(u.joinUrlFragments([this.clientApiUrl,"v1","sepa_mandates",t,"accept"]),this.attrs,function(t){return new h(t.sepaBankAccounts[0])},e)},r.prototype.getSEPAMandate=function(t,e){var n;n=t.paymentMethodToken?s(this.attrs,{paymentMethodToken:t.paymentMethodToken}):this.attrs,this.get(u.joinUrlFragments([this.clientApiUrl,"v1","sepa_mandates",t.mandateReferenceNumber||""]),n,function(t){return new l(t.sepaMandates[0])},e)},r.prototype.addCreditCard=function(t,e){var n,i=t.share;delete t.share,n=s(this.attrs,{share:i,creditCard:t,_meta:{integration:this.integration||"custom",source:"form"}}),this.post(u.joinUrlFragments([this.clientApiUrl,"v1","payment_methods/credit_cards"]),n,function(t){return new p(t.creditCards[0])},e)},r.prototype.unlockCreditCard=function(t,e,n){var i=s(this.attrs,{challengeResponses:e});this.put(u.joinUrlFragments([this.clientApiUrl,"v1","payment_methods/",t.nonce]),i,function(t){return new p(t.paymentMethods[0])},n)},r.prototype.sendAnalyticsEvents=function(t,e){var i,r=this.analyticsUrl,o=[];if(t=u.isArray(t)?t:[t],!r)return e&&e.apply(null,[null,{}]),void 0;for(var a in t)t.hasOwnProperty(a)&&o.push({kind:t[a]});i=s(this.attrs,{analytics:o,_meta:{platform:"web",platformVersion:n.navigator.userAgent,integrationType:this.integration}}),this.post(r,i,function(t){return t},e)},e.exports=r}).call(this,"undefined"!=typeof self?self:"undefined"!=typeof window?window:{})},{"./credit-card":24,"./jsonp-driver":25,"./parse-client-token":27,"./root-data":29,"./sepa-bank-account":30,"./sepa-mandate":31,"./util":32}],24:[function(t,e){e.exports=t(3)},{}],25:[function(t,e){e.exports=t(4)},{"./jsonp":26}],26:[function(t,e){e.exports=t(5)},{"./util":32}],27:[function(t,e){e.exports=t(6)},{"./polyfill":28}],28:[function(t,e){e.exports=t(7)},{}],29:[function(t,e){(function(n){"use strict";function i(){var t=n.braintree;return t&&t.hasOwnProperty("VERSION")?t.VERSION:void 0}function r(t){function e(e){u||(u=!0,t(e))}c.invoke("getExternalData",[],e),setTimeout(function(){u||e()},250)}function o(t,e){u?t.call(e,l):r(function(n){for(var i in n)n.hasOwnProperty(i)&&(l[i]=n[i]||l[i]);t.call(e,l)})}var s=t("braintree-rpc"),a=new s.MessageBus(window),c=new s.RPCClient(a,window.parent),u=!1,l={sdkVersion:i(),merchantAppId:n.location.href};e.exports={get:o}}).call(this,"undefined"!=typeof self?self:"undefined"!=typeof window?window:{})},{"braintree-rpc":39}],30:[function(t,e){e.exports=t(8)},{}],31:[function(t,e){e.exports=t(9)},{}],32:[function(t,e){e.exports=t(10)},{}],33:[function(t,e,n){arguments[4][11][0].apply(n,arguments)},{"./lib/client":23,"./lib/jsonp":26,"./lib/jsonp-driver":25,"./lib/parse-client-token":27,"./lib/util":32}],34:[function(t,e){"use strict";function n(t){this.host=t||window,this.handlers=[],i.addEventListener(this.host,"message",i.bind(this.receive,this))}var i=t("braintree-utilities");n.prototype.receive=function(t){var e,i,r,o;try{r=JSON.parse(t.data)}catch(s){return}for(o=r.type,i=new n.Message(this,t.source,r.data),e=0;e<this.handlers.length;e++)this.handlers[e].type===o&&this.handlers[e].handler(i)},n.prototype.send=function(t,e,n){t.postMessage(JSON.stringify({type:e,data:n}),"*")},n.prototype.register=function(t,e){this.handlers.push({type:t,handler:e})},n.prototype.unregister=function(t,e){for(var n=this.handlers.length-1;n>=0;n--)if(this.handlers[n].type===t&&this.handlers[n].handler===e)return this.handlers.splice(n,1)},n.Message=function(t,e,n){this.bus=t,this.source=e,this.content=n},n.Message.prototype.reply=function(t,e){this.bus.send(this.source,t,e)},e.exports=n},{"braintree-utilities":44}],35:[function(t,e){"use strict";function n(t,e){this.bus=t,this.target=e,this.handlers=[],this.bus.register("publish",i.bind(this._handleMessage,this))}var i=t("braintree-utilities");n.prototype._handleMessage=function(t){var e,n=t.content,i=this.handlers[n.channel];if("undefined"!=typeof i)for(e=0;e<i.length;e++)i[e](n.data)},n.prototype.publish=function(t,e){this.bus.send(this.target,"publish",{channel:t,data:e})},n.prototype.subscribe=function(t,e){this.handlers[t]=this.handlers[t]||[],this.handlers[t].push(e)},n.prototype.unsubscribe=function(t,e){var n,i=this.handlers[t];if("undefined"!=typeof i)for(n=0;n<i.length;n++)i[n]===e&&i.splice(n,1)},e.exports=n},{"braintree-utilities":44}],36:[function(t,e){"use strict";function n(t){this.bus=t,this.frames=[],this.handlers=[]}n.prototype.subscribe=function(t,e){this.handlers[t]=this.handlers[t]||[],this.handlers[t].push(e)},n.prototype.registerFrame=function(t){this.frames.push(t)},n.prototype.unregisterFrame=function(t){for(var e=0;e<this.frames.length;e++)this.frames[e]===t&&this.frames.splice(e,1)},n.prototype.publish=function(t,e){var n,i=this.handlers[t];if("undefined"!=typeof i)for(n=0;n<i.length;n++)i[n](e);for(n=0;n<this.frames.length;n++)this.bus.send(this.frames[n],"publish",{channel:t,data:e})},n.prototype.unsubscribe=function(t,e){var n,i=this.handlers[t];if("undefined"!=typeof i)for(n=0;n<i.length;n++)i[n]===e&&i.splice(n,1)},e.exports=n},{}],37:[function(t,e){"use strict";function n(t,e){this.bus=t,this.target=e||window.parent,this.counter=0,this.callbacks={},this.bus.register("rpc_response",i.bind(this._handleResponse,this))}var i=t("braintree-utilities");n.prototype._handleResponse=function(t){var e=t.content,n=this.callbacks[e.id];"function"==typeof n&&(n.apply(null,e.response),delete this.callbacks[e.id])},n.prototype.invoke=function(t,e,n){var i=this.counter++;this.callbacks[i]=n,this.bus.send(this.target,"rpc_request",{id:i,method:t,args:e})},e.exports=n},{"braintree-utilities":44}],38:[function(t,e){"use strict";function n(t){this.bus=t,this.methods={},this.bus.register("rpc_request",i.bind(this._handleRequest,this))}var i=t("braintree-utilities");n.prototype._handleRequest=function(t){var e,n=t.content,i=n.args||[],r=this.methods[n.method];"function"==typeof r&&(e=function(){t.reply("rpc_response",{id:n.id,response:Array.prototype.slice.call(arguments)})},i.push(e),r.apply(null,i))},n.prototype.define=function(t,e){this.methods[t]=e},e.exports=n},{"braintree-utilities":44}],39:[function(t,e){var n=t("./lib/message-bus"),i=t("./lib/pubsub-client"),r=t("./lib/pubsub-server"),o=t("./lib/rpc-client"),s=t("./lib/rpc-server");e.exports={MessageBus:n,PubsubClient:i,PubsubServer:r,RPCClient:o,RPCServer:s}},{"./lib/message-bus":34,"./lib/pubsub-client":35,"./lib/pubsub-server":36,"./lib/rpc-client":37,"./lib/rpc-server":38}],40:[function(t,e){"use strict";function n(t,e){if(e=e||"["+t+"] is not a valid DOM Element",t&&t.nodeType&&1===t.nodeType)return t;if(t&&window.jQuery&&t instanceof jQuery&&0!==t.length)return t[0];if("string"==typeof t&&document.getElementById(t))return document.getElementById(t);throw new Error(e)}e.exports={normalizeElement:n}},{}],41:[function(t,e){"use strict";function n(t,e,n){t.addEventListener?t.addEventListener(e,n,!1):t.attachEvent&&t.attachEvent("on"+e,n)}function i(t,e,n){t.removeEventListener?t.removeEventListener(e,n,!1):t.detachEvent&&t.detachEvent("on"+e,n)}e.exports={removeEventListener:i,addEventListener:n}},{}],42:[function(t,e){"use strict";function n(t){return"[object Function]"===Object.prototype.toString.call(t)}function i(t,e){return function(){t.apply(e,arguments)}}e.exports={bind:i,isFunction:n}},{}],43:[function(t,e){e.exports=t(15)},{}],44:[function(t,e,n){arguments[4][16][0].apply(n,arguments)},{"./lib/dom":40,"./lib/events":41,"./lib/fn":42,"./lib/url":43}],45:[function(t,e){e.exports=t(23)},{"./credit-card":46,"./jsonp-driver":47,"./parse-client-token":49,"./root-data":51,"./sepa-bank-account":52,"./sepa-mandate":53,"./util":54}],46:[function(t,e){e.exports=t(3)},{}],47:[function(t,e){e.exports=t(4)},{"./jsonp":48}],48:[function(t,e){e.exports=t(5)},{"./util":54}],49:[function(t,e){e.exports=t(6)},{"./polyfill":50}],50:[function(t,e){e.exports=t(7)},{}],51:[function(t,e){e.exports=t(29)},{"braintree-rpc":61}],52:[function(t,e){e.exports=t(8)},{}],53:[function(t,e){e.exports=t(9)},{}],54:[function(t,e){e.exports=t(10)},{}],55:[function(t,e,n){arguments[4][11][0].apply(n,arguments)},{"./lib/client":45,"./lib/jsonp":48,"./lib/jsonp-driver":47,"./lib/parse-client-token":49,"./lib/util":54}],56:[function(t,e){e.exports=t(34)},{"braintree-utilities":66}],57:[function(t,e){e.exports=t(35)},{"braintree-utilities":66}],58:[function(t,e){e.exports=t(36)},{}],59:[function(t,e){e.exports=t(37)},{"braintree-utilities":66}],60:[function(t,e){e.exports=t(38)},{"braintree-utilities":66}],61:[function(t,e){e.exports=t(39)},{"./lib/message-bus":56,"./lib/pubsub-client":57,"./lib/pubsub-server":58,"./lib/rpc-client":59,"./lib/rpc-server":60}],62:[function(t,e){e.exports=t(40)},{}],63:[function(t,e){e.exports=t(41)},{}],64:[function(t,e){e.exports=t(42)},{}],65:[function(t,e){e.exports=t(15)},{}],66:[function(t,e,n){arguments[4][16][0].apply(n,arguments)
},{"./lib/dom":62,"./lib/events":63,"./lib/fn":64,"./lib/url":65}],67:[function(t,e){e.exports=t(23)},{"./credit-card":68,"./jsonp-driver":69,"./parse-client-token":71,"./root-data":73,"./sepa-bank-account":74,"./sepa-mandate":75,"./util":76}],68:[function(t,e){e.exports=t(3)},{}],69:[function(t,e){e.exports=t(4)},{"./jsonp":70}],70:[function(t,e){e.exports=t(5)},{"./util":76}],71:[function(t,e){e.exports=t(6)},{"./polyfill":72}],72:[function(t,e){e.exports=t(7)},{}],73:[function(t,e){e.exports=t(29)},{"braintree-rpc":83}],74:[function(t,e){e.exports=t(8)},{}],75:[function(t,e){e.exports=t(9)},{}],76:[function(t,e){e.exports=t(10)},{}],77:[function(t,e,n){arguments[4][11][0].apply(n,arguments)},{"./lib/client":67,"./lib/jsonp":70,"./lib/jsonp-driver":69,"./lib/parse-client-token":71,"./lib/util":76}],78:[function(t,e){e.exports=t(34)},{"braintree-utilities":88}],79:[function(t,e){e.exports=t(35)},{"braintree-utilities":88}],80:[function(t,e){e.exports=t(36)},{}],81:[function(t,e){e.exports=t(37)},{"braintree-utilities":88}],82:[function(t,e){e.exports=t(38)},{"braintree-utilities":88}],83:[function(t,e){e.exports=t(39)},{"./lib/message-bus":78,"./lib/pubsub-client":79,"./lib/pubsub-server":80,"./lib/rpc-client":81,"./lib/rpc-server":82}],84:[function(t,e){e.exports=t(40)},{}],85:[function(t,e){e.exports=t(41)},{}],86:[function(t,e){e.exports=t(42)},{}],87:[function(t,e){e.exports=t(15)},{}],88:[function(t,e,n){arguments[4][16][0].apply(n,arguments)},{"./lib/dom":84,"./lib/events":85,"./lib/fn":86,"./lib/url":87}],89:[function(t,e){e.exports=t(34)},{"braintree-utilities":99}],90:[function(t,e){e.exports=t(35)},{"braintree-utilities":99}],91:[function(t,e){e.exports=t(36)},{}],92:[function(t,e){e.exports=t(37)},{"braintree-utilities":99}],93:[function(t,e){e.exports=t(38)},{"braintree-utilities":99}],94:[function(t,e){e.exports=t(39)},{"./lib/message-bus":89,"./lib/pubsub-client":90,"./lib/pubsub-server":91,"./lib/rpc-client":92,"./lib/rpc-server":93}],95:[function(t,e){e.exports=t(40)},{}],96:[function(t,e){e.exports=t(41)},{}],97:[function(t,e){e.exports=t(42)},{}],98:[function(t,e){e.exports=t(15)},{}],99:[function(t,e,n){arguments[4][16][0].apply(n,arguments)},{"./lib/dom":95,"./lib/events":96,"./lib/fn":97,"./lib/url":98}],100:[function(t,e){e.exports=t(40)},{}],101:[function(t,e){e.exports=t(41)},{}],102:[function(t,e){e.exports=t(42)},{}],103:[function(t,e){e.exports=t(15)},{}],104:[function(t,e,n){arguments[4][16][0].apply(n,arguments)},{"./lib/dom":100,"./lib/events":101,"./lib/fn":102,"./lib/url":103}],105:[function(t,e){function n(t){var e=window.getComputedStyle?getComputedStyle(t):t.currentStyle;return{overflow:e.overflow||"",height:t.style.height||""}}function i(){return{html:{node:document.documentElement,styles:n(document.documentElement)},body:{node:document.body,styles:n(document.body)}}}function r(t,e){if(!t)throw new Error('Parameter "clientToken" cannot be null');e=e||{},this._clientToken=o.parseClientToken(t),this._clientOptions=e,this.container=e.container,this.merchantPageDefaultStyles=null,this.paymentMethodNonceInputField=e.paymentMethodNonceInputField,this.frame=null,this.popup=null,this.insertFrameFunction=e.insertFrame,this.onSuccess=e.onSuccess,this.onCancelled=e.onCancelled,this.onUnsupported=e.onUnsupported,this.loggedInView=null,this.loggedOutView=null,this.insertUI=!0}{var o=t("braintree-api"),s=t("braintree-rpc"),a=t("braintree-utilities"),c=t("./logged-in-view"),u=t("./logged-out-view"),l=t("../shared/util/browser"),h=t("../shared/util/dom"),p=t("../shared/constants");t("../shared/util/util")}r.prototype.getViewerUrl=function(){var t=this._clientToken.paypal.assetsUrl;return t+"/pwpp/"+p.VERSION+"/html/braintree-frame.html"},r.prototype.initialize=function(){return this._clientToken.paypalEnabled?this._isBrowserSecure()?(this._overrideClientTokenProperties(),this._setupDomElements(),this._setupPaymentMethodNonceInputField(),this._setupViews(),this._createRpcServer(),void 0):("function"==typeof this.onUnsupported&&this.onUnsupported(new Error("unsupported protocol detected")),void 0):("function"==typeof this.onUnsupported&&this.onUnsupported(new Error("PayPal is not enabled")),void 0)},r.prototype._isBrowserSecure=function(){return a.isBrowserHttps()||this._clientToken.paypal.allowHttp},r.prototype._overrideClientTokenProperties=function(){this._clientOptions.displayName&&(this._clientToken.paypal.displayName=this._clientOptions.displayName)},r.prototype._setupDomElements=function(){this.insertUI&&(this.container=a.normalizeElement(this.container))},r.prototype._setupPaymentMethodNonceInputField=function(){if(this.insertUI){var t=this.paymentMethodNonceInputField;a.isFunction(t)||(t=void 0!==t?a.normalizeElement(t):this._createPaymentMethodNonceInputField(),this.paymentMethodNonceInputField=t)}},r.prototype._setupViews=function(){var t=this._clientToken.paypal.assetsUrl;this.insertUI&&(this.loggedInView=new c({container:this.container,assetsUrl:t}),this.loggedOutView=new u({assetsUrl:t,container:this.container}),a.addEventListener(this.loggedOutView.buttonNode,"click",a.bind(this._handleButtonClick,this)),a.addEventListener(this.loggedInView.logoutNode,"click",a.bind(this._handleLogout,this)))},r.prototype._createRpcServer=function(){var t=new s.MessageBus(window),e=new s.RPCServer(t,window);e.define("getClientToken",a.bind(this._handleGetClientToken,this)),e.define("getClientOptions",a.bind(this._handleGetClientOptions,this)),e.define("closePayPalModal",a.bind(this._handleCloseMessage,this)),e.define("receivePayPalData",a.bind(this._handleSuccessfulAuthentication,this))},r.prototype._createPaymentMethodNonceInputField=function(){var t=document.createElement("input");return t.name="payment_method_nonce",t.type="hidden",this.container.appendChild(t)},r.prototype._createFrame=function(){var t=document.createElement("iframe");return t.src=this.getViewerUrl(),t.id=p.FRAME_NAME,t.name=p.FRAME_NAME,t.allowTransparency=!0,t.height="100%",t.width="100%",t.frameBorder=0,t.style.position=l.isMobile()?"absolute":"fixed",t.style.top=0,t.style.left=0,t.style.bottom=0,t.style.zIndex=20001,t.style.padding=0,t.style.margin=0,t.style.border=0,t.style.outline="none",t},r.prototype._removeFrame=function(t){t=t||document.body,this.frame&&t.contains(this.frame)&&(t.removeChild(this.frame),this._unlockMerchantWindowSize())},r.prototype._insertFrame=function(){this.insertFrameFunction?this.insertFrameFunction(this.getViewerUrl()):(this.frame=this._createFrame(),document.body.appendChild(this.frame)),this._lockMerchantWindowSize()},r.prototype._handleButtonClick=function(t){t.preventDefault?t.preventDefault():t.returnValue=!1,this._open()},r.prototype._setMerchantPageDefaultStyles=function(){this.merchantPageDefaultStyles=i()},r.prototype._open=function(){l.isPopupSupported()?this._openPopup():this._openModal()},r.prototype._close=function(){l.isPopupSupported()?this._closePopup():this._closeModal()},r.prototype._openModal=function(){this._removeFrame(),this._insertFrame()},r.prototype._openPopup=function(){var t=p.POPUP_NAME,e=p.POPUP_OPTIONS;return this.popup=window.open(this.getViewerUrl(),t,e),this.popup.focus(),this.popup},r.prototype._closeModal=function(){this._removeFrame()},r.prototype._closePopup=function(){this.popup&&(this.popup.close(),this.popup=null)},r.prototype._handleGetClientToken=function(t){var e={analyticsUrl:this._clientToken.analytics?this._clientToken.analytics.url:void 0,authorizationFingerprint:this._clientToken.authorizationFingerprint,authUrl:this._clientToken.authUrl,clientApiUrl:this._clientToken.clientApiUrl,displayName:this._clientToken.paypal.displayName,paypalBaseUrl:this._clientToken.paypal.assetsUrl,paypalClientId:this._clientToken.paypal.clientId,paypalPrivacyUrl:this._clientToken.paypal.privacyUrl,paypalUserAgreementUrl:this._clientToken.paypal.userAgreementUrl,offline:this._clientToken.paypal.environmentNoNetwork};t(e)},r.prototype._handleGetClientOptions=function(t){var e={demo:this._clientOptions.demo||!1,locale:this._clientOptions.locale||"en_us",onetime:this._clientOptions.singleUse||!1,integration:this._clientOptions.integration||"paypal",enableShippingAddress:this._clientOptions.enableShippingAddress||!1};t(e)},r.prototype._handleSuccessfulAuthentication=function(t){this._close(),a.isFunction(this.paymentMethodNonceInputField)?this.paymentMethodNonceInputField(t.nonce):(this._showLoggedInContent(t.email),this._setNonceInputValue(t.nonce)),a.isFunction(this.onSuccess)&&this.onSuccess(t)},r.prototype._lockMerchantWindowSize=function(){this._setMerchantPageDefaultStyles(),document.documentElement.style.height="100%",document.documentElement.style.overflow="hidden",document.body.style.height="100%",document.body.style.overflow="hidden"},r.prototype._unlockMerchantWindowSize=function(){this.merchantPageDefaultStyles&&(document.documentElement.style.height=this.merchantPageDefaultStyles.html.styles.height,document.documentElement.style.overflow=this.merchantPageDefaultStyles.html.styles.overflow,document.body.style.height=this.merchantPageDefaultStyles.body.styles.height,document.body.style.overflow=this.merchantPageDefaultStyles.body.styles.overflow)},r.prototype._handleCloseMessage=function(){this._removeFrame()},r.prototype._showLoggedInContent=function(t){this.loggedOutView.hide(),h.setTextContent(this.loggedInView.emailNode,t),this.loggedInView.show()},r.prototype._handleLogout=function(t){t.preventDefault?t.preventDefault():t.returnValue=!1,this.loggedInView.hide(),this.loggedOutView.show(),this._setNonceInputValue(""),a.isFunction(this.onCancelled)&&this.onCancelled()},r.prototype._setNonceInputValue=function(t){this.paymentMethodNonceInputField.value=t},e.exports=r},{"../shared/constants":108,"../shared/util/browser":113,"../shared/util/dom":114,"../shared/util/util":115,"./logged-in-view":106,"./logged-out-view":107,"braintree-api":77,"braintree-rpc":94,"braintree-utilities":104}],106:[function(t,e){function n(t){this.options=t,this.container=this.createViewContainer(),this.createPayPalName(),this.emailNode=this.createEmailNode(),this.logoutNode=this.createLogoutNode()}var i=t("../shared/constants");n.prototype.createViewContainer=function(){var t=document.createElement("div");t.id="braintree-paypal-loggedin";var e=["display: none","max-width: 500px","overflow: hidden","padding: 16px","background-image: url("+this.options.assetsUrl+"/pwpp/"+i.VERSION+"/images/paypal-small.png)","background-image: url("+this.options.assetsUrl+"/pwpp/"+i.VERSION+"/images/paypal-small.svg), none","background-position: 20px 50%","background-repeat: no-repeat","background-size: 13px 15px","border-top: 1px solid #d1d4d6","border-bottom: 1px solid #d1d4d6"].join(";");return t.style.cssText=e,this.options.container.appendChild(t),t},n.prototype.createPayPalName=function(){var t=document.createElement("span");t.id="bt-pp-name",t.innerHTML="PayPal";var e=["color: #283036","font-size: 13px","font-weight: 800",'font-family: "Helvetica Neue", Helvetica, Arial, sans-serif',"margin-left: 36px","-webkit-font-smoothing: antialiased","-moz-font-smoothing: antialiased","-ms-font-smoothing: antialiased","font-smoothing: antialiased"].join(";");return t.style.cssText=e,this.container.appendChild(t)},n.prototype.createEmailNode=function(){var t=document.createElement("span");t.id="bt-pp-email";var e=["color: #6e787f","font-size: 13px",'font-family: "Helvetica Neue", Helvetica, Arial, sans-serif',"margin-left: 5px","-webkit-font-smoothing: antialiased","-moz-font-smoothing: antialiased","-ms-font-smoothing: antialiased","font-smoothing: antialiased"].join(";");return t.style.cssText=e,this.container.appendChild(t)},n.prototype.createLogoutNode=function(){var t=document.createElement("button");t.id="bt-pp-cancel",t.innerHTML="Cancel";var e=["color: #3d95ce","font-size: 11px",'font-family: "Helvetica Neue", Helvetica, Arial, sans-serif',"line-height: 20px","margin: 0 0 0 25px","padding: 0","background-color: transparent","border: 0","cursor: pointer","text-decoration: underline","float: right","-webkit-font-smoothing: antialiased","-moz-font-smoothing: antialiased","-ms-font-smoothing: antialiased","font-smoothing: antialiased"].join(";");return t.style.cssText=e,this.container.appendChild(t)},n.prototype.show=function(){this.container.style.display="block"},n.prototype.hide=function(){this.container.style.display="none"},e.exports=n},{"../shared/constants":108}],107:[function(t,e){function n(t){this.options=t,this.assetsUrl=this.options.assetsUrl,this.container=this.createViewContainer(),this.buttonNode=this.createPayWithPayPalButton()}var i=t("../shared/constants");n.prototype.createViewContainer=function(){var t=document.createElement("div");return t.id="braintree-paypal-loggedout",this.options.container.appendChild(t),t},n.prototype.createPayWithPayPalButton=function(){var t=document.createElement("a");t.id="braintree-paypal-button",t.href="#";var e=["display: block","width: 115px","height: 44px","overflow: hidden"].join(";");t.style.cssText=e;var n=new Image;n.src=this.assetsUrl+"/pwpp/"+i.VERSION+"/images/pay-with-paypal.png",n.setAttribute("alt","Pay with PayPal");var r=["max-width: 100%","display: block","width: 100%","height: 100%","outline: none","border: 0"].join(";");return n.style.cssText=r,t.appendChild(n),this.container.appendChild(t)},n.prototype.show=function(){this.container.style.display="block"},n.prototype.hide=function(){this.container.style.display="none"},e.exports=n},{"../shared/constants":108}],108:[function(t,e,n){var i="1.2.1";n.VERSION=i,n.POPUP_NAME="braintree_paypal_popup",n.FRAME_NAME="braintree-paypal-frame",n.POPUP_PATH="/pwpp/"+i+"/html/braintree-frame.html",n.POPUP_OPTIONS="height=470,width=410,resizable,scrollbars"},{}],109:[function(t,e){function n(){return u.matchUserAgent("Android")&&!i()}function i(){return u.matchUserAgent("Chrome")||u.matchUserAgent("CriOS")}function r(){return u.matchUserAgent("Firefox")}function o(){return u.matchUserAgent("Trident")||u.matchUserAgent("MSIE")}function s(){return u.matchUserAgent("Opera")||u.matchUserAgent("OPR")}function a(){return s()&&"[object OperaMini]"===l.call(window.operamini)}function c(){return u.matchUserAgent("Safari")&&!i()&&!n()}var u=t("./useragent"),l=Object.prototype.toString;e.exports={isAndroid:n,isChrome:i,isFirefox:r,isIE:o,isOpera:s,isOperaMini:a,isSafari:c}},{"./useragent":112}],110:[function(t,e){function n(){return!i()&&(s.isAndroid()||s.isIpod()||s.isIphone()||o.matchUserAgent("IEMobile"))}function i(){return s.isIpad()||s.isAndroid()&&!o.matchUserAgent("Mobile")}function r(){return!n()&&!i()}var o=t("./useragent"),s=t("./platform");e.exports={isMobile:n,isTablet:i,isDesktop:r}},{"./platform":111,"./useragent":112}],111:[function(t,e){function n(){return a.matchUserAgent("Android")}function i(){return a.matchUserAgent("iPad")}function r(){return a.matchUserAgent("iPod")}function o(){return a.matchUserAgent("iPhone")&&!r()}function s(){return i()||r()||o()}var a=t("./useragent");e.exports={isAndroid:n,isIpad:i,isIpod:r,isIphone:o,isIos:s}},{"./useragent":112}],112:[function(t,e,n){function i(){return o}function r(t){var e=n.getNativeUserAgent(),i=e.match(t);return i?!0:!1}var o=window.navigator.userAgent;n.getNativeUserAgent=i,n.matchUserAgent=r},{}],113:[function(t,e){function n(){return i()&&window.outerWidth<600}function i(){return p.test(h)}function r(){return!!window.postMessage}function o(){return a.isOpera()||a.isOperaMini()||u.isIos()&&a.isSafari()&&l.matchUserAgent(/Version\/8/i)?!1:u.isIos()&&a.isSafari()?!0:c.isDesktop()&&(a.isChrome()||a.isFirefox()||a.isSafari()||l.matchUserAgent(/MSIE 10\.0/)&&!s())?!0:!1}function s(){var t=null,e="";try{new ActiveXObject("")}catch(n){e=n.name}try{t=!!new ActiveXObject("htmlfile")}catch(n){t=!1}return t="ReferenceError"!==e&&t===!1?!1:!0,!t}var a=t("../useragent/browser"),c=t("../useragent/device"),u=t("../useragent/platform"),l=t("../useragent/useragent"),h=window.navigator.userAgent,p=/[Mm]obi|tablet|iOS|Android|IEMobile|Windows\sPhone/;e.exports={isMobile:n,isMobileDevice:i,detectedPostMessage:r,isPopupSupported:o}},{"../useragent/browser":109,"../useragent/device":110,"../useragent/platform":111,"../useragent/useragent":112}],114:[function(t,e){function n(t,e){var n="innerText";document&&document.body&&"textContent"in document.body&&(n="textContent"),t[n]=e}e.exports={setTextContent:n}},{}],115:[function(t,e){function n(){for(var t="",e=0;32>e;e++){var n=Math.floor(16*Math.random());t+=n.toString(16)}return t}function i(t){return/^(true|1)$/i.test(t)}function r(t){return t.replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;").replace(/\"/g,"&quot;").replace(/\'/g,"&apos;")}var o="function"==typeof String.prototype.trim?function(t){return t.trim()}:function(t){return t.replace(/^\s+|\s+$/,"")},s="function"==typeof window.btoa?function(t){return window.btoa(t)}:function(t){for(var e,n,i,r,o,s,a,c="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=",u="",l=0;l<t.length;)e=t.charCodeAt(l++),n=t.charCodeAt(l++),i=t.charCodeAt(l++),r=e>>2,o=(3&e)<<4|n>>4,s=(15&n)<<2|i>>6,a=63&i,isNaN(n)?s=a=64:isNaN(i)&&(a=64),u=u+c.charAt(r)+c.charAt(o)+c.charAt(s)+c.charAt(a);return u};e.exports={trim:o,btoa:s,generateUid:n,castToBoolean:i,htmlEscape:r}},{}],116:[function(t,e){e.exports=t(34)},{"braintree-utilities":126}],117:[function(t,e){e.exports=t(35)},{"braintree-utilities":126}],118:[function(t,e){e.exports=t(36)},{}],119:[function(t,e){e.exports=t(37)},{"braintree-utilities":126}],120:[function(t,e){e.exports=t(38)},{"braintree-utilities":126}],121:[function(t,e){e.exports=t(39)},{"./lib/message-bus":116,"./lib/pubsub-client":117,"./lib/pubsub-server":118,"./lib/rpc-client":119,"./lib/rpc-server":120}],122:[function(t,e){e.exports=t(40)},{}],123:[function(t,e){e.exports=t(41)},{}],124:[function(t,e){e.exports=t(42)},{}],125:[function(t,e){e.exports=t(15)},{}],126:[function(t,e,n){arguments[4][16][0].apply(n,arguments)},{"./lib/dom":122,"./lib/events":123,"./lib/fn":124,"./lib/url":125}],127:[function(t,e){e.exports=t(12)},{}],128:[function(t,e){e.exports=t(13)},{}],129:[function(t,e){e.exports=t(14)},{}],130:[function(t,e){e.exports=t(15)},{}],131:[function(t,e){e.exports=t(16)},{"./lib/dom":127,"./lib/events":128,"./lib/fn":129,"./lib/url":130}],132:[function(t,e){"use strict";function n(t){this.apiClient=t}var i=["getCreditCards","unlockCreditCard","sendAnalyticsEvents"];n.prototype.attach=function(t){function e(e){t.define(e,function(){n.apiClient[e].apply(n.apiClient,arguments)})}var n=this,r=0,o=i.length;for(r;o>r;r++)e(i[r])},e.exports=n},{}],133:[function(t,e){"use strict";function n(t,e){var n=window.getComputedStyle?getComputedStyle(t):t.currentStyle;return n[e]}function i(){return{html:{height:s.style.height||"",overflow:n(s,"overflow"),position:n(s,"position")},body:{height:a.style.height||"",overflow:n(a,"overflow")}}}function r(){var t=/Android|iPhone|iPod|iPad/i.test(window.navigator.userAgent);return t}function o(t){var e,n,i;this.encodedClientToken=t.clientToken,this.paypalOptions=t.paypal,this.container=null,this.merchantFormManager=null,this.root=t.root,this.configurationRequests=[],this.braintreeApiClient=c.configure({clientToken:t.clientToken,integration:"dropin"}),this.paymentMethodNonceReceivedCallback=t.paymentMethodNonceReceived,this.clientToken=c.parseClientToken(t.clientToken),this.bus=new u.MessageBus(this.root),this.rpcServer=new u.RPCServer(this.bus),this.apiProxyServer=new h(this.braintreeApiClient),this.apiProxyServer.attach(this.rpcServer),e=t.inlineFramePath||this.clientToken.assetsUrl+"/dropin/"+y+"/inline-frame.html",n=t.modalFramePath||this.clientToken.assetsUrl+"/dropin/"+y+"/modal-frame.html",s=document.documentElement,a=document.body,this.frames={inline:this._createFrame(e),modal:this._createFrame(n)},this.container=l.normalizeElement(t.container,"Unable to find valid container."),i=l.normalizeElement(t.form||this._findClosest(this.container,"form")),this.merchantFormManager=new p({form:i,frames:this.frames,onSubmit:this.paymentMethodNonceReceivedCallback,apiClient:this.braintreeApiClient}).initialize(),this.clientToken.paypalEnabled&&this.clientToken.paypal&&(l.isBrowserHttps()||this.clientToken.paypal.allowHttp)&&this._configurePayPal(),this.braintreeApiClient.sendAnalyticsEvents("dropin.web.initialized")}var s,a,c=t("braintree-api"),u=t("braintree-rpc"),l=t("braintree-utilities"),h=t("./api-proxy-server"),p=t("./merchant-form-manager"),f=t("./frame-container"),d=t("../shared/paypal-service"),m=t("braintree-paypal/src/shared/util/browser"),y="1.1.9";o.prototype.initialize=function(){var t=this;this._initializeModal(),this.container.appendChild(this.frames.inline.element),a.appendChild(this.frames.modal.element),this.rpcServer.define("receiveSharedCustomerIdentifier",function(e){t.braintreeApiClient.attrs.sharedCustomerIdentifier=e,t.braintreeApiClient.attrs.sharedCustomerIdentifierType="browser_session_cookie_store";for(var n=0;n<t.configurationRequests.length;n++)t.configurationRequests[n](t.encodedClientToken);t.configurationRequests=[]}),this.rpcServer.define("getConfiguration",function(e){e({clientToken:t.encodedClientToken,merchantHttps:l.isBrowserHttps()})}),this.rpcServer.define("getPayPalOptions",function(e){e(t.paypalOptions)}),this.rpcServer.define("selectPaymentMethod",function(e){t.frames.modal.rpcClient.invoke("selectPaymentMethod",[e]),t._showModal()}),this.rpcServer.define("sendAddedPaymentMethod",function(e){t.merchantFormManager.setNoncePayload({nonce:e.nonce}),t.frames.inline.rpcClient.invoke("receiveNewPaymentMethod",[e])}),this.rpcServer.define("sendUsedPaymentMethod",function(e){t.frames.inline.rpcClient.invoke("selectPaymentMethod",[e])}),this.rpcServer.define("sendUnlockedNonce",function(e){t.merchantFormManager.setNoncePayload({nonce:e})}),this.rpcServer.define("clearNonce",function(){t.merchantFormManager.clearNoncePayload()}),this.rpcServer.define("closeDropInModal",function(){t._hideModal()}),this.rpcServer.define("setInlineFrameHeight",function(e){t.frames.inline.element.style.height=e+"px"}),this.bus.register("ready",function(e){e.source===t.frames.inline.element.contentWindow?t.frames.inline.rpcClient=new u.RPCClient(t.bus,e.source):e.source===t.frames.modal.element.contentWindow&&(t.frames.modal.rpcClient=new u.RPCClient(t.bus,e.source))})},o.prototype._createFrame=function(t){return new f(t)},o.prototype._initializeModal=function(){this.frames.modal.element.style.display="none",this.frames.modal.element.style.position=r()?"absolute":"fixed",this.frames.modal.element.style.top="0",this.frames.modal.element.style.left="0",this.frames.modal.element.style.height="100%",this.frames.modal.element.style.width="100%"},o.prototype._lockMerchantWindowSize=function(){setTimeout(function(){s.style.overflow="hidden",a.style.overflow="hidden",a.style.height="100%",r()&&(s.style.position="relative",s.style.height=window.innerHeight+"px")},160)},o.prototype._unlockMerchantWindowSize=function(){var t=this.merchantPageDefaultStyles;a.style.height=t.body.height,a.style.overflow=t.body.overflow,s.style.overflow=t.html.overflow,r()&&(s.style.height=t.html.height,s.style.position=t.html.position)},o.prototype._showModal=function(){var t=this,e=this.frames.modal.element;this.merchantPageDefaultStyles=i(),e.style.display="block",this.frames.modal.rpcClient.invoke("open",[],function(){setTimeout(function(){t._lockMerchantWindowSize(),e.contentWindow.focus()},200)})},o.prototype._hideModal=function(){this._unlockMerchantWindowSize(),this.frames.modal.element.style.display="none"},o.prototype._configurePayPal=function(){m.isPopupSupported()||(this.ppClient=new d({clientToken:this.clientToken,paypal:this.paypalOptions}),this.rpcServer.define("openPayPalModal",l.bind(this.ppClient._openModal,this.ppClient))),this.rpcServer.define("receivePayPalData",l.bind(this._handlePayPalData,this))},o.prototype._handlePayPalData=function(t){this.merchantFormManager.setNoncePayload(t),this.frames.inline.rpcClient.invoke("receiveNewPaymentMethod",[t]),this.frames.modal.rpcClient.invoke("paypalViewClose")},o.prototype._findClosest=function(t,e){e=e.toUpperCase();do if(t.nodeName===e)return t;while(t=t.parentNode);throw"Unable to find a valid "+e},e.exports=o},{"../shared/paypal-service":137,"./api-proxy-server":132,"./frame-container":135,"./merchant-form-manager":136,"braintree-api":55,"braintree-paypal/src/shared/util/browser":113,"braintree-rpc":121,"braintree-utilities":131}],134:[function(t,e){"use strict";function n(t,e){e.clientToken=t;var n=new i(e);return n.initialize(),n}var i=t("./client"),r="1.1.9";e.exports={create:n,VERSION:r}},{"./client":133}],135:[function(t,e){"use strict";function n(t){this.element=document.createElement("iframe"),this.element.setAttribute("allowtransparency","true"),this.element.setAttribute("width","100%"),this.element.setAttribute("height","68"),this.element.setAttribute("style","-webkit-transition: height 210ms cubic-bezier(0.390, 0.575, 0.565, 1.000); -moz-transition: height 210ms cubic-bezier(0.390, 0.575, 0.565, 1.000); -ms-transition: height 210ms cubic-bezier(0.390, 0.575, 0.565, 1.000); -o-transition: height 210ms cubic-bezier(0.390, 0.575, 0.565, 1.000); transition: height 210ms cubic-bezier(0.390, 0.575, 0.565, 1.000);"),this.element.src=t,this.element.setAttribute("frameborder","0"),this.element.setAttribute("allowtransparency","true"),this.element.style.border="0",this.element.style.zIndex="9999"}e.exports=n},{}],136:[function(t,e){"use strict";function n(t){this.form=t.form,this.frames=t.frames,this.onSubmit=t.onSubmit,this.apiClient=t.apiClient}var i=t("braintree-utilities");n.prototype.initialize=function(){return this._isSubmitBased()&&this._setElements(),this._setEvents(),this},n.prototype.setNoncePayload=function(t){this.noncePayload=t},n.prototype.clearNoncePayload=function(){this.noncePayload=null},n.prototype._isSubmitBased=function(){return!this.onSubmit},n.prototype._isCallbackBased=function(){return!!this.onSubmit},n.prototype._setElements=function(){if(!this.form.payment_method_nonce){var t=document.createElement("input");t.type="hidden",t.name="payment_method_nonce",this.form.appendChild(t)}this.nonceField=this.form.payment_method_nonce},n.prototype._setEvents=function(){var t=this;i.addEventListener(this.form,"submit",function(){t._handleFormSubmit.apply(t,arguments)})},n.prototype._handleFormSubmit=function(t){this._shouldSubmit()||(t&&t.preventDefault?t.preventDefault():t.returnValue=!1,this.noncePayload&&this.noncePayload.nonce?this._handleNonceReply(t):this.frames.inline.rpcClient.invoke("requestNonce",[],i.bind(function(e){this.setNoncePayload({nonce:e}),this._handleNonceReply(t)},this)))},n.prototype._shouldSubmit=function(){return this._isCallbackBased()?!1:this.nonceField.value.length>0},n.prototype._handleNonceReply=function(t){this._isCallbackBased()?this.apiClient.sendAnalyticsEvents("dropin.web.end.callback",i.bind(function(){var e=this.noncePayload;e.originalEvent=t,this.onSubmit(e),setTimeout(i.bind(function(){this.frames.inline.rpcClient.invoke("clearLoadingState")},this),200)},this)):this._triggerFormSubmission()},n.prototype._triggerFormSubmission=function(){this.nonceField.value=this.noncePayload.nonce,this.apiClient.sendAnalyticsEvents("dropin.web.end.auto-submit",i.bind(function(){"function"==typeof this.form.submit?this.form.submit():this.form.querySelector('[type="submit"]').click()},this))},e.exports=n},{"braintree-utilities":131}],137:[function(t,e){"use strict";function n(t){var e=t.clientToken,n=t.paypal||{},r=new i(e,{container:document.createElement("div"),displayName:n.displayName,locale:n.locale,singleUse:n.singleUse,onSuccess:n.onSuccess,enableShippingAddress:n.enableShippingAddress});return r.initialize(),r}var i=t("braintree-paypal/src/external/client");e.exports=n},{"braintree-paypal/src/external/client":105}],138:[function(t,e){"use strict";function n(t){if("object"==typeof t)return t;var e="payment_method_nonce";"string"==typeof t&&(e=t);var n=document.createElement("input");return n.name=e,n.type="hidden",n}function i(t){for(var e=t.getElementsByTagName("*"),n={},i=0;i<e.length;i++){var r=e[i].getAttribute("data-braintree-name");n[r]=!0}if(!n.number)throw'Unable to find an input with data-braintree-name="number" in your form. Please add one.';if(n.expiration_date){if(n.expiration_month||n.expiration_year)throw'You have inputs with data-braintree-name="expiration_date" AND data-braintree-name="expiration_(year|month)". Please use either "expiration_date" or "expiration_year" and "expiration_month".'}else{if(!n.expiration_month&&!n.expiration_year)throw'Unable to find an input with data-braintree-name="expiration_date" in your form. Please add one.';if(!n.expiration_month)throw'Unable to find an input with data-braintree-name="expiration_month" in your form. Please add one.';if(!n.expiration_year)throw'Unable to find an input with data-braintree-name="expiration_year" in your form. Please add one.'}}function r(t,e,n){this.client=t,this.htmlForm=e,this.paymentMethodNonce=n}r.setup=function(t,e){var o=document.getElementById(e.id);if(!o)throw'Unable to find form with id: "'+e.id+'"';i(o);var s=n(e.paymentMethodNonceInputField);o.appendChild(s);var a=new r(t,o,s);return a.hijackForm(),a},r.prototype.registerAsyncTaskOnSubmit=function(t,e){function n(n){n.preventDefault?n.preventDefault():n.returnValue=!1,e(function(){r(),t.submit&&("function"==typeof t.submit||t.submit.call)?t.submit():setTimeout(function(){t.querySelector('[type="submit"]').click()},1)})}function i(){t.addEventListener?t.addEventListener("submit",n):t.attachEvent&&t.attachEvent("onsubmit",n)}function r(){t.removeEventListener?t.removeEventListener("submit",n):t.detachEvent&&t.detachEvent("onsubmit",n)}i()},r.prototype.hijackForm=function(){var t=this;this.registerAsyncTaskOnSubmit(this.htmlForm,function(e){return t.paymentMethodNonce.value&&""!==t.paymentMethodNonce.value?(e(),void 0):(t.client.tokenizeCard(t.extractValues(t.htmlForm),function(n,i){if(n)throw"Unable to process payments at this time.";t.paymentMethodNonce.value=i,e()}),void 0)})},r.prototype.extractValues=function(t,e){e=e||{};var n,i,r=t.children;for(i=0;i<r.length;i++)if(n=r[i],1===n.nodeType&&n.attributes["data-braintree-name"]){var o=n.getAttribute("data-braintree-name");"postal_code"===o?e.billingAddress={postalCode:n.value}:e[o]=n.value,this.scrubAttributes(n)}else n.children&&n.children.length>0&&this.extractValues(n,e);return e},r.prototype.scrubAttributes=function(t){try{t.attributes.removeNamedItem("name")}catch(e){}},e.exports=r},{}],139:[function(t,e){e.exports=t(23)},{"./credit-card":140,"./jsonp-driver":141,"./parse-client-token":143,"./root-data":145,"./sepa-bank-account":146,"./sepa-mandate":147,"./util":148}],140:[function(t,e){e.exports=t(3)},{}],141:[function(t,e){e.exports=t(4)},{"./jsonp":142}],142:[function(t,e){e.exports=t(5)},{"./util":148}],143:[function(t,e){e.exports=t(6)},{"./polyfill":144}],144:[function(t,e){e.exports=t(7)},{}],145:[function(t,e){e.exports=t(29)},{"braintree-rpc":155}],146:[function(t,e){e.exports=t(8)},{}],147:[function(t,e){e.exports=t(9)},{}],148:[function(t,e){e.exports=t(10)},{}],149:[function(t,e,n){arguments[4][11][0].apply(n,arguments)},{"./lib/client":139,"./lib/jsonp":142,"./lib/jsonp-driver":141,"./lib/parse-client-token":143,"./lib/util":148}],150:[function(t,e){e.exports=t(34)},{"braintree-utilities":160}],151:[function(t,e){e.exports=t(35)},{"braintree-utilities":160}],152:[function(t,e){e.exports=t(36)},{}],153:[function(t,e){e.exports=t(37)},{"braintree-utilities":160}],154:[function(t,e){e.exports=t(38)},{"braintree-utilities":160}],155:[function(t,e){e.exports=t(39)},{"./lib/message-bus":150,"./lib/pubsub-client":151,"./lib/pubsub-server":152,"./lib/rpc-client":153,"./lib/rpc-server":154}],156:[function(t,e){e.exports=t(40)},{}],157:[function(t,e){e.exports=t(41)},{}],158:[function(t,e){e.exports=t(42)},{}],159:[function(t,e){e.exports=t(15)},{}],160:[function(t,e,n){arguments[4][16][0].apply(n,arguments)
},{"./lib/dom":156,"./lib/events":157,"./lib/fn":158,"./lib/url":159}],161:[function(t,e){e.exports=t(34)},{"braintree-utilities":171}],162:[function(t,e){e.exports=t(35)},{"braintree-utilities":171}],163:[function(t,e){e.exports=t(36)},{}],164:[function(t,e){e.exports=t(37)},{"braintree-utilities":171}],165:[function(t,e){e.exports=t(38)},{"braintree-utilities":171}],166:[function(t,e){e.exports=t(39)},{"./lib/message-bus":161,"./lib/pubsub-client":162,"./lib/pubsub-server":163,"./lib/rpc-client":164,"./lib/rpc-server":165}],167:[function(t,e){e.exports=t(40)},{}],168:[function(t,e){e.exports=t(41)},{}],169:[function(t,e){e.exports=t(42)},{}],170:[function(t,e){e.exports=t(15)},{}],171:[function(t,e,n){arguments[4][16][0].apply(n,arguments)},{"./lib/dom":167,"./lib/events":168,"./lib/fn":169,"./lib/url":170}],172:[function(t,e){e.exports=t(40)},{}],173:[function(t,e){e.exports=t(41)},{}],174:[function(t,e){e.exports=t(42)},{}],175:[function(t,e){e.exports=t(15)},{}],176:[function(t,e,n){arguments[4][16][0].apply(n,arguments)},{"./lib/dom":172,"./lib/events":173,"./lib/fn":174,"./lib/url":175}],177:[function(t,e){e.exports=t(105)},{"../shared/constants":181,"../shared/util/browser":186,"../shared/util/dom":187,"../shared/util/util":188,"./logged-in-view":179,"./logged-out-view":180,"braintree-api":149,"braintree-rpc":166,"braintree-utilities":176}],178:[function(t,e){function n(t,e){if(!r.detectedPostMessage())return"function"==typeof e.onUnsupported&&e.onUnsupported(new Error("unsupported browser detected")),void 0;var n=new i(t,e);return n.initialize(),n}var i=t("./client"),r=t("../shared/util/browser"),o="1.2.1";e.exports={create:n,_browser:r,VERSION:o}},{"../shared/util/browser":186,"./client":177}],179:[function(t,e){e.exports=t(106)},{"../shared/constants":181}],180:[function(t,e){e.exports=t(107)},{"../shared/constants":181}],181:[function(t,e){e.exports=t(108)},{}],182:[function(t,e){e.exports=t(109)},{"./useragent":185}],183:[function(t,e){e.exports=t(110)},{"./platform":184,"./useragent":185}],184:[function(t,e){e.exports=t(111)},{"./useragent":185}],185:[function(t,e){e.exports=t(112)},{}],186:[function(t,e){e.exports=t(113)},{"../useragent/browser":182,"../useragent/device":183,"../useragent/platform":184,"../useragent/useragent":185}],187:[function(t,e){e.exports=t(114)},{}],188:[function(t,e){e.exports=t(115)},{}],189:[function(t,e){e.exports=t(34)},{"braintree-utilities":199}],190:[function(t,e){e.exports=t(35)},{"braintree-utilities":199}],191:[function(t,e){e.exports=t(36)},{}],192:[function(t,e){e.exports=t(37)},{"braintree-utilities":199}],193:[function(t,e){e.exports=t(38)},{"braintree-utilities":199}],194:[function(t,e){e.exports=t(39)},{"./lib/message-bus":189,"./lib/pubsub-client":190,"./lib/pubsub-server":191,"./lib/rpc-client":192,"./lib/rpc-server":193}],195:[function(t,e){e.exports=t(40)},{}],196:[function(t,e){e.exports=t(41)},{}],197:[function(t,e){e.exports=t(42)},{}],198:[function(t,e){e.exports=t(15)},{}],199:[function(t,e,n){arguments[4][16][0].apply(n,arguments)},{"./lib/dom":195,"./lib/events":196,"./lib/fn":197,"./lib/url":198}],200:[function(t,e){e.exports=t(12)},{}],201:[function(t,e){e.exports=t(13)},{}],202:[function(t,e){e.exports=t(14)},{}],203:[function(t,e){e.exports=t(15)},{}],204:[function(t,e){e.exports=t(16)},{"./lib/dom":200,"./lib/events":201,"./lib/fn":202,"./lib/url":203}],205:[function(t,e){function n(){this._events=this._events||{},this._maxListeners=this._maxListeners||void 0}function i(t){return"function"==typeof t}function r(t){return"number"==typeof t}function o(t){return"object"==typeof t&&null!==t}function s(t){return void 0===t}e.exports=n,n.EventEmitter=n,n.prototype._events=void 0,n.prototype._maxListeners=void 0,n.defaultMaxListeners=10,n.prototype.setMaxListeners=function(t){if(!r(t)||0>t||isNaN(t))throw TypeError("n must be a positive number");return this._maxListeners=t,this},n.prototype.emit=function(t){var e,n,r,a,c,u;if(this._events||(this._events={}),"error"===t&&(!this._events.error||o(this._events.error)&&!this._events.error.length)){if(e=arguments[1],e instanceof Error)throw e;throw TypeError('Uncaught, unspecified "error" event.')}if(n=this._events[t],s(n))return!1;if(i(n))switch(arguments.length){case 1:n.call(this);break;case 2:n.call(this,arguments[1]);break;case 3:n.call(this,arguments[1],arguments[2]);break;default:for(r=arguments.length,a=new Array(r-1),c=1;r>c;c++)a[c-1]=arguments[c];n.apply(this,a)}else if(o(n)){for(r=arguments.length,a=new Array(r-1),c=1;r>c;c++)a[c-1]=arguments[c];for(u=n.slice(),r=u.length,c=0;r>c;c++)u[c].apply(this,a)}return!0},n.prototype.addListener=function(t,e){var r;if(!i(e))throw TypeError("listener must be a function");if(this._events||(this._events={}),this._events.newListener&&this.emit("newListener",t,i(e.listener)?e.listener:e),this._events[t]?o(this._events[t])?this._events[t].push(e):this._events[t]=[this._events[t],e]:this._events[t]=e,o(this._events[t])&&!this._events[t].warned){var r;r=s(this._maxListeners)?n.defaultMaxListeners:this._maxListeners,r&&r>0&&this._events[t].length>r&&(this._events[t].warned=!0,console.error("(node) warning: possible EventEmitter memory leak detected. %d listeners added. Use emitter.setMaxListeners() to increase limit.",this._events[t].length),"function"==typeof console.trace&&console.trace())}return this},n.prototype.on=n.prototype.addListener,n.prototype.once=function(t,e){function n(){this.removeListener(t,n),r||(r=!0,e.apply(this,arguments))}if(!i(e))throw TypeError("listener must be a function");var r=!1;return n.listener=e,this.on(t,n),this},n.prototype.removeListener=function(t,e){var n,r,s,a;if(!i(e))throw TypeError("listener must be a function");if(!this._events||!this._events[t])return this;if(n=this._events[t],s=n.length,r=-1,n===e||i(n.listener)&&n.listener===e)delete this._events[t],this._events.removeListener&&this.emit("removeListener",t,e);else if(o(n)){for(a=s;a-->0;)if(n[a]===e||n[a].listener&&n[a].listener===e){r=a;break}if(0>r)return this;1===n.length?(n.length=0,delete this._events[t]):n.splice(r,1),this._events.removeListener&&this.emit("removeListener",t,e)}return this},n.prototype.removeAllListeners=function(t){var e,n;if(!this._events)return this;if(!this._events.removeListener)return 0===arguments.length?this._events={}:this._events[t]&&delete this._events[t],this;if(0===arguments.length){for(e in this._events)"removeListener"!==e&&this.removeAllListeners(e);return this.removeAllListeners("removeListener"),this._events={},this}if(n=this._events[t],i(n))this.removeListener(t,n);else for(;n.length;)this.removeListener(t,n[n.length-1]);return delete this._events[t],this},n.prototype.listeners=function(t){var e;return e=this._events&&this._events[t]?i(this._events[t])?[this._events[t]]:this._events[t].slice():[]},n.listenerCount=function(t,e){var n;return n=t._events&&t._events[e]?i(t._events[e])?1:t._events[e].length:0}},{}],206:[function(t,e){"use strict";e.exports={NONCE_RECEIVED:"NONCE_RECEIVED",ROOT_CALLBACK:"onPaymentMethodReceived"}},{}],207:[function(t,e){"use strict";var n=t("events").EventEmitter;e.exports=new n},{events:205}],208:[function(t,e){"use strict";function n(t){return"paypal"in t&&a.isFunction(t.paypal.onSuccess)?t.paypal.onSuccess:null}function i(t,e){var i,a=n(e),c=new r.Client({clientToken:t,integration:"custom"});return i=o.setup(c,e),e.paypal&&(e.paypal.paymentMethodNonceInputField||(e.paypal.paymentMethodNonceInputField=i.paymentMethodNonce),a&&(e.paypal.onSuccess=function(t){a.apply(null,[t.nonce,t.email,t.shippingAddress])}),s.create(t,e.paypal)),i}var r=t("braintree-api"),o=t("braintree-form"),s=t("braintree-paypal"),a=t("braintree-utilities");e.exports={initialize:i}},{"braintree-api":33,"braintree-form":138,"braintree-paypal":178,"braintree-utilities":204}],209:[function(t,e){"use strict";function n(t){return s.isFunction(t.paymentMethodNonceReceived)?t.paymentMethodNonceReceived:null}function i(t){return s.isFunction(t[c.ROOT_CALLBACK])}function r(t,e){var r=n(e),s=i(e);return(r||s)&&(e.paymentMethodNonceReceived=function(t){r&&r.apply(null,[t.originalEvent,t.nonce]),a.emit(c.NONCE_RECEIVED,null,t)}),o.create(t,e)}var o=t("braintree-dropin"),s=t("braintree-utilities"),a=t("../event-bus"),c=t("../constants");e.exports={initialize:r}},{"../constants":206,"../event-bus":207,"braintree-dropin":134,"braintree-utilities":204}],210:[function(t,e){"use strict";e.exports={custom:t("./custom"),dropin:t("./dropin"),paypal:t("./paypal")}},{"./custom":208,"./dropin":209,"./paypal":211}],211:[function(t,e){"use strict";function n(t){return"onSuccess"in t&&s.isFunction(t.onSuccess)?t.onSuccess:"paypal"in t&&s.isFunction(t.paypal.onSuccess)?t.paypal.onSuccess:null}function i(t){return s.isFunction(t[c.ROOT_CALLBACK])}function r(t,e){var r=n(e),s=i(e);return(r||s)&&(e.onSuccess=function(t){r&&r.apply(null,[t.nonce,t.email,t.shippingAddress]),a.emit(c.NONCE_RECEIVED,null,t)}),o.create(t,e)}var o=t("braintree-paypal"),s=t("braintree-utilities"),a=t("../event-bus"),c=t("../constants");e.exports={initialize:r}},{"../constants":206,"../event-bus":207,"braintree-paypal":178,"braintree-utilities":204}],212:[function(t,e){(function(n){"use strict";var i="2.3.3",r=t("braintree-rpc"),o=new r.MessageBus(n),s=new r.RPCServer(o);e.exports=function(){s.define("getExternalData",function(t){t({sdkVersion:i,merchantAppId:n.location.href})})}}).call(this,"undefined"!=typeof self?self:"undefined"!=typeof window?window:{})},{"braintree-rpc":194}],213:[function(t,e){"use strict";function n(t,e,n){if(e in l)return u.isFunction(n[p.ROOT_CALLBACK])&&h.on(p.NONCE_RECEIVED,function(){n[p.ROOT_CALLBACK].apply(null,arguments)}),l[e].initialize(t,n);throw new Error(e+" is an unsupported integration")}var i="2.3.3",r=t("braintree-api"),o=t("braintree-paypal"),s=t("braintree-dropin"),a=t("braintree-form"),c=t("braintree-3d-secure"),u=t("braintree-utilities"),l=t("./integrations"),h=t("./event-bus"),p=t("./constants");e.exports={api:r,cse:Braintree,paypal:o,dropin:s,Form:a,tds:c,setup:n,VERSION:i}},{"./constants":206,"./event-bus":207,"./integrations":210,"braintree-3d-secure":19,"braintree-api":33,"braintree-dropin":134,"braintree-form":138,"braintree-paypal":178,"braintree-utilities":204}]},{},[1])(1)});

/*!
 * QU enhancent
 */
Window.braintree = braintree;