<?php
/**
 *   @copyright Copyright (c) 2015 Quality Unit s.r.o.
 *   @author Martin Pullmann
 *   @package PostAffiliatePro
 *   @since Version 1.0.0
 *
 *   Licensed under the Quality Unit, s.r.o. Standard End User License Agreement,
 *   Version 1.0 (the "License"); you may not use this file except in compliance
 *   with the License. You may obtain a copy of the License at
 *   http://www.qualityunit.com/licenses/license
 *
 */

/**
 * @package PostAffiliatePro plugins
 */
class Stripe_Main extends Gpf_Plugins_Handler {

    /**
     * @return Stripe_Main
     */
    public static function getHandlerInstance() {
        return new Stripe_Main();
    }

    public function initSettings($context) {
        $context->addDbSetting(Stripe_Config::CUSTOM_SEPARATOR, '', true);
        $context->addDbSetting(Stripe_Config::API_KEY, '', true);
        $context->addDbSetting(Stripe_Config::TEST_API_KEY, '', true);
        $context->addDbSetting(Stripe_Config::ENVIRONMENT, Stripe_Config::ENVIRONMENT_LIVE, true);
        $context->addDbSetting(Stripe_Config::TRACK_CHARGE_EVENT, Gpf::NO, true);
        $context->addDbSetting(Stripe_Config::TRACK_SESSION_EVENT, Gpf::NO, true);
        $context->addDbSetting(Stripe_Config::CREATE_AFFILIATE, Gpf::NO, true);
        $context->addDbSetting(Stripe_Config::DATA1, 'email', true);
        $context->addDbSetting(Stripe_Config::DATA3, '', true);
        $context->addDbSetting(Stripe_Config::DATA4, '', true);
        $context->addDbSetting(Stripe_Config::DATA5, '', true);
        $context->addDbSetting(Stripe_Config::SUBSCRIPTION_INDEX, 'subscription', true);
        $context->addDbSetting(Stripe_Config::PRODUCT_ID, 'product', true);
    }
}
