<?php
/**
 *   @copyright Copyright (c) 2007 Quality Unit s.r.o.
 *   @author Martin Pullmann
 *   @package PostAffiliatePro
 *   @since Version 1.0.0
 *
 *   Licensed under the Quality Unit, s.r.o. Standard End User License Agreement,
 *   Version 1.0 (the "License"); you may not use this file except in compliance
 *   with the License. You may obtain a copy of the License at
 *   http://www.postaffiliatepro.com/licenses/license
 *
 */

/**
 * @package PostAffiliatePro plugins
 */
class Recurly_Config extends Gpf_Plugins_Config {
    const RESEND_URL = 'RecurlyResendURL';

    protected function initFields() {
        $this->addTextBox($this->_('Resend push notifications'), self::RESEND_URL, $this->_("Enter the full URL where do you want to resend received data from Recurly. This is used in case you are using third party application that uses push notifications too. E.g. membership handler."));
    }

    /**
     * @service plugin_config write
     * @param Gpf_Rpc_Params $params
     * @return Gpf_Rpc_Form
     */
    public function save(Gpf_Rpc_Params $params) {
        $form = new Gpf_Rpc_Form($params);
        $resendUrl = $form->getFieldValue(self::RESEND_URL);
        if ($resendUrl != '') {
            if (!Gpf_Common_UrlUtils::isUrl($resendUrl)) {
                $errorMessage = $this->_('Url is not valid, use url with protocol.');
                $form->setFieldError(self::RESEND_URL, $errorMessage);
                $form->setErrorMessage($errorMessage);
                return $form;
            }
            $pluginURL = Gpf_Paths::getInstance()->getFullBaseServerUrlWithoutProtocol() . Gpf_Paths::PLUGINS_DIR . 'Recurly/recurly.php';
            if (strstr($resendUrl, $pluginURL)) {
                $errorMessage = $this->_('You cannot resend request to same account url.');
                $form->setFieldError(self::RESEND_URL, $errorMessage);
                $form->setErrorMessage($errorMessage);
                return $form;
            }
        }
        Gpf_Settings::set(self::RESEND_URL, $form->getFieldValue(self::RESEND_URL));
        $form->setInfoMessage($this->_('Recurly plugin settings saved'));
        return $form;
    }

    /**
     * @service plugin_config read
     * @param Gpf_Rpc_Params $params
     * @return Gpf_Rpc_Form
     */
    public function load(Gpf_Rpc_Params $params) {
        $form = new Gpf_Rpc_Form($params);
        $form->addField(self::RESEND_URL, Gpf_Settings::get(self::RESEND_URL));
        return $form;
    }
}

?>
