<?php
/**
 *   @copyright Copyright (c) 2007 Quality Unit s.r.o.
 *   @author Michal Bebjak
 *   @package GwtPhpFramework
 *   @since Version 1.0.0
 *
 *   Licensed under the Quality Unit, s.r.o. Standard End User License Agreement,
 *   Version 1.0 (the "License"); you may not use this file except in compliance
 *   with the License. You may obtain a copy of the License at
 *   http://www.postaffiliatepro.com/licenses/license
 *
 */

/**
 * @package GwtPhpFramework
 */
class PayPal_Config extends Gpf_Plugins_Config {
    const CUSTOM_SEPARATOR = 'PaypalCustomSeparator';
    const DISCOUNT_TAX = 'PaypalDiscountTax';
    const DISCOUNT_FEE = 'PaypalDiscountFee';
    const DISCOUNT_SHIPPING = 'PaypalDiscountShipping';
    const DISCOUNT_HANDLING = 'PaypalDiscountHandling';
    const REGISTER_AFFILIATE = 'PaypalRegisterAffiliate';
    const REGISTER_AFFILIATE_PRODUCTS = 'PaypalRegisterAffiliateProducts';
    const USE_RECURRING_COMMISSION_SETTINGS = 'PaypalUseRecurringCommissionSettings';
    const NORMAL_COMMISSION_AS_RECURRING_COMMISSION = 'PaypalNormalCommissionAsRecurringCommission';
    const RECURRING_TOTALCOST_FROM_NOTIFICATION = 'PaypalRecurringTotalCostFromNotification';
    const TEST_MODE = 'PayPalTestMode';
    const APPROVE_AFFILIATE = 'PayPalApproveAffiliate';
    const DECLINE_AFFILIATE = 'PayPalDeclineAffiliate';
    const PROCESS_WHOLE_CART_AS_ONE_TRANSACTION = 'PayPalProcessWholeCartAsOneTransaction';
    const USE_COUPON = 'PayPalUseCoupon';
    const PAYPAL_REFUND = 'PayPalRefundManagement';
    const RESEND_IPN_URL = 'PayPalResendIpnUrl';
    const DATA1 = 'PayPalData1';
    const DATA2 = 'PayPalData2';
    const DATA3 = 'PayPalData3';
    const DATA4 = 'PayPalData4';
    const DATA5 = 'PayPalData5';

    protected function initFields() {
        $extraData2Options = array (
                'txn_id' => 'Payment ID (txn_id)',
        );
        $extraDataOptions = array (
                '0' => '',
                'payer_email' => 'Customer\'s email',
                'payer_id' => 'Customer\'s ID',
                'contact_phone' => 'Customer\'s phone number',
                'name' => 'Customer\'s name',
                'payer_business_name' => 'Customer\'s company name',
                'address_street' => 'Customer\'s street',
                'address_city' => 'Customer\'s city',
                'address_state' => 'Customer\'s state',
                'address_country' => 'Customer\'s country',
                'address_zip' => 'Customer\'s ZIP code',
                'item_name' => 'Item name',
                'transaction_subject' => 'Transaction subject'
        );

        $this->addTextBox($this->_("Custom value separator"), self::CUSTOM_SEPARATOR, $this->_("Custom value separator should be set only when custom value is used by other script. See Paypal (IPN and custom used by other script) integration method."));
        $this->addCheckBox($this->_("Use value before separator as a coupon"), self::USE_COUPON, $this->_('When this option is checked PAP expects that value in custom field before separator is a coupon code. In paypal button code put the coupon code into "custom" field and then use code to set correct separator PostAffTracker.setAppendValuesToField(\'YOUR_SEPARATOR\');'));
        $this->addCheckBox($this->_("Discount tax"), self::DISCOUNT_TAX, $this->_('Discounts tax from total cost value.'));
        $this->addCheckBox($this->_("Discount fee"), self::DISCOUNT_FEE, $this->_('Discounts fee from total cost value.'));
        $this->addCheckBox($this->_("Discount shipping"), self::DISCOUNT_SHIPPING, $this->_('Discounts shippings from total cost value.'));
        $this->addCheckBox($this->_("Discount handling"), self::DISCOUNT_HANDLING, $this->_('Discounts handling from total cost value.'));
        $this->addCheckBox($this->_("Register new affiliate with every occured event"), self::REGISTER_AFFILIATE, $this->_('When this checked, with every event new affiliate will be created from credentials that were set in PayPal submit form.'), array(self::REGISTER_AFFILIATE_PRODUCTS), array(Gpf::YES));
        $this->addTextBox($this->_("Register affiliate on purchase of these products"), self::REGISTER_AFFILIATE_PRODUCTS, $this->_('Leave empty if affiliate should be created on all purchases done through PayPal!') . '<br />' .
                $this->_('If you should want to register affiliate only when specific product(s) are purchased specify the products here.') . ' ' .
                $this->_('Separate multiple products by a semicolon e.g. product1;perfect product;product3.') . ' ' .
                $this->_('The plugin saves item_number as product name and if that is empty it takes the item_name.'));
        $this->addCheckBox($this->_("Approve affiliate after successful payment"), self::APPROVE_AFFILIATE, $this->_('When this is checked, every pending affiliate will be approved after successful payment.'));
        $this->addCheckBox($this->_("Decline affiliate on cancelled payment"), self::DECLINE_AFFILIATE, $this->_('In case the customer is also an affiliate paying for their membership with PayPal, they will be declined if the membership is cancelled.'));
        $this->addCheckBox($this->_("Save only matched recurring commission"), self::USE_RECURRING_COMMISSION_SETTINGS, $this->_('This setting causes, that every recurring payment will be saved only if orderid (subscription id) will be matched with orderid in recurring commissions. If orderid will not be matched, than initialize recurring commission will not be created.'));
        $this->addCheckBox($this->_("Use general sale as recurring commission"), self::NORMAL_COMMISSION_AS_RECURRING_COMMISSION, $this->_('When this is checked, general sale will be saved as recurring commission.'));
        $this->addCheckBox($this->_("Use recurring total cost from notification"), self::RECURRING_TOTALCOST_FROM_NOTIFICATION, $this->_('When this is checked, for recurring commission is used total cost from paypal ipn notification instead of total cost from initial payment.'));
        $this->addCheckBox($this->_("Process whole cart as one transaction"), self::PROCESS_WHOLE_CART_AS_ONE_TRANSACTION, $this->_('Process all items in cart as one big transaction.'));
        $this->addCheckBox($this->_("Process PayPal refunds"), self::PAYPAL_REFUND, $this->_('If this option is enabled,then refunds applied in PayPal will be reflected in Post Affiliate Pro as well.'));
        $this->addListBox($this->_('Extra data 1'), self::DATA1, $extraDataOptions, $this->_('Choose a value for sale extra data 1.'));
        $this->addListBox($this->_('Extra data 2'), self::DATA2, $extraData2Options, $this->_('Choose a value for sale extra data 2.'));
        $this->addListBox($this->_('Extra data 3'), self::DATA3, $extraDataOptions, $this->_('Choose a value for sale extra data 3.'));
        $this->addListBox($this->_('Extra data 4'), self::DATA4, $extraDataOptions, $this->_('Choose a value for sale extra data 4.'));
        $this->addListBox($this->_('Extra data 5'), self::DATA5, $extraDataOptions, $this->_('Choose a value for sale extra data 5.'));
        $this->addTextBox($this->_('Resend IPN to URL'), self::RESEND_IPN_URL, $this->_('If you already use PayPal\'s IPN for external system in which you cannot resend IPN to PAP, you can instead send the IPN to PAP and resend it to the URL defined in this field, so you can effectively notify 2 systems.'));
        $this->addCheckBox($this->_("Test mode"), self::TEST_MODE, $this->_('Skip back verification.'));
    }

    /**
     * @service plugin_config write
     * @param Gpf_Rpc_Params $params
     * @return Gpf_Rpc_Form
     */
    public function save(Gpf_Rpc_Params $params) {
        $form = new Gpf_Rpc_Form($params);
        $form->setInfoMessage($this->_('Paypal settings saved'));
        $resendIpnUrl = $form->getFieldValue(self::RESEND_IPN_URL);
        if ($resendIpnUrl != '') {
            if (!Gpf_Common_UrlUtils::isUrl($resendIpnUrl)) {
                $errorMessage = $this->_('Url is not valid, use url with protocol.');
                $form->setFieldError(self::RESEND_IPN_URL, $errorMessage);
                $form->setErrorMessage($errorMessage);
                return $form;
            }
            $pluginURL = Gpf_Paths::getInstance()->getFullBaseServerUrlWithoutProtocol() . Gpf_Paths::PLUGINS_DIR . 'PayPal/paypal.php';
            if (strstr($resendIpnUrl, $pluginURL)) {
                $errorMessage = $this->_('You cannot resend IPN request to same account url.');
                $form->setFieldError(self::RESEND_IPN_URL, $errorMessage);
                $form->setErrorMessage($errorMessage);
                return $form;
            }
        }

        if (Gpf_Plugins_Engine::getInstance()->getConfiguration()->isPluginActive('LifetimeCommissions')) {
            $lifetimeDataFieldNumber = Gpf_Settings::get(LifetimeCommissions_Config::EXTRA_DATA_FIELD);
            $lifetimeDataField = constant("PayPal_Config::DATA{$lifetimeDataFieldNumber}");
            $lifetimeFieldVariable = $form->getFieldValue($lifetimeDataField);
            if ($lifetimeFieldVariable == '0') {
                $form->setInfoMessage($this->_('Support for lifetime commissions is disabled.'));
            }
            $extraDataLifetimeOptions = array (
                    '0', 'payer_email', 'payer_id', 'contact_phone'
            );
            if (!in_array($lifetimeFieldVariable, $extraDataLifetimeOptions)) {
                $errorMessage = $this->_('For lifetime commissions support choose from: %s', "'Customer's email', 'Customer's ID', or 'Customer's phone number'");
                $form->setFieldError($lifetimeDataField, $errorMessage);
                $form->setErrorMessage($this->_('Extra data %s', $lifetimeDataFieldNumber).': ' . $errorMessage);
            }
        }

        Gpf_Settings::set(self::CUSTOM_SEPARATOR, $form->getFieldValue(self::CUSTOM_SEPARATOR));
        Gpf_Settings::set(self::USE_COUPON, $form->getFieldValue(self::USE_COUPON));
        Gpf_Settings::set(self::DISCOUNT_TAX, $form->getFieldValue(self::DISCOUNT_TAX));
        Gpf_Settings::set(self::DISCOUNT_FEE, $form->getFieldValue(self::DISCOUNT_FEE));
        Gpf_Settings::set(self::DISCOUNT_SHIPPING, $form->getFieldValue(self::DISCOUNT_SHIPPING));
        Gpf_Settings::set(self::DISCOUNT_HANDLING, $form->getFieldValue(self::DISCOUNT_HANDLING));
        Gpf_Settings::set(self::REGISTER_AFFILIATE, $form->getFieldValue(self::REGISTER_AFFILIATE));
        Gpf_Settings::set(self::REGISTER_AFFILIATE_PRODUCTS, $form->getFieldValue(self::REGISTER_AFFILIATE_PRODUCTS));
        Gpf_Settings::set(self::USE_RECURRING_COMMISSION_SETTINGS, $form->getFieldValue(self::USE_RECURRING_COMMISSION_SETTINGS));
        Gpf_Settings::set(self::NORMAL_COMMISSION_AS_RECURRING_COMMISSION, $form->getFieldValue(self::NORMAL_COMMISSION_AS_RECURRING_COMMISSION));
        Gpf_Settings::set(self::RECURRING_TOTALCOST_FROM_NOTIFICATION, $form->getFieldValue(self::RECURRING_TOTALCOST_FROM_NOTIFICATION));
        Gpf_Settings::set(self::TEST_MODE, $form->getFieldValue(self::TEST_MODE));
        Gpf_Settings::set(self::PAYPAL_REFUND, $form->getFieldValue(self::PAYPAL_REFUND));
        Gpf_Settings::set(self::APPROVE_AFFILIATE, $form->getFieldValue(self::APPROVE_AFFILIATE));
        Gpf_Settings::set(self::DECLINE_AFFILIATE, $form->getFieldValue(self::DECLINE_AFFILIATE));
        Gpf_Settings::set(self::PROCESS_WHOLE_CART_AS_ONE_TRANSACTION, $form->getFieldValue(self::PROCESS_WHOLE_CART_AS_ONE_TRANSACTION));
        Gpf_Settings::set(self::RESEND_IPN_URL, $form->getFieldValue(self::RESEND_IPN_URL));
        Gpf_Settings::set(self::DATA1, $form->getFieldValue(self::DATA1));
        Gpf_Settings::set(self::DATA2, $form->getFieldValue(self::DATA2));
        Gpf_Settings::set(self::DATA3, $form->getFieldValue(self::DATA3));
        Gpf_Settings::set(self::DATA4, $form->getFieldValue(self::DATA4));
        Gpf_Settings::set(self::DATA5, $form->getFieldValue(self::DATA5));
        if (Gpf_Settings::get(self::CUSTOM_SEPARATOR) == '' && Gpf_Settings::get(self::USE_COUPON) == Gpf::YES) {
           $form->setErrorMessage($this->_('You need insert Custom value separator for tracking by coupons'));
        }
        return $form;
    }

    /**
     * @service plugin_config read
     * @param Gpf_Rpc_Params $params
     * @return Gpf_Rpc_Form
     */
    public function load(Gpf_Rpc_Params $params) {
        $form = new Gpf_Rpc_Form($params);
        $form->addField(self::CUSTOM_SEPARATOR, Gpf_Settings::get(self::CUSTOM_SEPARATOR));
        $form->addField(self::USE_COUPON, Gpf_Settings::get(self::USE_COUPON));
        $form->addField(self::DISCOUNT_TAX, Gpf_Settings::get(self::DISCOUNT_TAX));
        $form->addField(self::DISCOUNT_FEE, Gpf_Settings::get(self::DISCOUNT_FEE));
        $form->addField(self::DISCOUNT_SHIPPING, Gpf_Settings::get(self::DISCOUNT_SHIPPING));
        $form->addField(self::DISCOUNT_HANDLING, Gpf_Settings::get(self::DISCOUNT_HANDLING));
        $form->addField(self::REGISTER_AFFILIATE, Gpf_Settings::get(self::REGISTER_AFFILIATE));
        $form->addField(self::REGISTER_AFFILIATE_PRODUCTS, Gpf_Settings::get(self::REGISTER_AFFILIATE_PRODUCTS));
        $form->addField(self::USE_RECURRING_COMMISSION_SETTINGS, Gpf_Settings::get(self::USE_RECURRING_COMMISSION_SETTINGS));
        $form->addField(self::NORMAL_COMMISSION_AS_RECURRING_COMMISSION, Gpf_Settings::get(self::NORMAL_COMMISSION_AS_RECURRING_COMMISSION));
        $form->addField(self::RECURRING_TOTALCOST_FROM_NOTIFICATION, Gpf_Settings::get(self::RECURRING_TOTALCOST_FROM_NOTIFICATION));
        $form->addField(self::TEST_MODE, Gpf_Settings::get(self::TEST_MODE));
        $form->addField(self::PAYPAL_REFUND, Gpf_Settings::get(self::PAYPAL_REFUND));
        $form->addField(self::PROCESS_WHOLE_CART_AS_ONE_TRANSACTION, Gpf_Settings::get(self::PROCESS_WHOLE_CART_AS_ONE_TRANSACTION));
        $form->addField(self::APPROVE_AFFILIATE, Gpf_Settings::get(self::APPROVE_AFFILIATE));
        $form->addField(self::DECLINE_AFFILIATE, Gpf_Settings::get(self::DECLINE_AFFILIATE));
        $form->addField(self::RESEND_IPN_URL, Gpf_Settings::get(self::RESEND_IPN_URL));
        $form->addField(self::DATA1, Gpf_Settings::get(self::DATA1));
        $form->addField(self::DATA2, Gpf_Settings::get(self::DATA2));
        $form->addField(self::DATA3, Gpf_Settings::get(self::DATA3));
        $form->addField(self::DATA4, Gpf_Settings::get(self::DATA4));
        $form->addField(self::DATA5, Gpf_Settings::get(self::DATA5));
        return $form;
    }
}

?>
