<?php
/**
 *   @copyright Copyright (c) 2017 Quality Unit s.r.o.
 *   @author Martin Pullmann
 *   @package GwtPhpFramework
 *   @since Version 1.0.0
 *
 *   Licensed under the Quality Unit, s.r.o. Standard End User License Agreement,
 *   Version 1.0 (the "License"); you may not use this file except in compliance
 *   with the License. You may obtain a copy of the License at
 *   http://www.postaffiliatepro.com/licenses/license
 *
 */

/**
 * @package PostAffiliatePro plugins
 */
class Chargebee_Config extends Gpf_Plugins_Config {
    const RECURRING_TOTALCOST_FROM_NOTIFICATION = 'ChargebeeRecurringTotalCostFromNotification';
    const TRACK_REFUND = 'ChargebeeRefundManagement';
    const SUBTRACT_TAXES = 'ChargebeeSubtractTaxes';
    const REGISTER_AFFILIATE = 'ChargebeeRegisterAffiliate';
    const APPROVE_AFFILIATE = 'ChargebeeApproveAffiliate';
    const DECLINE_AFFILIATE = 'ChargebeeDeclineAffiliate';

    protected function initFields() {
        $this->addCheckBox($this->_('Use recurring total cost'), self::RECURRING_TOTALCOST_FROM_NOTIFICATION, $this->_('When this is checked, the total cost is loaded from IPN notification for recurring commissions instead of total cost from initial payment.'));
        $this->addCheckBox($this->_('Process refunds'), self::TRACK_REFUND, $this->_('Refund will be tracked in order to decline/refund commission'));
        $this->addCheckBox($this->_('Subtract taxes'), self::SUBTRACT_TAXES, $this->_('Subtract taxes from the totalcost and pay commission from the result value'));
        $this->addCheckBox($this->_('Register affiliate'), self::REGISTER_AFFILIATE, $this->_('When this checked, a new affiliate will be created for every paying customer.'));
        $this->addCheckBox($this->_('Approve affiliate'), self::APPROVE_AFFILIATE, $this->_('When this is checked, every pending affiliate will be approved after successful payment (matched by email address).'));
        $this->addCheckBox($this->_('Decline affiliate'), self::DECLINE_AFFILIATE, $this->_('In case the customer is also an affiliate paying for their membership with Chargebee, they will be declined if the membership is cancelled.'));
    }

    /**
     * @service plugin_config write
     * @param Gpf_Rpc_Params $params
     * @return Gpf_Rpc_Form
     */
    public function save(Gpf_Rpc_Params $params) {
        $form = new Gpf_Rpc_Form($params);
        Gpf_Settings::set(self::REGISTER_AFFILIATE, $form->getFieldValue(self::REGISTER_AFFILIATE));
        Gpf_Settings::set(self::RECURRING_TOTALCOST_FROM_NOTIFICATION, $form->getFieldValue(self::RECURRING_TOTALCOST_FROM_NOTIFICATION));
        Gpf_Settings::set(self::TRACK_REFUND, $form->getFieldValue(self::TRACK_REFUND));
        Gpf_Settings::set(self::SUBTRACT_TAXES, $form->getFieldValue(self::SUBTRACT_TAXES));
        Gpf_Settings::set(self::APPROVE_AFFILIATE, $form->getFieldValue(self::APPROVE_AFFILIATE));
        Gpf_Settings::set(self::DECLINE_AFFILIATE, $form->getFieldValue(self::DECLINE_AFFILIATE));
        $form->setInfoMessage($this->_('Chargebee settings saved'));
        return $form;
    }

    /**
     * @service plugin_config read
     * @param Gpf_Rpc_Params $params
     * @return Gpf_Rpc_Form
     */
    public function load(Gpf_Rpc_Params $params) {
        $form = new Gpf_Rpc_Form($params);
        $form->addField(self::REGISTER_AFFILIATE, Gpf_Settings::get(self::REGISTER_AFFILIATE));
        $form->addField(self::APPROVE_AFFILIATE, Gpf_Settings::get(self::APPROVE_AFFILIATE));
        $form->addField(self::DECLINE_AFFILIATE, Gpf_Settings::get(self::DECLINE_AFFILIATE));
        $form->addField(self::RECURRING_TOTALCOST_FROM_NOTIFICATION, Gpf_Settings::get(self::RECURRING_TOTALCOST_FROM_NOTIFICATION));
        $form->addField(self::TRACK_REFUND, Gpf_Settings::get(self::TRACK_REFUND));
        $form->addField(self::SUBTRACT_TAXES, Gpf_Settings::get(self::SUBTRACT_TAXES));
        return $form;
    }
}
