<?php
/**
 *   @copyright Copyright (c) 2018 Quality Unit s.r.o.
 *   @author Martin Pullmann
 *   @package PostAffiliatePro
 *   @since Version 1.0.0
 *
 *   Licensed under the Quality Unit, s.r.o. Standard End User License Agreement,
 *   Version 1.0 (the "License"); you may not use this file except in compliance
 *   with the License. You may obtain a copy of the License at
 *   http://www.postaffiliatepro.com/licenses/license
 *
 */
class BigCommerceAPIv3_Definition extends Gpf_Plugins_Definition {

    public function __construct() {
        $this->codeName = 'BigCommerceAPIv3';
        $this->name = $this->_('BigCommerce API v3');
        $this->description = $this->_('This plugin integrates Post Affiliate Pro with BigCommerce API v3');
        $this->version = '1.1.7';
        $this->configurationClassName = 'BigCommerceAPIv3_Config';
        $this->isMultipleConfig = true;

        $this->addRequirement('PapCore', '5.4.6.0');

        $this->addImplementation('Core.defineSettings', 'BigCommerceAPIv3_Main', 'initSettings');
    }
}
