<?php
require_once 'aweber_api/aweber.php';

require_once '../../scripts/bootstrap.php';

if (!Gpf_Plugins_Engine::getInstance()->getConfiguration()->isPluginActive('AWeberAPI')) {
    die('AWeberAPI integration plugin is not active!');
}

createMerchantSession();

function createMerchantSession() {
    $modul = new Pap_Merchant();
    $authuser = null;
    $papsid = null;
    if (isset($_COOKIE[$modul->getPanelName().'_pap_sid'])) {
        $papsid = $_COOKIE[$modul->getPanelName().'_pap_sid'];
        Gpf_Session::create($modul, $papsid);
        $authuser = Gpf_Session::getAuthUser();
    }

    if ($authuser == null || !isAuthUserPermitted($authuser)) {
        if (isset($_COOKIE[$modul->getPanelName()])) {
            $papsid = $_COOKIE[$modul->getPanelName()];
            Gpf_Session::create($modul, $papsid);
            $authuser = Gpf_Session::getAuthUser();
            if (!isAuthUserPermitted($authuser)) {
                exit('Error, you need to be logged as master merchant.');
            }
        } else {
            exit('Error, you need to be logged as master merchant.');
        }
    }
}

function isAuthUserPermitted(Gpf_Auth_User $authuser) {
    if (!$authuser->isLogged() || !$authuser->isExists()) {
        return false;
    }
    if (!$authuser->hasPrivilege(Gpf_Privileges::PLUGIN_CONFIG, Pap_Privileges::P_WRITE)) {
        return false;
    }
    return true;
}

$consumerKey = Gpf_Settings::get(AWeberAPI_Config::AUTORESPONDER_APP_CONSUMER_KEY);
$consumerSecret = Gpf_Settings::get(AWeberAPI_Config::AUTORESPONDER_APP_CONSUMER_SECRET);

if ($consumerKey == '' || $consumerSecret == '') {
    die('Error: Consumer Key and Consumer secret of your Aweber App is not configured in plugin config.');
}

$aweber = new AWeberAPI($consumerKey, $consumerSecret);

if (empty($_COOKIE['accessToken'])) {
    if (empty($_GET['oauth_token'])) {
        $callbackUrl = 'http://'.$_SERVER['HTTP_HOST'].$_SERVER['REQUEST_URI'];
        try {
            list($requestToken, $requestTokenSecret) = $aweber->getRequestToken($callbackUrl);
            setcookie('requestTokenSecret', $requestTokenSecret);
            setcookie('callbackUrl', $callbackUrl);
            header("Location: {$aweber->getAuthorizeUrl()}");
            exit();
        } catch (Exception $e) {
            die('Aweber app is not correctly configured, error: '.$e->getMessage());
        }
    }

    $aweber->user->tokenSecret = $_COOKIE['requestTokenSecret'];
    $aweber->user->requestToken = $_GET['oauth_token'];
    $aweber->user->verifier = $_GET['oauth_verifier'];
    try {
        list($accessToken, $accessTokenSecret) = $aweber->getAccessToken();
        setcookie('accessToken', $accessToken);
        setcookie('accessTokenSecret', $accessTokenSecret);
        header('Location: '.$_COOKIE['callbackUrl']);
        exit();
    } catch (Exception $e) {
        die('Aweber app is not correctly configured, error: '.$e->getMessage());
    }
}

$aweber->adapter->debug = false;

savePluginAccessDetails($_COOKIE['accessToken'], $_COOKIE['accessTokenSecret']);

echo 'Success: Your aweber account is correctly configured. You can close this tab and return back to your merchant panel.';
die();

function savePluginAccessDetails($accessToken, $accessSecret) {
    Gpf_Settings::set(AWeberAPI_Config::AUTORESPONDER_APP_AUTH_ACCESS_KEY, $accessToken);
    Gpf_Settings::set(AWeberAPI_Config::AUTORESPONDER_APP_AUTH_ACCESS_SECRET, $accessSecret);
}
