<?php
/**
 *   @copyright Copyright (c) 2018 Quality Unit s.r.o.
 *   @author Matej Kendera
 *   @package PostAffiliatePro
 *   @since Version 1.0.0
 *
 *   Licensed under the Quality Unit, s.r.o. Standard End User License Agreement,
 *   Version 1.0 (the "License"); you may not use this file except in compliance
 *   with the License. You may obtain a copy of the License at
 *   http://www.postaffiliatepro.com/licenses/license
 *
 */

/**
 * @package PostAffiliatePro
 */
class AWeberAPI_Main extends Gpf_Plugins_Handler {

    /**
     * @var Gpf_Log_Logger
     */
    private $logger;

    public static function getHandlerInstance() {
        return new AWeberAPI_Main();
    }

    public function initSettings($context) {
        $context->addDbSetting(AWeberAPI_Config::AUTORESPONDER_LIST, 'mylistname');
        $context->addDbSetting(AWeberAPI_Config::AUTORESPONDER_ADD_REFID, Gpf::NO);
        $context->addDbSetting(AWeberAPI_Config::AUTORESPONDER_REFID_FIELDNAME, 'ad_tracking');
        $context->addDbSetting(AWeberAPI_Config::AUTORESPONDER_APP_CONSUMER_KEY, '');
        $context->addDbSetting(AWeberAPI_Config::AUTORESPONDER_APP_CONSUMER_SECRET, '');
        $context->addDbSetting(AWeberAPI_Config::AUTORESPONDER_APP_AUTH_ACCESS_KEY, '');
        $context->addDbSetting(AWeberAPI_Config::AUTORESPONDER_APP_AUTH_ACCESS_SECRET, '');
    }

    public function addToAweber(Pap_Common_User $user) {
        $this->log('Aweber - registration user started');

        $autoresponderListName = Gpf_Settings::get(AWeberAPI_Config::AUTORESPONDER_LIST);

        $this->registerToAweber($autoresponderListName, $user->getEmail(), $user->getName(), $user->getIp(), $user->getRefId());

        $this->log('Aweber - registration user end');
    }

    private function registerToAweber($aweberListName, $affilaiteEmail, $affilaiteName, $affilaiteIpAddress, $affiliateRefid) {
        $consumerKey = Gpf_Settings::get(AWeberAPI_Config::AUTORESPONDER_APP_CONSUMER_KEY);
        $consumerSecret = Gpf_Settings::get(AWeberAPI_Config::AUTORESPONDER_APP_CONSUMER_SECRET);

        if ($consumerKey == '' || $consumerSecret == '') {
            $this->log('consumer key or secret is not set in pluign configuration', Gpf_Log::ERROR);
            return;
        }

        $accessKey = Gpf_Settings::get(AWeberAPI_Config::AUTORESPONDER_APP_AUTH_ACCESS_KEY);
        $accessSecret = Gpf_Settings::get(AWeberAPI_Config::AUTORESPONDER_APP_AUTH_ACCESS_SECRET);

        if ($accessKey == '' || $accessSecret == '') {
            $this->log('Aweber App is not authorized with Aweber account via pluign More info', Gpf_Log::ERROR);
            return;
        }

        require_once 'aweber_api/aweber.php';

        $aweber = new AWeberAPI($consumerKey, $consumerSecret);

        $listURL = '';
        try {
            $account = $aweber->getAccount($accessKey, $accessSecret);
            $aweberListId = $this->loadAweberListIdByName($account, $aweberListName);
            $accountId = $account->id;

            $listURL = "/accounts/{$accountId}/lists/{$aweberListId}";
            $this->log('Loading list from URL: '.$listURL);
            $list = $account->loadFromUrl($listURL);
            $params = array(
                    'email' => $affilaiteEmail,
                    'ip_address' => $affilaiteIpAddress,
                    'misc_notes' => '',
                    'name' => $affilaiteName
            );
            if (Gpf_Settings::get(AWeberAPI_Config::AUTORESPONDER_ADD_REFID) == Gpf::YES) {
                $params[Gpf_Settings::get(AWeberAPI_Config::AUTORESPONDER_REFID_FIELDNAME)] = $affiliateRefid;
            }
            $subscribers = $list->subscribers;
            $this->log('process params: '.var_export($params, true));
            $new_subscriber = $subscribers->create($params);
            $this->log('success: '.$affilaiteEmail.' was added to the list: '.$list->name . ' listID: '.$list->id);
        } catch (Exception $e) {
            $this->log('error: unable to add: '. $affilaiteEmail .' to list url: '.$listURL.', error: '.$e->getMessage(), Gpf_Log::ERROR);
        }
    }

    private function loadAweberListIdByName($account, $aweberListName) {
        $lists = $account->lists->find(array('name' => $aweberListName));

        if(count($lists)) {
            $list = $lists[0];
            return $list->id;
        } else {
            return $aweberListName;
        }
    }

    /**
     * @return Gpf_Log_Logger
     */
    private function getLogger() {
        if ($this->logger === null) {
            $this->logger = Pap_Logger::create(Pap_Common_Constants::TYPE_SIGNUP);
        }
        return $this->logger;
    }

    private function log($message, $logLevel = Gpf_Log::DEBUG) {
        $this->getLogger()->log('AWeberAPI: '.$message, $logLevel);
    }
}
