<?php
/**
 *   @copyright Copyright (c) 2018 Quality Unit s.r.o.
 *   @author Matej Kendera
 *   @package PostAffiliatePro
 *   @since Version 1.0.0
 *
 *   Licensed under the Quality Unit, s.r.o. Standard End User License Agreement,
 *   Version 1.0 (the "License"); you may not use this file except in compliance
 *   with the License. You may obtain a copy of the License at
 *   http://www.postaffiliatepro.com/licenses/license
 *
 */

/**
 * @package PostAffiliatePro
 */
class AWeberAPI_Definition extends Gpf_Plugins_Definition {

    public function __construct() {
        $this->codeName = 'AWeberAPI';
        $this->name = $this->_('AWeber Autoresponder Integration V2');
        $this->description = $this->_('Register your new approved affiliates automatically to AWeber. Integration is using AWeber API via aweber APP created in aweber labs. Press the Configure button and enter your AWeber autoresponder list name.');
        $this->configurationClassName = 'AWeberAPI_Config';
        $this->version = '1.0.1';

        $this->help = $this->_('Plugin subscribe new approved affiliates to Aweber.<br/>
<br/>
You need to have created app in aweber labs: %s.<br/>
Next fill your Consumer Key and Consumer secret of your App to plugin configuration fields.</br>
For using Aweber you need to authorize your application with your Aweber account via this url: %s',
                '<a href="https://labs.aweber.com/apps" target="_blank">https://labs.aweber.com/apps</a>',
                '<a href="'.Gpf_Paths::getInstance()->getFullBaseServerUrlWithoutProtocol() . Gpf_Paths::PLUGINS_DIR . 'AWeberAPI/aweber_authorization.php" target="_blank">'.Gpf_Paths::getInstance()->getFullBaseServerUrl() . Gpf_Paths::PLUGINS_DIR . 'AWeberAPI/aweber_authorization.php</a>');

        $this->addImplementation('Core.defineSettings', 'AWeberAPI_Main', 'initSettings');
        $this->addImplementation('PostAffiliate.affiliate.firsttimeApproved', 'AWeberAPI_Main', 'addToAweber');
    }
}
?>
