<?php
/**
 *   @copyright Copyright (c) 2018 Quality Unit s.r.o.
 *   @author Matej Kendera
 *   @package PostAffiliatePro
 *   @since Version 1.0.0
 *
 *   Licensed under the Quality Unit, s.r.o. Standard End User License Agreement,
 *   Version 1.0 (the "License"); you may not use this file except in compliance
 *   with the License. You may obtain a copy of the License at
 *   http://www.postaffiliatepro.com/licenses/license
 *
 */

/**
 * @package PostAffiliatePro
 */
class AWeberAPI_Config extends Gpf_Plugins_Config {

    const AUTORESPONDER_LIST = 'aweberApi_autoresponder_list';
    const AUTORESPONDER_ADD_REFID = 'aweberApi_autoresponder_add_refid';
    const AUTORESPONDER_REFID_FIELDNAME = 'aweberApi_autoresponder_refid_fieldname';

    const AUTORESPONDER_APP_CONSUMER_KEY = 'aweberApi_appConsumerKey';
    const AUTORESPONDER_APP_CONSUMER_SECRET = 'aweberApi_appConsumerSecret';

    const AUTORESPONDER_APP_AUTH_ACCESS_KEY = 'aweberApi_authAccessKey';
    const AUTORESPONDER_APP_AUTH_ACCESS_SECRET = 'aweberApi_authAccessSecret';



    protected function initFields() {
        $this->addTextBox($this->_('Aweber list name'), self::AUTORESPONDER_LIST, $this->_('Fill AWeber list name'));
        $this->addTextBox($this->_('Consumer Key'), self::AUTORESPONDER_APP_CONSUMER_KEY, $this->_('Fill your Consumer Key of your App'));
        $this->addTextBox($this->_('Consumer Secret'), self::AUTORESPONDER_APP_CONSUMER_SECRET, $this->_('Fill your Consumer secret of your App'));
        $this->addCheckBox($this->_('Send Referral ID'), self::AUTORESPONDER_ADD_REFID, $this->_('If this is checked also the affiliate\'s Referral ID is sent to AWeber'), array(self::AUTORESPONDER_REFID_FIELDNAME));
        $this->addTextBox($this->_('Referral ID field name'), self::AUTORESPONDER_REFID_FIELDNAME, $this->_('If \'Send Referral ID\' is enabled, this field name is used for it.'));
    }

    /**
     * @service plugin_config write
     * @param Gpf_Rpc_Params $params
     * @return Gpf_Rpc_Form
     */
    public function save(Gpf_Rpc_Params $params) {
        $form = new Gpf_Rpc_Form($params);
        Gpf_Settings::set(self::AUTORESPONDER_APP_CONSUMER_KEY, $form->getFieldValue(self::AUTORESPONDER_APP_CONSUMER_KEY));
        Gpf_Settings::set(self::AUTORESPONDER_APP_CONSUMER_SECRET, $form->getFieldValue(self::AUTORESPONDER_APP_CONSUMER_SECRET));
        Gpf_Settings::set(self::AUTORESPONDER_ADD_REFID, $form->getFieldValue(self::AUTORESPONDER_ADD_REFID));
        Gpf_Settings::set(self::AUTORESPONDER_REFID_FIELDNAME, $form->getFieldValue(self::AUTORESPONDER_REFID_FIELDNAME));
        Gpf_Settings::set(self::AUTORESPONDER_LIST, $form->getFieldValue(self::AUTORESPONDER_LIST));
        $form->setInfoMessage($this->_('AWeber saved'));
        return $form;
    }

    /**
     * @service plugin_config read
     * @param Gpf_Rpc_Params $params
     * @return Gpf_Rpc_Form
     */
    public function load(Gpf_Rpc_Params $params) {
        $form = new Gpf_Rpc_Form($params);
        $form->addField(self::AUTORESPONDER_APP_CONSUMER_KEY, Gpf_Settings::get(self::AUTORESPONDER_APP_CONSUMER_KEY));
        $form->addField(self::AUTORESPONDER_APP_CONSUMER_SECRET, Gpf_Settings::get(self::AUTORESPONDER_APP_CONSUMER_SECRET));
        $form->addField(self::AUTORESPONDER_LIST, Gpf_Settings::get(self::AUTORESPONDER_LIST));
        $form->addField(self::AUTORESPONDER_ADD_REFID, Gpf_Settings::get(self::AUTORESPONDER_ADD_REFID));
        $form->addField(self::AUTORESPONDER_REFID_FIELDNAME, Gpf_Settings::get(self::AUTORESPONDER_REFID_FIELDNAME));
        return $form;
    }
}
