<?php
/**
 *   @copyright Copyright (c) 2007 Quality Unit s.r.o.
 *   @author Michal Bebjak
 *   @package GwtPhpFramework
 *   @since Version 1.0.0
 *
 *   Licensed under the Quality Unit, s.r.o. Standard End User License Agreement,
 *   Version 1.0 (the "License"); you may not use this file except in compliance
 *   with the License. You may obtain a copy of the License at
 *   http://www.postaffiliatepro.com/licenses/license
 *
 */

/**
 * @package GwtPhpFramework
 */
class CyberSource_Config extends Gpf_Plugins_Config {
    const CUSTOM_FIELD_NUMBER = 'CybersourceCustomFieldNumber';
    const USE_LIFETIME = 'CybersourceUseLifeTime';

    protected function initFields() {
        $values = array('0' => '', 1 => '1', 2 => '2', 3 => '3', 4 => '4');
        $this->addListBox($this->_('Custom field number'), self::CUSTOM_FIELD_NUMBER, $values, $this->_('Custom field number sets number of the custom field which will be used for storing tracking data. '));
        $this->addCheckBox($this->_('Support lifetime commission'), self::USE_LIFETIME, $this->_('Customer email will be stored in transaction data1 field.'));
    }

    /**
     * @service plugin_config write
     * @param Gpf_Rpc_Params $params
     * @return Gpf_Rpc_Form
     */
    public function save(Gpf_Rpc_Params $params) {
        $form = new Gpf_Rpc_Form($params);
        $customFieldNumber = (integer)$form->getFieldValue(self::CUSTOM_FIELD_NUMBER);
        if ($customFieldNumber < 1 || $customFieldNumber > 4) {
            $form->setFieldError(self::CUSTOM_FIELD_NUMBER, $this->_('Custom field number must be from range 1-4.'));
            return $form;
        }
        Gpf_Settings::set(self::CUSTOM_FIELD_NUMBER, $customFieldNumber);
        Gpf_Settings::set(self::USE_LIFETIME, $form->getFieldValue(self::USE_LIFETIME));
        $form->setInfoMessage($this->_('CyberSource plugin configuration saved'));
        return $form;
    }

    /**
     * @service plugin_config read
     * @param Gpf_Rpc_Params $params
     * @return Gpf_Rpc_Form
     */
    public function load(Gpf_Rpc_Params $params) {
        $form = new Gpf_Rpc_Form($params);
        $form->addField(self::CUSTOM_FIELD_NUMBER, Gpf_Settings::get(self::CUSTOM_FIELD_NUMBER));
        $form->addField(self::USE_LIFETIME, Gpf_Settings::get(self::USE_LIFETIME));
        return $form;
    }
}

?>
