<!DOCTYPE html>
<html lang="{$lang|escape}">
	<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta http-equiv="content-type" content="text/html; charset=utf-8"/>
    <meta http-Equiv="Cache-Control" Content="no-cache"/>
    <meta http-Equiv="Pragma" Content="no-cache"/>
    <meta http-Equiv="Expires" Content="0"/>
    <meta name="robots" content="none"/>
    <meta name="referrer" content="no-referrer"/>
		<meta name="description" content="{$metaDescription}" />
		<meta name="keywords" content="{$metaKeywords}" />

    <title>{$title}</title>
    <meta name="theme-color" content="#2ecc71"/>
    <meta name="apple-mobile-web-app-capable" content="yes"/>
    <meta name="apple-mobile-web-app-status-bar-style" content="black"/>
    <link href="{$faviconUrl}" rel="shortcut icon"/>
    <link href="{$faviconUrl}" rel="icon"/>
    <link rel="icon" sizes="192x192" href="{$themePath}img/icon-192.png">
    <link rel="icon" sizes="128x128" href="{$themePath}img/icon-128.png">
    <link rel="apple-touch-icon" sizes="128x128" href="{$themePath}img/icon-128.png">
    {$cachedData}
    {if $gwtModuleName}
    	<script type="text/javascript" src="{$gwtModuleName}"></script>
    {/if}

    <style type="text/css" media="all">
        {foreach from=$stylesheets item=stylesheet}
        	@import "{$stylesheet}";
        {/foreach}
    </style>
    {foreach from=$jsResources item=jsResource}
        <script src="{$jsResource.resource}" type="text/javascript" {if $jsResource.id ne null}id="{$jsResource.id}"{/if}></script>
    {/foreach}
    {foreach from=$jsScripts item=jsScript}
    <script type="text/javascript">
        {$jsScript}
    </script>
    {/foreach}
	</head>
  <body {if $isLogged eq 1}class="LoggedIn"{else}class="NotLoggedIn"{/if}>
		<!-- main_html_doc -->
		<iframe src="javascript:''" id="__gwt_historyFrame" style="width:0;height:0;border:0; position:absolute;"></iframe>
		{$body}
        {include file='panel_footer.stpl'}
  </body>
</html>
