<?php
/**
 *   @copyright Copyright (c) 2015 Quality Unit s.r.o.
 *   @author Martin Pullmann
 *   @package PostAffiliatePro
 *   @since Version 1.0.0
 *
 *   Licensed under the Quality Unit, s.r.o. Standard End User License Agreement,
 *   Version 1.0 (the "License"); you may not use this file except in compliance
 *   with the License. You may obtain a copy of the License at
 *   http://www.qualityunit.com/licenses/license
 *
 */

/**
 * @package PostAffiliatePro
 */
class Stripe_Config extends Gpf_Plugins_Config {
    const API_KEY = 'StripeApiKey';
    const TEST_API_KEY = 'StripeTestApiKey';
    const ENVIRONMENT = 'StripeEnviro';
    const CUSTOM_SEPARATOR = 'StripeCustomSeparator';
    const TRACK_CHARGE_EVENT = 'StripeTrackChargeEvent';
    const TRACK_SESSION_EVENT = 'StripeTrackSessionEvent';
    const CREATE_AFFILIATE = 'StripeCreateAffiliate';
    const DATA1 = 'StripeData1';
    const DATA3 = 'StripeData3';
    const DATA4 = 'StripeData4';
    const DATA5 = 'StripeData5';
    const SUBSCRIPTION_INDEX = 'StripeSubscriptionIndex'; // Internal
    const PRODUCT_ID = 'StripeProductId';

    const ENVIRONMENT_LIVE = 'L';
    const ENVIRONMENT_TEST = 'T';
    /**
     * @service plugin_config_account read
     * @param Gpf_Rpc_Params $params
     * @return Gpf_Data_RecordSet
     */
    public function getFields(Gpf_Rpc_Params $params) {
        return parent::getFields($params);
    }

    protected function initFields() {
        $extraDataOptions = array (
            '0' => '',
            'email' => 'Customer email',
            'id' => 'Customer ID',
            'customer_phone' => 'Customer phone number',
            'customer_name' => 'Customer name',
            'address_street' => 'Customer street',
            'address_city' => 'Customer city',
            'address_state' => 'Customer state',
            'address_country' => 'Customer country',
            'address_zip' => 'Customer ZIP code'
        );

        $productIdOptions = array(
            'product' => 'Plan\'s product',
            'id' => 'Plan\'s ID'
        );

        $this->addTextBox($this->_('Secret API Key'), self::API_KEY, $this->_('You can find your secret API key in your Stripe admin panel, in https://manage.stripe.com/account'));
        $this->addTextBox($this->_('Test secret API Key'), self::TEST_API_KEY, $this->_('Use this field in case you want to use test environment of Stripe'));
        $radioValues = array(
            self::ENVIRONMENT_LIVE => 'Live',
            self::ENVIRONMENT_TEST => 'Test'
        );
        $this->addRadioBox('Environment to use', self::ENVIRONMENT, $radioValues);
        $this->addTextBox($this->_('Custom separator'), self::CUSTOM_SEPARATOR, $this->_("Custom separator should be set only in case you are already using customer 'description' field for something else than for integration with Post Affiliate Pro."));
        $this->addCheckBox($this->_('Track \'Charge\' event'), self::TRACK_CHARGE_EVENT, $this->_('By default, the plugin tracks commissions when \'invoice.payment_succeeded\' event is received. The checkbox will make the plugin to listen to \'charge.succeeded\' which is useful when you (your site/plugin) do not use invoices.'), array(self::PRODUCT_ID), array(Gpf::NO));
        $this->addCheckBox($this->_('Track \'Checkout\' event'), self::TRACK_SESSION_EVENT, $this->_('The checkbox will make the plugin to listen to \'checkout.session.completed\' which is used when Stripe JS integration is used.'));
        $this->addCheckBox($this->_('Create affiliate'), self::CREATE_AFFILIATE, $this->_('When enabled a new affiliate account will be created for payer'));
        $this->addListBox($this->_('Product ID'), self::PRODUCT_ID, $productIdOptions, $this->_('Select what will save as commission\'s Product ID'));

        $this->addListBox($this->_('Extra data 1'), self::DATA1, $extraDataOptions, $this->_('Choose a value for sale extra data %n.', '1'));
        $this->addListBox($this->_('Extra data 3'), self::DATA3, $extraDataOptions, $this->_('Choose a value for sale extra data %n.', '3'));
        $this->addListBox($this->_('Extra data 4'), self::DATA4, $extraDataOptions, $this->_('Choose a value for sale extra data %n.', '4'));
        $this->addListBox($this->_('Extra data 5'), self::DATA5, $extraDataOptions, $this->_('Choose a value for sale extra data %n.', '5'));
    }

    /**
     * @service plugin_config_account write
     * @param Gpf_Rpc_Params $params
     * @return Gpf_Rpc_Form
     */
    public function save(Gpf_Rpc_Params $params) {
        $form = new Gpf_Rpc_Form($params);

        if (substr($form->getFieldValue(self::API_KEY), 0, 3) != 'sk_') {
            $form->setFieldError(self::API_KEY, $this->_('You did not use secret API key.'));
            return $form;
        }

        Gpf_Settings::set(self::CUSTOM_SEPARATOR, $form->getFieldValue(self::CUSTOM_SEPARATOR));
        Gpf_Settings::set(self::API_KEY, $form->getFieldValue(self::API_KEY));
        Gpf_Settings::set(self::TEST_API_KEY, $form->getFieldValue(self::TEST_API_KEY));
        Gpf_Settings::set(self::ENVIRONMENT, $form->getFieldValue(self::ENVIRONMENT));
        Gpf_Settings::set(self::TRACK_CHARGE_EVENT, $form->getFieldValue(self::TRACK_CHARGE_EVENT));
        Gpf_Settings::set(self::TRACK_SESSION_EVENT, $form->getFieldValue(self::TRACK_SESSION_EVENT));
        Gpf_Settings::set(self::CREATE_AFFILIATE, $form->getFieldValue(self::CREATE_AFFILIATE));
        Gpf_Settings::set(self::PRODUCT_ID, $form->getFieldValue(self::PRODUCT_ID));
        Gpf_Settings::set(self::DATA1, $form->getFieldValue(self::DATA1));
        Gpf_Settings::set(self::DATA3, $form->getFieldValue(self::DATA3));
        Gpf_Settings::set(self::DATA4, $form->getFieldValue(self::DATA4));
        Gpf_Settings::set(self::DATA5, $form->getFieldValue(self::DATA5));

        if ($form->getFieldValue(self::ENVIRONMENT) == self::ENVIRONMENT_LIVE && $form->getFieldValue(self::API_KEY) == '') {
            $errorMessage = $this->_('API key must be provided!');
            $form->setFieldError(self::API_KEY, $errorMessage);
            $form->setErrorMessage($errorMessage);
            return $form;
        }
        if ($form->getFieldValue(self::ENVIRONMENT) == self::ENVIRONMENT_TEST && $form->getFieldValue(self::TEST_API_KEY) == '') {
            $errorMessage = $this->_('API key must be provided!');
            $form->setFieldError(self::TEST_API_KEY, $errorMessage);
            $form->setErrorMessage($errorMessage);
            return $form;
        }

        $form->setInfoMessage($this->_('Stripe settings saved'));
        return $form;
    }

    /**
     * @service plugin_config_account read
     * @param Gpf_Rpc_Params $params
     * @return Gpf_Rpc_Form
     */
    public function load(Gpf_Rpc_Params $params) {
        $form = new Gpf_Rpc_Form($params);
        $form->addField(self::CUSTOM_SEPARATOR, Gpf_Settings::get(self::CUSTOM_SEPARATOR));
        $form->addField(self::API_KEY, Gpf_Settings::get(self::API_KEY));
        $form->addField(self::TEST_API_KEY, Gpf_Settings::get(self::TEST_API_KEY));
        $form->addField(self::ENVIRONMENT, Gpf_Settings::get(self::ENVIRONMENT));
        $form->addField(self::TRACK_CHARGE_EVENT, Gpf_Settings::get(self::TRACK_CHARGE_EVENT));
        $form->addField(self::TRACK_SESSION_EVENT, Gpf_Settings::get(self::TRACK_SESSION_EVENT));
        $form->addField(self::CREATE_AFFILIATE, Gpf_Settings::get(self::CREATE_AFFILIATE));
        $form->addField(self::PRODUCT_ID, Gpf_Settings::get(self::PRODUCT_ID));
        $form->addField(self::DATA1, Gpf_Settings::get(self::DATA1));
        $form->addField(self::DATA3, Gpf_Settings::get(self::DATA3));
        $form->addField(self::DATA4, Gpf_Settings::get(self::DATA4));
        $form->addField(self::DATA5, Gpf_Settings::get(self::DATA5));
        return $form;
    }
}
