<?php
/**
 *   @copyright Copyright (c) 2019 Quality Unit s.r.o.
 *   @author Matej Kendera
 *   @package PostAffiliatePro
 *   @since Version 1.0.0
 *
 *   Licensed under the Quality Unit, s.r.o. Standard End User License Agreement,
 *   Version 1.0 (the "License"); you may not use this file except in compliance
 *   with the License. You may obtain a copy of the License at
 *   http://www.postaffiliatepro.com/licenses/license
 *
 */
class SaleFilter_Config extends Gpf_Plugins_Config {

    const CHECK_ACTIONS = 'SaleFilter_CheckActions';

    protected function initFields() {
        $this->addCheckBox($this->_('Apply sale filter also on action commissions'), self::CHECK_ACTIONS, $this->_('If this checkbox is not checked, sale filter is applied only on Sales commissions.'));
    }

    /**
     * @service plugin_config write
     * @param Gpf_Rpc_Params $params
     * @return Gpf_Rpc_Form
     */
    public function save(Gpf_Rpc_Params $params) {
        $form = new Gpf_Rpc_Form($params);

        Gpf_Settings::set(self::CHECK_ACTIONS, $form->getFieldValue(self::CHECK_ACTIONS));

        $form->setInfoMessage($this->_('Settings saved'));
        return $form;
    }

    /**
     * @service plugin_config read
     * @param Gpf_Rpc_Params $params
     * @return Gpf_Rpc_Form
     */
    public function load(Gpf_Rpc_Params $params) {
        $form = new Gpf_Rpc_Form($params);
        $form->addField(self::CHECK_ACTIONS, Gpf_Settings::get(self::CHECK_ACTIONS));
        return $form;
    }
}
