<?php
/**
 *   @copyright Copyright (c) 2019 Quality Unit s.r.o.
 *   @author Martin Svitek
 *   @package PostAffiliatePro
 *   @since Version 1.0.0
 *
 *   Licensed under the Quality Unit, s.r.o. Standard End User License Agreement,
 *   Version 1.0 (the "License"); you may not use this file except in compliance
 *   with the License. You may obtain a copy of the License at
 *   http://www.postaffiliatepro.com/licenses/license
 *
 */

/**
 * @package PostAffiliatePro plugins
 */
class Recurly_Tracker extends Pap_Tracking_CallbackTracker {

    const SUBSCRIPTION_RENEW = 'renewed_subscription_notification';

    /**
     * @return Recurly_Tracker
     */
    public static function getInstance() {
        $tracker = new Recurly_Tracker();
        $tracker->setTrackerName('Recurly');
        return $tracker;
    }

    public function getOrderID() {
        return $this->getSubscriptionID();
    }

    public function checkStatus() {
        $this->debug("Checking type '".$this->getType()."'");
        if (($this->getType() != self::SUBSCRIPTION_RENEW)) {
            $this->debug('Not a renewed subscription webhook: ' . $this->getType());
            return false;
        }
        return true;
    }

    public function isRecurring() {
        return true;
    }

    public function readRequestVariables() {
        $input = $this->readXmlData();

        $this->debug('Input get: ' . $input);
        try {
            $xml = new SimpleXMLElement($input);
        } catch (Exception $e) {
            $this->setPaymentStatus("Failed");
            $this->debug('Wrong XML format!');
            return false;
        }

        $this->setType($xml->getName());

        if ($this->getType() != self::SUBSCRIPTION_RENEW) {
            return;
        }

        $this->setTotalCost((string)$xml->{"subscription"}->{"total_amount_in_cents"}/100);
        $this->setProductID((string)$xml->{"subscription"}->{"plan"}->{"plan_code"});
        $this->setSubscriptionID((string)$xml->{"subscription"}->{"uuid"});
        $this->setData1((string)$xml->{"account"}->{"account_code"}); // email
    }

    protected function getRecurringTotalCost() {
        return $this->getTotalCost();
    }

    protected function readXmlData() {
        $post_data = file_get_contents('php://input');
        return $post_data;
    }
}
?>
