<?php
/**
 *   @copyright Copyright (c) 2007 Quality Unit s.r.o.
 *   @author Maros Fric
 *   @package PostAffiliatePro
 *   @since Version 1.0.0
 *
 *   Licensed under the Quality Unit, s.r.o. Standard End User License Agreement,
 *   Version 1.0 (the "License"); you may not use this file except in compliance
 *   with the License. You may obtain a copy of the License at
 *   http://www.postaffiliatepro.com/licenses/license
 *
 */

/**
 * @package PostAffiliatePro plugins
 */
class PayPal_Main extends Gpf_Plugins_Handler {

    /**
     * @return PayPal_Main
     */
    public static function getHandlerInstance() {
        return new PayPal_Main();
    }

    public function initSettings($context) {
        $context->addDbSetting(PayPal_Config::CUSTOM_SEPARATOR, '');
        $context->addDbSetting(PayPal_Config::USE_COUPON, Gpf::NO);
        $context->addDbSetting(PayPal_Config::DISCOUNT_FEE, Gpf::NO);
        $context->addDbSetting(PayPal_Config::DISCOUNT_HANDLING, Gpf::NO);
        $context->addDbSetting(PayPal_Config::DISCOUNT_SHIPPING, Gpf::NO);
        $context->addDbSetting(PayPal_Config::DISCOUNT_TAX, Gpf::NO);
        $context->addDbSetting(PayPal_Config::REGISTER_AFFILIATE, Gpf::NO);
        $context->addDbSetting(PayPal_Config::REGISTER_AFFILIATE_PRODUCTS, '');
        $context->addDbSetting(PayPal_Config::USE_RECURRING_COMMISSION_SETTINGS, Gpf::NO);
        $context->addDbSetting(PayPal_Config::NORMAL_COMMISSION_AS_RECURRING_COMMISSION, Gpf::NO);
        $context->addDbSetting(PayPal_Config::RECURRING_TOTALCOST_FROM_NOTIFICATION, Gpf::NO);
        $context->addDbSetting(PayPal_Config::TEST_MODE, Gpf::NO);
        $context->addDbSetting(PayPal_Config::PAYPAL_REFUND, Gpf::YES);
        $context->addDbSetting(PayPal_Config::APPROVE_AFFILIATE, Gpf::NO);
        $context->addDbSetting(PayPal_Config::DECLINE_AFFILIATE, Gpf::NO);
        $context->addDbSetting(PayPal_Config::RESEND_IPN_URL, '');
        $context->addDbSetting(PayPal_Config::PROCESS_WHOLE_CART_AS_ONE_TRANSACTION, Gpf::YES);
        $context->addDbSetting(PayPal_Config::DATA1, 'payer_email');
        $context->addDbSetting(PayPal_Config::DATA2, 'txn_id');
        $context->addDbSetting(PayPal_Config::DATA3, '0');
        $context->addDbSetting(PayPal_Config::DATA4, '0');
        $context->addDbSetting(PayPal_Config::DATA5, '0');
    }
}
?>
