<?php
/**
 *   @copyright Copyright (c) 2018 Quality Unit s.r.o.
 *   @author Martin Pullmann
 *   @package PostAffiliatePro
 *   @since Version 1.0.0
 *
 *   Licensed under the Quality Unit, s.r.o. Standard End User License Agreement,
 *   Version 1.0 (the "License"); you may not use this file except in compliance
 *   with the License. You may obtain a copy of the License at
 *   http://www.postaffiliatepro.com/licenses/license
 *
 */

/**
 * @package PostAffiliatePro plugins
 */
class Chargify_Definition extends Gpf_Plugins_Definition {

    public function __construct() {
        $this->codeName = 'Chargify';
        $this->name = $this->_('Chargify hook events handling');
        $this->description = $this->_('This plugin handles Chargify webhook event notifications (integration of Post Affiliate Pro with Chargify)');
        $this->version = '1.0.1';
        $this->configurationClassName = 'Chargify_Config';

        $this->addRequirement('PapCore', '4.0.4.6');

        $this->addImplementation('Core.defineSettings', 'Chargify_Main', 'initSettings');
    }
}
