<?php
/**
 *   @copyright Copyright (c) 2018 Quality Unit s.r.o.
 *   @author Martin Pullmann
 *   @package PostAffiliatePro
 *   @since Version 1.0.0
 *
 *   Licensed under the Quality Unit, s.r.o. Standard End User License Agreement,
 *   Version 1.0 (the "License"); you may not use this file except in compliance
 *   with the License. You may obtain a copy of the License at
 *   http://www.postaffiliatepro.com/licenses/license
 *
 */

/**
 * @package PostAffiliatePro
 */
class Chargify_Config extends Gpf_Plugins_Config {
    const USE_RECURRING_COMMISSION_SETTINGS = 'ChargifyUseRecurringCommissionSettings';
    const RECURRING_TOTALCOST_FROM_NOTIFICATION = 'ChargifyRecurringTotalCostFromNotification';
    const TRACK_REFUNDS = 'ChargifyRefundManagement';

    protected function initFields() {
        $this->addCheckBox($this->_('Use recurring total cost'), self::RECURRING_TOTALCOST_FROM_NOTIFICATION, $this->_('When this is checked the total cost from Chargify webhook notification will be used for recurring commission instead of total cost from the initial payment.'));
        $this->addCheckBox($this->_('Only matched recurrence'), self::USE_RECURRING_COMMISSION_SETTINGS, $this->_('This setting causes that every recurring payment will be saved only if orderid (subscription id) will be matched with orderid in recurring commissions. If orderid is not matched the recurring commission will not be created.'));
        $this->addCheckBox($this->_('Process refunds'), self::TRACK_REFUNDS, $this->_('If this option is enabled refunds from Chargify will be reflected in Post Affiliate Pro as well.'));
    }

    /**
     * @service plugin_config write
     * @param Gpf_Rpc_Params $params
     * @return Gpf_Rpc_Form
     */
    public function save(Gpf_Rpc_Params $params) {
        $form = new Gpf_Rpc_Form($params);
        Gpf_Settings::set(self::USE_RECURRING_COMMISSION_SETTINGS, $form->getFieldValue(self::USE_RECURRING_COMMISSION_SETTINGS));
        Gpf_Settings::set(self::RECURRING_TOTALCOST_FROM_NOTIFICATION, $form->getFieldValue(self::RECURRING_TOTALCOST_FROM_NOTIFICATION));
        Gpf_Settings::set(self::TRACK_REFUNDS, $form->getFieldValue(self::TRACK_REFUNDS));
        $form->setInfoMessage($this->_('Plugin settings saved'));
        return $form;
    }

    /**
     * @service plugin_config read
     * @param Gpf_Rpc_Params $params
     * @return Gpf_Rpc_Form
     */
    public function load(Gpf_Rpc_Params $params) {
        $form = new Gpf_Rpc_Form($params);
        $form->addField(self::USE_RECURRING_COMMISSION_SETTINGS, Gpf_Settings::get(self::USE_RECURRING_COMMISSION_SETTINGS));
        $form->addField(self::RECURRING_TOTALCOST_FROM_NOTIFICATION, Gpf_Settings::get(self::RECURRING_TOTALCOST_FROM_NOTIFICATION));
        $form->addField(self::TRACK_REFUNDS, Gpf_Settings::get(self::TRACK_REFUNDS));
        return $form;
    }
}
