<?php
/**
 *   @copyright Copyright (c) 2014 Quality Unit s.r.o.
 *   @author Martin Pullmann
 *   @package PostAffiliatePro
 *   @since Version 1.0.0
 *
 *   Licensed under the Quality Unit, s.r.o. Standard End User License Agreement,
 *   Version 1.0 (the "License"); you may not use this file except in compliance
 *   with the License. You may obtain a copy of the License at
 *   http://www.postaffiliatepro.com/licenses/license
 *
 */

/**
 * @package PostAffiliatePro plugins
 */
class BigCommerceAPI_Config extends Gpf_Plugins_Config {

    const API_USERNAME = 'BigCommerceAPIUsername';
    const API_PATH = 'BigCommerceAPIPath';
    const API_TOKEN = 'BigCommerceAPIToken';
    const PER_PRODUCT = 'BigCommercePerProduct';
    const COUPON_TRACKING = 'BigCommerceCouponTracking';
    const DATA = 'BigCommerceExtraData';
    const DATA1 = 'BigCommerceExtraData1';
    const DATA2 = 'BigCommerceExtraData2';
    const DATA3 = 'BigCommerceExtraData3';
    const DATA4 = 'BigCommerceExtraData4';
    const DATA5 = 'BigCommerceExtraData5';
    const EXTRA_DATA_CUSTOM_FIELDS = 'BigCommerceExtraDataCustomFields';

    protected function initFields() {
        $this->addTextBox($this->_('API Username'), self::API_USERNAME, $this->_('All your API credentials can be found in your BigCommerce admin - Advanced Settings  > Legacy API Account > edit an account'));
        $this->addTextBox($this->_('API Path'), self::API_PATH, $this->_('All your API credentials can be found in your BigCommerce admin - Advanced Settings > Legacy API Account > edit an account'));
        $this->addTextBox($this->_('API Token'), self::API_TOKEN, $this->_('All your API credentials can be found in your BigCommerce admin - Advanced Settings > Legacy API Account > edit an account'));
        $this->addCheckBox($this->_('Per product tracking'), self::PER_PRODUCT, $this->_('If you want to track each product separately (per product tracking), this option has to be selected'). '. ' .$this->_('The maximum limit is 250 products.'));
        $this->addCheckBox($this->_('Coupon code tracking'), self::COUPON_TRACKING, $this->_('If you want to use the Coupons feature to recognize affiliate based on the coupon code used during order then this option has to be enabled'));

        $this->initExtraDataFields();
    }

    protected function initExtraDataFields() {
        $extraData = $this->getExtraDataFields();

        $this->addTextBox($this->_('Custom fields for extra data'), self::EXTRA_DATA_CUSTOM_FIELDS, $this->_('Comma separated custom fields, will be available for extra data listboxes after save and refresh panel.'));
        $this->addListBox($this->_('Extra data 1'), self::DATA1, $extraData, $this->_('Choose a value for sale extra data 1.'));
        $this->addListBox($this->_('Extra data 2'), self::DATA2, $extraData, $this->_('Choose a value for sale extra data 2.'));
        $this->addListBox($this->_('Extra data 3'), self::DATA3, $extraData, $this->_('Choose a value for sale extra data 3.'));
        $this->addListBox($this->_('Extra data 4'), self::DATA4, $extraData, $this->_('Choose a value for sale extra data 4.'));
        $this->addListBox($this->_('Extra data 5'), self::DATA5, $extraData, $this->_('Choose a value for sale extra data 5.'));
    }

    private function getExtraDataFields() {
        $extraDataArray = array(
                '0' => '',
                'product_id' => $this->_('Product ID'),
                'name' => $this->_('Product name'),
                'sku' => $this->_('Product SKU'),
                'base_price' => $this->_('Product base price'),
                'quantity' => $this->_('Product quantity'),
                'customer_email' => $this->_('Customer email'),
                'customer_name' => $this->_('Customer name'),
                'customer_country' => $this->_('Customer country')
        );

        $customFieldsValue = Gpf_Settings::get(self::EXTRA_DATA_CUSTOM_FIELDS);
        $customFieldsArray = explode(',',$customFieldsValue);
        foreach ($customFieldsArray as $customField) {
            $extraDataArray[trim($customField)] = trim($customField);
        }
        return $extraDataArray;
    }

    /**
     * @service plugin_config write
     * @param Gpf_Rpc_Params $params
     * @return Gpf_Rpc_Form
     */
    public function save(Gpf_Rpc_Params $params) {
        $form = new Gpf_Rpc_Form($params);
        $form->setInfoMessage($this->_('BigCommerce API settings saved'));
        Gpf_Settings::set(self::API_USERNAME, $form->getFieldValue(self::API_USERNAME));
        Gpf_Settings::set(self::API_PATH, $form->getFieldValue(self::API_PATH));
        Gpf_Settings::set(self::API_TOKEN, $form->getFieldValue(self::API_TOKEN));
        Gpf_Settings::set(self::PER_PRODUCT, $form->getFieldValue(self::PER_PRODUCT));
        Gpf_Settings::set(self::COUPON_TRACKING, $form->getFieldValue(self::COUPON_TRACKING));
        return $this->saveExtraDataFields($form);
    }

    protected function saveExtraDataFields(Gpf_Rpc_Form $form) {
        Gpf_Settings::set(self::EXTRA_DATA_CUSTOM_FIELDS, $form->getFieldValue(self::EXTRA_DATA_CUSTOM_FIELDS));
        $extraDataFieldsArray = $this->getExtraDataFields();
        if (!array_key_exists($form->getFieldValue(self::DATA1), $extraDataFieldsArray)) {
            $errorMessage = $this->_('Custom field value: "%s" is not defined.', $form->getFieldValue(self::DATA1));
            $form->setFieldError(self::DATA1, $errorMessage);
            $form->setErrorMessage($errorMessage);
            return $form;
        }
        Gpf_Settings::set(self::DATA1, $form->getFieldValue(self::DATA1));
        if (!array_key_exists($form->getFieldValue(self::DATA2), $extraDataFieldsArray)) {
            $errorMessage = $this->_('Custom field value: "%s" is not defined.', $form->getFieldValue(self::DATA2));
            $form->setFieldError(self::DATA2, $errorMessage);
            $form->setErrorMessage($errorMessage);
            return $form;
        }
        Gpf_Settings::set(self::DATA2, $form->getFieldValue(self::DATA2));
        if (!array_key_exists($form->getFieldValue(self::DATA3), $extraDataFieldsArray)) {
            $errorMessage = $this->_('Custom field value: "%s" is not defined.', $form->getFieldValue(self::DATA3));
            $form->setFieldError(self::DATA3, $errorMessage);
            $form->setErrorMessage($errorMessage);
            return $form;
        }
        Gpf_Settings::set(self::DATA3, $form->getFieldValue(self::DATA3));
        if (!array_key_exists($form->getFieldValue(self::DATA4), $extraDataFieldsArray)) {
            $errorMessage = $this->_('Custom field value: "%s" is not defined.', $form->getFieldValue(self::DATA4));
            $form->setFieldError(self::DATA4, $errorMessage);
            $form->setErrorMessage($errorMessage);
            return $form;
        }
        Gpf_Settings::set(self::DATA4, $form->getFieldValue(self::DATA4));
        if (!array_key_exists($form->getFieldValue(self::DATA5), $extraDataFieldsArray)) {
            $errorMessage = $this->_('Custom field value: "%s" is not defined.', $form->getFieldValue(self::DATA5));
            $form->setFieldError(self::DATA5, $errorMessage);
            $form->setErrorMessage($errorMessage);
            return $form;
        }
        Gpf_Settings::set(self::DATA5, $form->getFieldValue(self::DATA5));
        return $form;
    }

    /**
     * @service plugin_config read
     * @param Gpf_Rpc_Params $params
     * @return Gpf_Rpc_Form
     */
    public function load(Gpf_Rpc_Params $params) {
        $form = new Gpf_Rpc_Form($params);
        $form->addField(self::API_USERNAME, Gpf_Settings::get(self::API_USERNAME));
        $form->addField(self::API_PATH, Gpf_Settings::get(self::API_PATH));
        $form->addField(self::API_TOKEN, Gpf_Settings::get(self::API_TOKEN));
        $form->addField(self::PER_PRODUCT, Gpf_Settings::get(self::PER_PRODUCT));
        $form->addField(self::COUPON_TRACKING, Gpf_Settings::get(self::COUPON_TRACKING));
        return $this->loadExtraDataFields($form);
    }

    protected  function loadExtraDataFields(Gpf_Rpc_Form $form) {
        $form->addField(self::EXTRA_DATA_CUSTOM_FIELDS, Gpf_Settings::get(self::EXTRA_DATA_CUSTOM_FIELDS));
        $form->addField(self::DATA1, Gpf_Settings::get(self::DATA1));
        $form->addField(self::DATA2, Gpf_Settings::get(self::DATA2));
        $form->addField(self::DATA3, Gpf_Settings::get(self::DATA3));
        $form->addField(self::DATA4, Gpf_Settings::get(self::DATA4));
        $form->addField(self::DATA5, Gpf_Settings::get(self::DATA5));
        return $form;
    }
}

?>
