<?php
/**
 *   @copyright Copyright (c) 2016 Quality Unit s.r.o.
 *
 *   Licensed under the Quality Unit, s.r.o. Standard End User License Agreement,
 *   Version 1.0 (the "License"); you may not use this file except in compliance
 *   with the License. You may obtain a copy of the License at
 *   http://www.qualityunit.com/licenses/license
 */

/**
 * Auto generated code from swagger api description. DO NOT EDIT !!!!
 * Codegen version: 1.5.3
 */
require '../../scripts/bootstrap_api.php';

$app = new \Slim\Slim();

try {
    RestApi_Make::init(new Pap_Api_Make());
} catch (Exception $ignore) {}

try {
    // You must implement this class, it will not be generated !!! It must extend RestApi_Auth
    $auth = Pap_Api_Auth::init($app->request());
} catch (Exception $e) {
    $response = new RestApi_Response($app->response());
    $response->setError($e);
    $response->send();
    exit();
}

/*
 * 
 */
$app->get('/affiliates/count', function () use ($app, $auth) {
    $params = new RestApi_Params($app->request(), array('affiliate.read'));
    $response = new RestApi_Response($app->response());
    try { 
        $params->check('_filters', false, '', 'string', null);
        $auth->checkScope($params->getScopes());
        $handler = new Pap_Api_V2_Affiliates($params);
        $response->setResult($handler->getCount());
    } catch (Exception $e) {
        $response->setError($e);
    }
});

/*
 * 
 */
$app->get('/affiliates', function () use ($app, $auth) {
    $params = new RestApi_Params($app->request(), array('affiliate.read'));
    $response = new RestApi_Response($app->response());
    try { 
        $params->check('_page', false, '1', 'int', null);
        $params->check('_perPage', false, '30', 'int', null);
        $params->check('_sortDir', false, 'ASC', 'string', array('ASC', 'DESC'));
        $params->check('_sortField', false, '', 'string', null);
        $params->check('_filters', false, '', 'string', null);
        $params->check('_fields', false, '', 'string[]', null);
        $auth->checkScope($params->getScopes());
        $handler = new Pap_Api_V2_Affiliates($params);
        $response->setResult($handler->getList());
    } catch (Exception $e) {
        $response->setError($e);
    }
});

/*
 * Get general affiliate link for specified affiliate user.
 */
$app->get('/affiliates/:id/generalAffiliateLink', function ($id) use ($app, $auth) {
    $params = new RestApi_Params($app->request(), array('general_link.read'));
    $response = new RestApi_Response($app->response());
    try { 
        $auth->checkScope($params->getScopes());
        $handler = new Pap_Api_V2_Affiliates($params);
        $response->setResult($handler->getGeneralAffiliateLink($id));
    } catch (Exception $e) {
        $response->setError($e);
    }
});

/*
 * Get informations about specified affiliate user.
 */
$app->get('/affiliates/:id', function ($id) use ($app, $auth) {
    $params = new RestApi_Params($app->request(), array('affiliate.read'));
    $response = new RestApi_Response($app->response());
    try { 
        $params->check('_fields', false, '', 'string[]', null);
        $auth->checkScope($params->getScopes());
        $handler = new Pap_Api_V2_Affiliates($params);
        $response->setResult($handler->get($id));
    } catch (Exception $e) {
        $response->setError($e);
    }
});

/*
 * Update affiliate status
 */
$app->put('/affiliates/:id/_changeStatus', function ($id) use ($app, $auth) {
    $params = new RestApi_Params($app->request(), array('affiliate.write'));
    $response = new RestApi_Response($app->response());
    try { 
        $params->check('status', true, '', 'string', array('A', 'D', 'P'));
        $auth->checkScope($params->getScopes());
        $handler = new Pap_Api_V2_Affiliates($params);
        $response->setResult($handler->changeStatus($id));
    } catch (Exception $e) {
        $response->setError($e);
    }
});

/*
 * Vat validity check
 */
$app->post('/billing/_check_vat', function () use ($app, $auth) {
    $params = new RestApi_Params($app->request());
    $response = new RestApi_Response($app->response());
    try { 
        $params->check('vatId', true, '', 'string', null);
        $handler = new Pap_Api_V3_Proxy($params);
        $response->setResult($handler->checkVat());
    } catch (Exception $e) {
        $response->setError($e);
    }
});

/*
 * Get coupon
 */
$app->get('/coupons/:couponCode', function ($couponCode) use ($app, $auth) {
    $params = new RestApi_Params($app->request());
    $response = new RestApi_Response($app->response());
    try { 
        $handler = new Pap_Api_V3_Proxy($params);
        $response->setResult($handler->getCoupon($couponCode));
    } catch (Exception $e) {
        $response->setError($e);
    }
});

/*
 * 
 */
$app->get('/campaigns', function () use ($app, $auth) {
    $params = new RestApi_Params($app->request(), array('campaign.read'));
    $response = new RestApi_Response($app->response());
    try { 
        $params->check('_page', false, '1', 'int', null);
        $params->check('_perPage', false, '30', 'int', null);
        $params->check('_sortDir', false, 'ASC', 'string', array('ASC', 'DESC'));
        $params->check('_sortField', false, '', 'string', null);
        $params->check('_filters', false, '', 'string', null);
        $params->check('_fields', false, '', 'string[]', null);
        $auth->checkScope($params->getScopes());
        $handler = new Pap_Api_V2_Campaigns($params);
        $response->setResult($handler->getList());
    } catch (Exception $e) {
        $response->setError($e);
    }
});

/*
 * Get informations about campaign.
 */
$app->get('/campaigns/:id', function ($id) use ($app, $auth) {
    $params = new RestApi_Params($app->request(), array('campaign.read'));
    $response = new RestApi_Response($app->response());
    try { 
        $params->check('_fields', false, '', 'string[]', null);
        $auth->checkScope($params->getScopes());
        $handler = new Pap_Api_V2_Campaigns($params);
        $response->setResult($handler->get($id));
    } catch (Exception $e) {
        $response->setError($e);
    }
});

/*
 * List of available countries
 */
$app->get('/countries/', function () use ($app, $auth) {
    $params = new RestApi_Params($app->request());
    $response = new RestApi_Response($app->response());
    try { 
        $handler = new Pap_Api_V3_Proxy($params);
        $response->setResult($handler->getCountries());
    } catch (Exception $e) {
        $response->setError($e);
    }
});

/*
 * 
 */
$app->get('/directlinks', function () use ($app, $auth) {
    $params = new RestApi_Params($app->request(), array('direct_link.read_own'));
    $response = new RestApi_Response($app->response());
    try { 
        $params->check('_page', false, '1', 'int', null);
        $params->check('_perPage', false, '30', 'int', null);
        $params->check('_sortDir', false, 'ASC', 'string', array('ASC', 'DESC'));
        $params->check('_sortField', false, '', 'string', null);
        $params->check('_filters', false, '', 'string', null);
        $params->check('_fields', false, '', 'string[]', null);
        $auth->checkScope($params->getScopes());
        $handler = new Pap_Api_V2_DirectLinks($params);
        $response->setResult($handler->getList());
    } catch (Exception $e) {
        $response->setError($e);
    }
});

/*
 * Update transaction status.
 */
$app->put('/directlinks/:id/_changeStatus', function ($id) use ($app, $auth) {
    $params = new RestApi_Params($app->request(), array('direct_link.write'));
    $response = new RestApi_Response($app->response());
    try { 
        $params->check('status', true, '', 'string', array('A', 'D', 'P'));
        $params->check('note', false, '', 'string', null);
        $auth->checkScope($params->getScopes());
        $handler = new Pap_Api_V2_DirectLinks($params);
        $response->setResult($handler->changeStatus($id));
    } catch (Exception $e) {
        $response->setError($e);
    }
});

/*
 * 
 */
$app->put('/emails/:id/setErrorMessage', function ($id) use ($app, $auth) {
    $params = new RestApi_Params($app->request(), array('mail_outbox.write'));
    $response = new RestApi_Response($app->response());
    try { 
        $auth->checkScope($params->getScopes());
        $data = new Pap_Api_Model_Message($params->getBody());
        $data->check();
        $handler = new Pap_Api_V2_Emails($params);
        $response->setResult($handler->setErrorMessage($id, $data));
    } catch (Exception $e) {
        $response->setError($e);
    }
});

/*
 * Get affiliate fields.
 */
$app->get('/affiliatefields', function () use ($app, $auth) {
    $params = new RestApi_Params($app->request(), array('affiliate.read'));
    $response = new RestApi_Response($app->response());
    try { 
        $params->check('_fieldStatuses', false, '', 'string[]', null);
        $params->check('_fieldType', false, '', 'string', array('T', 'N', 'L', 'A', 'B', 'G', 'R', 'E', 'C', ''));
        $auth->checkScope($params->getScopes());
        $handler = new Pap_Api_V2_FormFields($params);
        $response->setResult($handler->getAffiliateFields());
    } catch (Exception $e) {
        $response->setError($e);
    }
});

/*
 * LiveAgent account installation progress
 */
$app->get('/lasubscriptions/install_progress', function () use ($app, $auth) {
    $params = new RestApi_Params($app->request());
    $response = new RestApi_Response($app->response());
    try { 
        $handler = new Pap_Api_V3_Proxy($params);
        $response->setResult($handler->getLaInstallProgress());
    } catch (Exception $e) {
        $response->setError($e);
    }
});

/*
 * Create la trial accountsubscription
 */
$app->post('/lasubscriptions/', function () use ($app, $auth) {
    $params = new RestApi_Params($app->request(), array('live_agent_config.write'));
    $response = new RestApi_Response($app->response());
    try { 
        $auth->checkScope($params->getScopes());
        $data = new Pap_Api_Model_LaSignup($params->getBody());
        $data->check();
        $handler = new Pap_Api_V3_Proxy($params);
        $response->setResult($handler->createLaSubscription($data));
    } catch (Exception $e) {
        $response->setError($e);
    }
});

/*
 * Subscribe to push notifications.
 */
$app->post('/pushnotifications', function () use ($app, $auth) {
    $params = new RestApi_Params($app->request(), array('transaction.read', 'direct_link.read_own', 'affiliate.read', 'direct_link.read', 'transaction.read_own'));
    $response = new RestApi_Response($app->response());
    try { 
        $auth->checkScope($params->getScopes());
        $data = new Pap_Api_Model_PushNotificationRegistration($params->getBody());
        $data->check();
        $handler = new Pap_Api_V2_PushNotification($params);
        $response->setResult($handler->add($data));
    } catch (Exception $e) {
        $response->setError($e);
    }
});

/*
 * Unsubscribe from push notifications.
 */
$app->delete('/pushnotifications/:pushToken', function ($pushToken) use ($app, $auth) {
    $params = new RestApi_Params($app->request());
    $response = new RestApi_Response($app->response());
    try { 
        $handler = new Pap_Api_V2_PushNotification($params);
        $response->setResult($handler->delete($pushToken));
    } catch (Exception $e) {
        $response->setError($e);
    }
});

/*
 * Get push notification details per user and device.
 */
$app->get('/pushnotifications/:pushToken', function ($pushToken) use ($app, $auth) {
    $params = new RestApi_Params($app->request());
    $response = new RestApi_Response($app->response());
    try { 
        $handler = new Pap_Api_V2_PushNotification($params);
        $response->setResult($handler->get($pushToken));
    } catch (Exception $e) {
        $response->setError($e);
    }
});

/*
 * Get &#x60;Message&#x60; object when request hits server API.
 */
$app->get('/ping', function () use ($app, $auth) {
    $params = new RestApi_Params($app->request());
    $response = new RestApi_Response($app->response());
    try { 
        $handler = new Pap_Api_V2_Common($params);
        $response->setResult($handler->getPing());
    } catch (Exception $e) {
        $response->setError($e);
    }
});

/*
 * Request password reset.
 */
$app->post('/resetpassword', function () use ($app, $auth) {
    $params = new RestApi_Params($app->request());
    $response = new RestApi_Response($app->response());
    try { 
        $params->check('username', true, '', 'string', null);
        $handler = new RestApi_Token($params);
        $response->setResult($handler->resetpassword());
    } catch (Exception $e) {
        $response->setError($e);
    }
});

/*
 * Get application settings.
 */
$app->get('/settings', function () use ($app, $auth) {
    $params = new RestApi_Params($app->request());
    $response = new RestApi_Response($app->response());
    try { 
        $handler = new Pap_Api_V2_Settings($params);
        $response->setResult($handler->get());
    } catch (Exception $e) {
        $response->setError($e);
    }
});

/*
 * Agree with additional billing
 */
$app->post('/subscriptions/:subscriptionId/request_billing', function ($subscriptionId) use ($app, $auth) {
    $params = new RestApi_Params($app->request(), array('hosting_account.write'));
    $response = new RestApi_Response($app->response());
    try { 
        $auth->checkScope($params->getScopes());
        $handler = new Pap_Api_V3_Proxy($params);
        $response->setResult($handler->agreeRequestBilling($subscriptionId));
    } catch (Exception $e) {
        $response->setError($e);
    }
});

/*
 * Returns all active discounts for specified subscription
 */
$app->get('/subscriptions/:subscriptionId/discounts', function ($subscriptionId) use ($app, $auth) {
    $params = new RestApi_Params($app->request(), array('hosting_account.read'));
    $response = new RestApi_Response($app->response());
    try { 
        $auth->checkScope($params->getScopes());
        $handler = new Pap_Api_V3_Proxy($params);
        $response->setResult($handler->getDiscounts($subscriptionId));
    } catch (Exception $e) {
        $response->setError($e);
    }
});

/*
 * Get agreement of additional billing
 */
$app->get('/subscriptions/:subscriptionId/request_billing', function ($subscriptionId) use ($app, $auth) {
    $params = new RestApi_Params($app->request(), array('hosting_account.read'));
    $response = new RestApi_Response($app->response());
    try { 
        $auth->checkScope($params->getScopes());
        $handler = new Pap_Api_V3_Proxy($params);
        $response->setResult($handler->isAgreedRequestBilling($subscriptionId));
    } catch (Exception $e) {
        $response->setError($e);
    }
});

/*
 * Active subscription addons
 */
$app->get('/subscriptions/:subscriptionId/addons/', function ($subscriptionId) use ($app, $auth) {
    $params = new RestApi_Params($app->request(), array('hosting_account.read'));
    $response = new RestApi_Response($app->response());
    try { 
        $auth->checkScope($params->getScopes());
        $handler = new Pap_Api_V3_Proxy($params);
        $response->setResult($handler->getAddons($subscriptionId));
    } catch (Exception $e) {
        $response->setError($e);
    }
});

/*
 * Change active subscription addons
 */
$app->put('/subscriptions/:subscriptionId/addons/', function ($subscriptionId) use ($app, $auth) {
    $params = new RestApi_Params($app->request(), array('hosting_account.write'));
    $response = new RestApi_Response($app->response());
    try { 
        $auth->checkScope($params->getScopes());
        $data = new Pap_Api_Model_AddonList($params->getBody());
        $data->check();
        $handler = new Pap_Api_V3_Proxy($params);
        $response->setResult($handler->changeAddons($subscriptionId, $data));
    } catch (Exception $e) {
        $response->setError($e);
    }
});

/*
 * Subscription attributes list
 */
$app->get('/subscriptions/:subscriptionId/attributes/', function ($subscriptionId) use ($app, $auth) {
    $params = new RestApi_Params($app->request(), array('hosting_account.read'));
    $response = new RestApi_Response($app->response());
    try { 
        $auth->checkScope($params->getScopes());
        $handler = new Pap_Api_V3_Proxy($params);
        $response->setResult($handler->getSubscriptionAttributes($subscriptionId));
    } catch (Exception $e) {
        $response->setError($e);
    }
});

/*
 * Get billing info
 */
$app->get('/subscriptions/:subscriptionId/billingInfo', function ($subscriptionId) use ($app, $auth) {
    $params = new RestApi_Params($app->request(), array('hosting_account.read'));
    $response = new RestApi_Response($app->response());
    try { 
        $auth->checkScope($params->getScopes());
        $handler = new Pap_Api_V3_Proxy($params);
        $response->setResult($handler->getBillingInfo($subscriptionId));
    } catch (Exception $e) {
        $response->setError($e);
    }
});

/*
 * Update billing info
 */
$app->put('/subscriptions/:subscriptionId/billingInfo', function ($subscriptionId) use ($app, $auth) {
    $params = new RestApi_Params($app->request(), array('hosting_account.write'));
    $response = new RestApi_Response($app->response());
    try { 
        $auth->checkScope($params->getScopes());
        $data = new Pap_Api_Model_BillingInfo($params->getBody());
        $data->check();
        $handler = new Pap_Api_V3_Proxy($params);
        $response->setResult($handler->updateBillingInfo($subscriptionId, $data));
    } catch (Exception $e) {
        $response->setError($e);
    }
});

/*
 * Get billing metrics
 */
$app->get('/subscriptions/:subscriptionId/billingMetrics', function ($subscriptionId) use ($app, $auth) {
    $params = new RestApi_Params($app->request(), array('hosting_account.read'));
    $response = new RestApi_Response($app->response());
    try { 
        $auth->checkScope($params->getScopes());
        $handler = new Pap_Api_V3_Proxy($params);
        $response->setResult($handler->getBillingMetrics($subscriptionId));
    } catch (Exception $e) {
        $response->setError($e);
    }
});

/*
 * Get billing status
 */
$app->get('/subscriptions/:subscriptionId/billingStatus', function ($subscriptionId) use ($app, $auth) {
    $params = new RestApi_Params($app->request(), array('hosting_account.read'));
    $response = new RestApi_Response($app->response());
    try { 
        $auth->checkScope($params->getScopes());
        $handler = new Pap_Api_V3_Proxy($params);
        $response->setResult($handler->getBillingStatus($subscriptionId));
    } catch (Exception $e) {
        $response->setError($e);
    }
});

/*
 * Get payment method
 */
$app->get('/subscriptions/:subscriptionId/paymentMethod', function ($subscriptionId) use ($app, $auth) {
    $params = new RestApi_Params($app->request(), array('hosting_account.read'));
    $response = new RestApi_Response($app->response());
    try { 
        $auth->checkScope($params->getScopes());
        $handler = new Pap_Api_V3_Proxy($params);
        $response->setResult($handler->getPaymentMethod($subscriptionId));
    } catch (Exception $e) {
        $response->setError($e);
    }
});

/*
 * Update payment method
 */
$app->put('/subscriptions/:subscriptionId/paymentMethod', function ($subscriptionId) use ($app, $auth) {
    $params = new RestApi_Params($app->request(), array('hosting_account.write'));
    $response = new RestApi_Response($app->response());
    try { 
        $auth->checkScope($params->getScopes());
        $data = new Pap_Api_Model_PaymentMethod($params->getBody());
        $data->check();
        $handler = new Pap_Api_V3_Proxy($params);
        $response->setResult($handler->updatePaymentMethod($subscriptionId, $data));
    } catch (Exception $e) {
        $response->setError($e);
    }
});

/*
 * Get payment processor to generate token for when updating payment method
 */
$app->get('/subscriptions/:subscriptionId/paymentProcessor', function ($subscriptionId) use ($app, $auth) {
    $params = new RestApi_Params($app->request(), array('hosting_account.read'));
    $response = new RestApi_Response($app->response());
    try { 
        $params->check('paymentType', true, '', 'string', array('card', 'paypal'));
        $params->check('country', false, '', 'string', null);
        $auth->checkScope($params->getScopes());
        $handler = new Pap_Api_V3_Proxy($params);
        $response->setResult($handler->getProcessorType($subscriptionId));
    } catch (Exception $e) {
        $response->setError($e);
    }
});

/*
 * List of variations user can upgrade to and their current variation.
 */
$app->get('/subscriptions/:subscriptionId/upgradeVariations', function ($subscriptionId) use ($app, $auth) {
    $params = new RestApi_Params($app->request(), array('hosting_account.read'));
    $response = new RestApi_Response($app->response());
    try { 
        $params->check('country', false, '', 'string', null);
        $params->check('vatId', false, '', 'string', null);
        $auth->checkScope($params->getScopes());
        $handler = new Pap_Api_V3_Proxy($params);
        $response->setResult($handler->getVariationUpgrades($subscriptionId));
    } catch (Exception $e) {
        $response->setError($e);
    }
});

/*
 * If account billing is stopped, restart it.
 */
$app->post('/subscriptions/:subscriptionId/_cancelStop', function ($subscriptionId) use ($app, $auth) {
    $params = new RestApi_Params($app->request(), array('hosting_account.write'));
    $response = new RestApi_Response($app->response());
    try { 
        $auth->checkScope($params->getScopes());
        $handler = new Pap_Api_V3_Proxy($params);
        $response->setResult($handler->resumeBilling($subscriptionId));
    } catch (Exception $e) {
        $response->setError($e);
    }
});

/*
 * Stop account. Account won&#39;t be billed anymore and will continue to work till next billing date.
 */
$app->post('/subscriptions/:subscriptionId/_stop', function ($subscriptionId) use ($app, $auth) {
    $params = new RestApi_Params($app->request(), array('hosting_account.write'));
    $response = new RestApi_Response($app->response());
    try { 
        $auth->checkScope($params->getScopes());
        $handler = new Pap_Api_V3_Proxy($params);
        $response->setResult($handler->stopBilling($subscriptionId));
    } catch (Exception $e) {
        $response->setError($e);
    }
});

/*
 * Upgrade subscription to another variation. In case of upgrade from paid to paid, it&#39;s possible to change country without changing payment method. If change is between EU and not EU, different payment rules might apply.
 */
$app->post('/subscriptions/:subscriptionId/_upgrade', function ($subscriptionId) use ($app, $auth) {
    $params = new RestApi_Params($app->request(), array('hosting_account.write'));
    $response = new RestApi_Response($app->response());
    try { 
        $auth->checkScope($params->getScopes());
        $data = new Pap_Api_Model_Upgrade($params->getBody());
        $data->check();
        $handler = new Pap_Api_V3_Proxy($params);
        $response->setResult($handler->changePlan($subscriptionId, $data));
    } catch (Exception $e) {
        $response->setError($e);
    }
});

/*
 * Checks if billing info can be updated without issues. Field &#39;force&#39; in BillingInfo is ignored in this call.
 */
$app->post('/subscriptions/:subscriptionId/_validateBillingInfo', function ($subscriptionId) use ($app, $auth) {
    $params = new RestApi_Params($app->request(), array('hosting_account.write'));
    $response = new RestApi_Response($app->response());
    try { 
        $auth->checkScope($params->getScopes());
        $data = new Pap_Api_Model_BillingInfo($params->getBody());
        $data->check();
        $handler = new Pap_Api_V3_Proxy($params);
        $response->setResult($handler->validateBillingInfo($subscriptionId, $data));
    } catch (Exception $e) {
        $response->setError($e);
    }
});

/*
 * Get server timezone difference in seconds.
 */
$app->get('/synctime', function () use ($app, $auth) {
    $params = new RestApi_Params($app->request());
    $response = new RestApi_Response($app->response());
    try { 
        $params->check('clientTime', true, '', 'string', null);
        $handler = new Pap_Api_V2_Settings($params);
        $response->setResult($handler->syncTime());
    } catch (Exception $e) {
        $response->setError($e);
    }
});

/*
 * Get Message object which includes server api version
 */
$app->get('/apiversion', function () use ($app, $auth) {
    $params = new RestApi_Params($app->request());
    $response = new RestApi_Response($app->response());
    try { 
        $handler = new Pap_Api_V2_Common($params);
        $response->setResult($handler->getApplicationVersion());
    } catch (Exception $e) {
        $response->setError($e);
    }
});

/*
 * Return access token.
 */
$app->get('/token', function () use ($app, $auth) {
    $params = new RestApi_Params($app->request());
    $response = new RestApi_Response($app->response());
    try { 
        $params->check('username', true, '', 'string', null);
        $params->check('password', true, '', 'string', null);
        $handler = new RestApi_Token($params);
        $response->setResult($handler->get());
    } catch (Exception $e) {
        $response->setError($e);
    }
});

/*
 * Get traffic summary data of specified period.
 */
$app->get('/traffic', function () use ($app, $auth) {
    $params = new RestApi_Params($app->request(), array('transaction.read', 'transaction.read_own'));
    $response = new RestApi_Response($app->response());
    try { 
        $params->check('from', true, '', 'string', null);
        $params->check('to', false, '', 'string', null);
        $auth->checkScope($params->getScopes());
        $handler = new Pap_Api_V2_Traffic($params);
        $response->setResult($handler->get());
    } catch (Exception $e) {
        $response->setError($e);
    }
});

/*
 * Get traffic for current billing period.
 */
$app->get('/trafficinfo/currentTraffic', function () use ($app, $auth) {
    $params = new RestApi_Params($app->request(), array('hosting_account.read'));
    $response = new RestApi_Response($app->response());
    try { 
        $auth->checkScope($params->getScopes());
        $handler = new Pap_Api_V2_HostingTraffic($params);
        $response->setResult($handler->getCurrentTraffic());
    } catch (Exception $e) {
        $response->setError($e);
    }
});

/*
 * Get traffic chart data.
 */
$app->get('/trafficinfo/loadData', function () use ($app, $auth) {
    $params = new RestApi_Params($app->request(), array('hosting_account.read'));
    $response = new RestApi_Response($app->response());
    try { 
        $params->check('from', false, '', 'string', null);
        $params->check('to', false, '', 'string', null);
        $params->check('preset', false, '', 'string', null);
        $auth->checkScope($params->getScopes());
        $handler = new Pap_Api_V2_HostingTraffic($params);
        $response->setResult($handler->getTrafficChartData());
    } catch (Exception $e) {
        $response->setError($e);
    }
});

/*
 * Add transaction.
 */
$app->put('/transaction', function () use ($app, $auth) {
    $params = new RestApi_Params($app->request(), array('transaction.write'));
    $response = new RestApi_Response($app->response());
    try { 
        $params->check('processMultiTier', false, 'true', 'bool', null);
        $auth->checkScope($params->getScopes());
        $data = new Pap_Api_Model_Transaction($params->getBody());
        $data->check();
        $handler = new Pap_Api_V2_Transactions($params);
        $response->setResult($handler->add($data));
    } catch (Exception $e) {
        $response->setError($e);
    }
});

/*
 * Get list of transactions.
 */
$app->get('/transactions', function () use ($app, $auth) {
    $params = new RestApi_Params($app->request(), array('transaction.read', 'transaction.read_own'));
    $response = new RestApi_Response($app->response());
    try { 
        $params->check('_page', false, '1', 'int', null);
        $params->check('_perPage', false, '30', 'int', null);
        $params->check('_sortDir', false, 'ASC', 'string', array('ASC', 'DESC'));
        $params->check('_sortField', false, '', 'string', null);
        $params->check('_filters', false, '', 'string', null);
        $params->check('_fields', false, '', 'string[]', null);
        $auth->checkScope($params->getScopes());
        $handler = new Pap_Api_V2_Transactions($params);
        $response->setResult($handler->getList());
    } catch (Exception $e) {
        $response->setError($e);
    }
});

/*
 * Make refund or chargeback by Transaction Id.
 */
$app->post('/transactions/:id/chargebackById', function ($id) use ($app, $auth) {
    $params = new RestApi_Params($app->request(), array('transaction.write'));
    $response = new RestApi_Response($app->response());
    try { 
        $params->check('fee', false, '0', 'int', null);
        $params->check('note', false, '', 'string', null);
        $auth->checkScope($params->getScopes());
        $handler = new Pap_Api_V2_Transactions($params);
        $response->setResult($handler->makeChargebackById($id));
    } catch (Exception $e) {
        $response->setError($e);
    }
});

/*
 * Get informations about trasnaction.
 */
$app->get('/transactions/:id', function ($id) use ($app, $auth) {
    $params = new RestApi_Params($app->request(), array('transaction.read', 'transaction.read_own'));
    $response = new RestApi_Response($app->response());
    try { 
        $params->check('_fields', false, '', 'string[]', null);
        $auth->checkScope($params->getScopes());
        $handler = new Pap_Api_V2_Transactions($params);
        $response->setResult($handler->get($id));
    } catch (Exception $e) {
        $response->setError($e);
    }
});

/*
 * Make refund or chargeback by Transaction Id.
 */
$app->post('/transactions/:id/refundById', function ($id) use ($app, $auth) {
    $params = new RestApi_Params($app->request(), array('transaction.write'));
    $response = new RestApi_Response($app->response());
    try { 
        $params->check('fee', false, '0', 'int', null);
        $params->check('note', false, '', 'string', null);
        $auth->checkScope($params->getScopes());
        $handler = new Pap_Api_V2_Transactions($params);
        $response->setResult($handler->makeRefundById($id));
    } catch (Exception $e) {
        $response->setError($e);
    }
});

/*
 * Update transaction status.
 */
$app->put('/transactions/:id/_changeStatus', function ($id) use ($app, $auth) {
    $params = new RestApi_Params($app->request(), array('transaction.write'));
    $response = new RestApi_Response($app->response());
    try { 
        $params->check('status', true, '', 'string', array('A', 'D', 'P'));
        $params->check('note', false, '', 'string', null);
        $auth->checkScope($params->getScopes());
        $handler = new Pap_Api_V2_Transactions($params);
        $response->setResult($handler->changeStatus($id));
    } catch (Exception $e) {
        $response->setError($e);
    }
});

/*
 * Make refund or chargeback by Order Id.
 */
$app->post('/transactions/:orderId/chargebackByOrderId', function ($orderId) use ($app, $auth) {
    $params = new RestApi_Params($app->request(), array('transaction.write'));
    $response = new RestApi_Response($app->response());
    try { 
        $params->check('fee', false, '0', 'int', null);
        $params->check('note', false, '', 'string', null);
        $auth->checkScope($params->getScopes());
        $handler = new Pap_Api_V2_Transactions($params);
        $response->setResult($handler->makeChargebackByOrderId($orderId));
    } catch (Exception $e) {
        $response->setError($e);
    }
});

/*
 * Trigger recurring commission by Order Id.
 */
$app->post('/transactions/:orderId/createRecurringCommission', function ($orderId) use ($app, $auth) {
    $params = new RestApi_Params($app->request(), array('recurring_transaction.write'));
    $response = new RestApi_Response($app->response());
    try { 
        $params->check('totalCost', false, '', 'string', null);
        $auth->checkScope($params->getScopes());
        $handler = new Pap_Api_V2_Transactions($params);
        $response->setResult($handler->createRecurringCommission($orderId));
    } catch (Exception $e) {
        $response->setError($e);
    }
});

/*
 * Make refund or chargeback by Order Id.
 */
$app->post('/transactions/:orderId/refundByOrderId', function ($orderId) use ($app, $auth) {
    $params = new RestApi_Params($app->request(), array('transaction.write'));
    $response = new RestApi_Response($app->response());
    try { 
        $params->check('fee', false, '0', 'int', null);
        $params->check('note', false, '', 'string', null);
        $auth->checkScope($params->getScopes());
        $handler = new Pap_Api_V2_Transactions($params);
        $response->setResult($handler->makeRefundByOrderId($orderId));
    } catch (Exception $e) {
        $response->setError($e);
    }
});

/*
 * 
 */
$app->get('/users', function () use ($app, $auth) {
    $params = new RestApi_Params($app->request(), array('merchant.read', 'aff_myprofile.read', 'myprofile.read', 'affiliate.read'));
    $response = new RestApi_Response($app->response());
    try { 
        $params->check('_page', false, '1', 'int', null);
        $params->check('_perPage', false, '30', 'int', null);
        $params->check('_sortDir', false, 'ASC', 'string', array('ASC', 'DESC'));
        $params->check('_sortField', false, '', 'string', null);
        $params->check('_filters', false, '', 'string', null);
        $params->check('_fields', false, '', 'string[]', null);
        $params->check('users_type', false, 'A', 'string', array('A', 'M'));
        $auth->checkScope($params->getScopes());
        $handler = new Pap_Api_V2_Users($params);
        $response->setResult($handler->getList());
    } catch (Exception $e) {
        $response->setError($e);
    }
});

/*
 * Get informations about specified user.
 */
$app->get('/users/:userId', function ($userId) use ($app, $auth) {
    $params = new RestApi_Params($app->request(), array('merchant.read', 'aff_myprofile.read', 'myprofile.read', 'affiliate.read'));
    $response = new RestApi_Response($app->response());
    try { 
        $params->check('_fields', false, '', 'string[]', null);
        $auth->checkScope($params->getScopes());
        $handler = new Pap_Api_V2_Users($params);
        $response->setResult($handler->get($userId));
    } catch (Exception $e) {
        $response->setError($e);
    }
});

/*
 * Get user login redirect
 */
$app->post('/users/:userId/_login', function ($userId) use ($app, $auth) {
    $params = new RestApi_Params($app->request(), array('hosting.login'));
    $response = new RestApi_Response($app->response());
    try { 
        $auth->checkScope($params->getScopes());
        $handler = new Pap_Api_V2_Users($params);
        $response->setResult($handler->loginUser($userId));
    } catch (Exception $e) {
        $response->setError($e);
    }
});

/*
 * Returns addons which are not allowed in new variation
 */
$app->get('/variations/:variationId/addonsForDeactivation', function ($variationId) use ($app, $auth) {
    $params = new RestApi_Params($app->request(), array('hosting_account.write'));
    $response = new RestApi_Response($app->response());
    try { 
        $auth->checkScope($params->getScopes());
        $handler = new Pap_Api_V2_Addons($params);
        $response->setResult($handler->getAddonsNamesForDeactivation($variationId));
    } catch (Exception $e) {
        $response->setError($e);
    }
});

/*
 * Returns addons available to specified variation.
 */
$app->get('/variations/:variationId/addons', function ($variationId) use ($app, $auth) {
    $params = new RestApi_Params($app->request());
    $response = new RestApi_Response($app->response());
    try { 
        $handler = new Pap_Api_V3_Proxy($params);
        $response->setResult($handler->getAllVariationAddons($variationId));
    } catch (Exception $e) {
        $response->setError($e);
    }
});

/*
 * Returns addons available to specified variation.
 */
$app->get('/variations/:variationId/available_addons', function ($variationId) use ($app, $auth) {
    $params = new RestApi_Params($app->request());
    $response = new RestApi_Response($app->response());
    try { 
        $handler = new Pap_Api_V3_Proxy($params);
        $response->setResult($handler->getVariationAddons($variationId));
    } catch (Exception $e) {
        $response->setError($e);
    }
});

/*
 * Get visitorAffiliate from visitor ID (cookie).
 */
$app->get('/visitorAffiliateProcessor', function () use ($app, $auth) {
    $params = new RestApi_Params($app->request(), array('visitor_affiliates.read'));
    $response = new RestApi_Response($app->response());
    try { 
        $params->check('visitorId', true, '', 'string', null);
        $params->check('accountId', false, '', 'string', null);
        $auth->checkScope($params->getScopes());
        $handler = new Pap_Api_V2_VisitorAffiliateProcessor($params);
        $response->setResult($handler->get());
    } catch (Exception $e) {
        $response->setError($e);
    }
});

RestApi_Make::run($app);
